<?php

namespace RelatieApiV3\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PersooninfoRecV3 StructType
 * Meta information extracted from the WSDL
 * - documentation: Persoongegevens
 * @subpackage Structs
 * @date 20200204
 * @package RelatieApiV3
 */
class PersooninfoRecV3 extends AbstractStructBase
{
    /**
     * The persoon
     * Meta information extracted from the WSDL
     * - documentation: De gegevens van de persoon
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \RelatieApiV3\StructType\PersoonRecV3
     */
    public $persoon;
    /**
     * The leververbod
     * Meta information extracted from the WSDL
     * - documentation: De persoon heeft een leververbod
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $leververbod;
    /**
     * The functies
     * Meta information extracted from the WSDL
     * - documentation: De functies van de persoon
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \RelatieApiV3\StructType\RelatieFunctietableV3
     */
    public $functies;
    /**
     * The biccodes
     * Meta information extracted from the WSDL
     * - documentation: De biccodes van de persoon
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \RelatieApiV3\StructType\RelatieBiccodetableV3
     */
    public $biccodes;
    /**
     * Constructor method for PersooninfoRecV3
     * @uses PersooninfoRecV3::setPersoon()
     * @uses PersooninfoRecV3::setLeververbod()
     * @uses PersooninfoRecV3::setFuncties()
     * @uses PersooninfoRecV3::setBiccodes()
     * @param \RelatieApiV3\StructType\PersoonRecV3 $persoon
     * @param bool $leververbod
     * @param \RelatieApiV3\StructType\RelatieFunctietableV3 $functies
     * @param \RelatieApiV3\StructType\RelatieBiccodetableV3 $biccodes
     */
    public function __construct(\RelatieApiV3\StructType\PersoonRecV3 $persoon = null, $leververbod = null, \RelatieApiV3\StructType\RelatieFunctietableV3 $functies = null, \RelatieApiV3\StructType\RelatieBiccodetableV3 $biccodes = null)
    {
        $this
            ->setPersoon($persoon)
            ->setLeververbod($leververbod)
            ->setFuncties($functies)
            ->setBiccodes($biccodes);
    }
    /**
     * Get persoon value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \RelatieApiV3\StructType\PersoonRecV3|null
     */
    public function getPersoon()
    {
        return isset($this->persoon) ? $this->persoon : null;
    }
    /**
     * Set persoon value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \RelatieApiV3\StructType\PersoonRecV3 $persoon
     * @return \RelatieApiV3\StructType\PersooninfoRecV3
     */
    public function setPersoon(\RelatieApiV3\StructType\PersoonRecV3 $persoon = null)
    {
        if (is_null($persoon) || (is_array($persoon) && empty($persoon))) {
            unset($this->persoon);
        } else {
            $this->persoon = $persoon;
        }
        return $this;
    }
    /**
     * Get leververbod value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getLeververbod()
    {
        return isset($this->leververbod) ? $this->leververbod : null;
    }
    /**
     * Set leververbod value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $leververbod
     * @return \RelatieApiV3\StructType\PersooninfoRecV3
     */
    public function setLeververbod($leververbod = null)
    {
        // validation for constraint: boolean
        if (!is_null($leververbod) && !is_bool($leververbod)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($leververbod, true), gettype($leververbod)), __LINE__);
        }
        if (is_null($leververbod) || (is_array($leververbod) && empty($leververbod))) {
            unset($this->leververbod);
        } else {
            $this->leververbod = $leververbod;
        }
        return $this;
    }
    /**
     * Get functies value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \RelatieApiV3\StructType\RelatieFunctietableV3|null
     */
    public function getFuncties()
    {
        return isset($this->functies) ? $this->functies : null;
    }
    /**
     * Set functies value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \RelatieApiV3\StructType\RelatieFunctietableV3 $functies
     * @return \RelatieApiV3\StructType\PersooninfoRecV3
     */
    public function setFuncties(\RelatieApiV3\StructType\RelatieFunctietableV3 $functies = null)
    {
        if (is_null($functies) || (is_array($functies) && empty($functies))) {
            unset($this->functies);
        } else {
            $this->functies = $functies;
        }
        return $this;
    }
    /**
     * Get biccodes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \RelatieApiV3\StructType\RelatieBiccodetableV3|null
     */
    public function getBiccodes()
    {
        return isset($this->biccodes) ? $this->biccodes : null;
    }
    /**
     * Set biccodes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \RelatieApiV3\StructType\RelatieBiccodetableV3 $biccodes
     * @return \RelatieApiV3\StructType\PersooninfoRecV3
     */
    public function setBiccodes(\RelatieApiV3\StructType\RelatieBiccodetableV3 $biccodes = null)
    {
        if (is_null($biccodes) || (is_array($biccodes) && empty($biccodes))) {
            unset($this->biccodes);
        } else {
            $this->biccodes = $biccodes;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \RelatieApiV3\StructType\PersooninfoRecV3
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
