<?php

namespace RelatieApiV3\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for NetnummertableV3 StructType
 * Meta information extracted from the WSDL
 * - documentation: Lijst met beschikbare netnummers
 * @subpackage Structs
 * @date 20200204
 * @package RelatieApiV3
 */
class NetnummertableV3 extends AbstractStructBase
{
    /**
     * The netnummer
     * Meta information extracted from the WSDL
     * - documentation: Netnummers
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: false
     * @var \RelatieApiV3\StructType\NetnummerRecV3[]
     */
    public $netnummer;
    /**
     * Constructor method for NetnummertableV3
     * @uses NetnummertableV3::setNetnummer()
     * @param \RelatieApiV3\StructType\NetnummerRecV3[] $netnummer
     */
    public function __construct(array $netnummer = array())
    {
        $this
            ->setNetnummer($netnummer);
    }
    /**
     * Get netnummer value
     * @return \RelatieApiV3\StructType\NetnummerRecV3[]|null
     */
    public function getNetnummer()
    {
        return $this->netnummer;
    }
    /**
     * This method is responsible for validating the values passed to the setNetnummer method
     * This method is willingly generated in order to preserve the one-line inline validation within the setNetnummer method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateNetnummerForArrayConstraintsFromSetNetnummer(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $netnummertableV3NetnummerItem) {
            // validation for constraint: itemType
            if (!$netnummertableV3NetnummerItem instanceof \RelatieApiV3\StructType\NetnummerRecV3) {
                $invalidValues[] = is_object($netnummertableV3NetnummerItem) ? get_class($netnummertableV3NetnummerItem) : sprintf('%s(%s)', gettype($netnummertableV3NetnummerItem), var_export($netnummertableV3NetnummerItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The netnummer property can only contain items of type \RelatieApiV3\StructType\NetnummerRecV3, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set netnummer value
     * @throws \InvalidArgumentException
     * @param \RelatieApiV3\StructType\NetnummerRecV3[] $netnummer
     * @return \RelatieApiV3\StructType\NetnummertableV3
     */
    public function setNetnummer(array $netnummer = array())
    {
        // validation for constraint: array
        if ('' !== ($netnummerArrayErrorMessage = self::validateNetnummerForArrayConstraintsFromSetNetnummer($netnummer))) {
            throw new \InvalidArgumentException($netnummerArrayErrorMessage, __LINE__);
        }
        $this->netnummer = $netnummer;
        return $this;
    }
    /**
     * Add item to netnummer value
     * @throws \InvalidArgumentException
     * @param \RelatieApiV3\StructType\NetnummerRecV3 $item
     * @return \RelatieApiV3\StructType\NetnummertableV3
     */
    public function addToNetnummer(\RelatieApiV3\StructType\NetnummerRecV3 $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \RelatieApiV3\StructType\NetnummerRecV3) {
            throw new \InvalidArgumentException(sprintf('The netnummer property can only contain items of type \RelatieApiV3\StructType\NetnummerRecV3, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->netnummer[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \RelatieApiV3\StructType\NetnummertableV3
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
