<?php

namespace RelatieApiV3\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for KenmerktableV3 StructType
 * Meta information extracted from the WSDL
 * - documentation: Lijst met alle kenmerken
 * @subpackage Structs
 * @date 20200204
 * @package RelatieApiV3
 */
class KenmerktableV3 extends AbstractStructBase
{
    /**
     * The kenmerk
     * Meta information extracted from the WSDL
     * - documentation: Kenmerken
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: false
     * @var \RelatieApiV3\StructType\KenmerkRecV3[]
     */
    public $kenmerk;
    /**
     * Constructor method for KenmerktableV3
     * @uses KenmerktableV3::setKenmerk()
     * @param \RelatieApiV3\StructType\KenmerkRecV3[] $kenmerk
     */
    public function __construct(array $kenmerk = array())
    {
        $this
            ->setKenmerk($kenmerk);
    }
    /**
     * Get kenmerk value
     * @return \RelatieApiV3\StructType\KenmerkRecV3[]|null
     */
    public function getKenmerk()
    {
        return $this->kenmerk;
    }
    /**
     * This method is responsible for validating the values passed to the setKenmerk method
     * This method is willingly generated in order to preserve the one-line inline validation within the setKenmerk method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateKenmerkForArrayConstraintsFromSetKenmerk(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $kenmerktableV3KenmerkItem) {
            // validation for constraint: itemType
            if (!$kenmerktableV3KenmerkItem instanceof \RelatieApiV3\StructType\KenmerkRecV3) {
                $invalidValues[] = is_object($kenmerktableV3KenmerkItem) ? get_class($kenmerktableV3KenmerkItem) : sprintf('%s(%s)', gettype($kenmerktableV3KenmerkItem), var_export($kenmerktableV3KenmerkItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The kenmerk property can only contain items of type \RelatieApiV3\StructType\KenmerkRecV3, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set kenmerk value
     * @throws \InvalidArgumentException
     * @param \RelatieApiV3\StructType\KenmerkRecV3[] $kenmerk
     * @return \RelatieApiV3\StructType\KenmerktableV3
     */
    public function setKenmerk(array $kenmerk = array())
    {
        // validation for constraint: array
        if ('' !== ($kenmerkArrayErrorMessage = self::validateKenmerkForArrayConstraintsFromSetKenmerk($kenmerk))) {
            throw new \InvalidArgumentException($kenmerkArrayErrorMessage, __LINE__);
        }
        $this->kenmerk = $kenmerk;
        return $this;
    }
    /**
     * Add item to kenmerk value
     * @throws \InvalidArgumentException
     * @param \RelatieApiV3\StructType\KenmerkRecV3 $item
     * @return \RelatieApiV3\StructType\KenmerktableV3
     */
    public function addToKenmerk(\RelatieApiV3\StructType\KenmerkRecV3 $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \RelatieApiV3\StructType\KenmerkRecV3) {
            throw new \InvalidArgumentException(sprintf('The kenmerk property can only contain items of type \RelatieApiV3\StructType\KenmerkRecV3, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->kenmerk[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \RelatieApiV3\StructType\KenmerktableV3
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
