<?php

namespace RelatieApiV3\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for KenmerkgroeptableV3 StructType
 * Meta information extracted from the WSDL
 * - documentation: Lijst met alle kenmerkgroepen
 * @subpackage Structs
 * @date 20200204
 * @package RelatieApiV3
 */
class KenmerkgroeptableV3 extends AbstractStructBase
{
    /**
     * The kenmerkgroep
     * Meta information extracted from the WSDL
     * - documentation: Kenmerkgroepen
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: false
     * @var \RelatieApiV3\StructType\KenmerkgroepRecV3[]
     */
    public $kenmerkgroep;
    /**
     * Constructor method for KenmerkgroeptableV3
     * @uses KenmerkgroeptableV3::setKenmerkgroep()
     * @param \RelatieApiV3\StructType\KenmerkgroepRecV3[] $kenmerkgroep
     */
    public function __construct(array $kenmerkgroep = array())
    {
        $this
            ->setKenmerkgroep($kenmerkgroep);
    }
    /**
     * Get kenmerkgroep value
     * @return \RelatieApiV3\StructType\KenmerkgroepRecV3[]|null
     */
    public function getKenmerkgroep()
    {
        return $this->kenmerkgroep;
    }
    /**
     * This method is responsible for validating the values passed to the setKenmerkgroep method
     * This method is willingly generated in order to preserve the one-line inline validation within the setKenmerkgroep method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateKenmerkgroepForArrayConstraintsFromSetKenmerkgroep(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $kenmerkgroeptableV3KenmerkgroepItem) {
            // validation for constraint: itemType
            if (!$kenmerkgroeptableV3KenmerkgroepItem instanceof \RelatieApiV3\StructType\KenmerkgroepRecV3) {
                $invalidValues[] = is_object($kenmerkgroeptableV3KenmerkgroepItem) ? get_class($kenmerkgroeptableV3KenmerkgroepItem) : sprintf('%s(%s)', gettype($kenmerkgroeptableV3KenmerkgroepItem), var_export($kenmerkgroeptableV3KenmerkgroepItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The kenmerkgroep property can only contain items of type \RelatieApiV3\StructType\KenmerkgroepRecV3, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set kenmerkgroep value
     * @throws \InvalidArgumentException
     * @param \RelatieApiV3\StructType\KenmerkgroepRecV3[] $kenmerkgroep
     * @return \RelatieApiV3\StructType\KenmerkgroeptableV3
     */
    public function setKenmerkgroep(array $kenmerkgroep = array())
    {
        // validation for constraint: array
        if ('' !== ($kenmerkgroepArrayErrorMessage = self::validateKenmerkgroepForArrayConstraintsFromSetKenmerkgroep($kenmerkgroep))) {
            throw new \InvalidArgumentException($kenmerkgroepArrayErrorMessage, __LINE__);
        }
        $this->kenmerkgroep = $kenmerkgroep;
        return $this;
    }
    /**
     * Add item to kenmerkgroep value
     * @throws \InvalidArgumentException
     * @param \RelatieApiV3\StructType\KenmerkgroepRecV3 $item
     * @return \RelatieApiV3\StructType\KenmerkgroeptableV3
     */
    public function addToKenmerkgroep(\RelatieApiV3\StructType\KenmerkgroepRecV3 $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \RelatieApiV3\StructType\KenmerkgroepRecV3) {
            throw new \InvalidArgumentException(sprintf('The kenmerkgroep property can only contain items of type \RelatieApiV3\StructType\KenmerkgroepRecV3, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->kenmerkgroep[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \RelatieApiV3\StructType\KenmerkgroeptableV3
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
