<?php

namespace RelatieApiV3\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for getFunctiesResponse StructType
 * Meta information extracted from the WSDL
 * - documentation: error42: Er zijn geen functies gevonden
 * @subpackage Structs
 * @date 20200204
 * @package RelatieApiV3
 */
class GetFunctiesResponse extends AbstractStructBase
{
    /**
     * The requestTag
     * Meta information extracted from the WSDL
     * - documentation: Vrij veld voor aanroepende partij. De inhoud van dit veld wordt altijd identiek teruggestuurd.
     * - base: xsd:string
     * - maxLength: 4000
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $requestTag;
    /**
     * The functies
     * Meta information extracted from the WSDL
     * - documentation: De beschikbare functies
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \RelatieApiV3\StructType\FunctietableV3
     */
    public $functies;
    /**
     * Constructor method for getFunctiesResponse
     * @uses GetFunctiesResponse::setRequestTag()
     * @uses GetFunctiesResponse::setFuncties()
     * @param string $requestTag
     * @param \RelatieApiV3\StructType\FunctietableV3 $functies
     */
    public function __construct($requestTag = null, \RelatieApiV3\StructType\FunctietableV3 $functies = null)
    {
        $this
            ->setRequestTag($requestTag)
            ->setFuncties($functies);
    }
    /**
     * Get requestTag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRequestTag()
    {
        return isset($this->requestTag) ? $this->requestTag : null;
    }
    /**
     * Set requestTag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $requestTag
     * @return \RelatieApiV3\StructType\GetFunctiesResponse
     */
    public function setRequestTag($requestTag = null)
    {
        // validation for constraint: string
        if (!is_null($requestTag) && !is_string($requestTag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($requestTag, true), gettype($requestTag)), __LINE__);
        }
        // validation for constraint: maxLength(4000)
        if (!is_null($requestTag) && mb_strlen($requestTag) > 4000) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 4000', mb_strlen($requestTag)), __LINE__);
        }
        if (is_null($requestTag) || (is_array($requestTag) && empty($requestTag))) {
            unset($this->requestTag);
        } else {
            $this->requestTag = $requestTag;
        }
        return $this;
    }
    /**
     * Get functies value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \RelatieApiV3\StructType\FunctietableV3|null
     */
    public function getFuncties()
    {
        return isset($this->functies) ? $this->functies : null;
    }
    /**
     * Set functies value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \RelatieApiV3\StructType\FunctietableV3 $functies
     * @return \RelatieApiV3\StructType\GetFunctiesResponse
     */
    public function setFuncties(\RelatieApiV3\StructType\FunctietableV3 $functies = null)
    {
        if (is_null($functies) || (is_array($functies) && empty($functies))) {
            unset($this->functies);
        } else {
            $this->functies = $functies;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \RelatieApiV3\StructType\GetFunctiesResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
