<?php

namespace RelatieApiV3\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for getContactpersoonResponse StructType
 * Meta information extracted from the WSDL
 * - documentation: error69: De relatie met het opgegeven relatienummer is niet van het type 'Bedrijf'. | error16: Op basis van het relatienummer is geen relatie gevonden | error15: Er is geen relatienummer opgegeven
 * @subpackage Structs
 * @date 20200204
 * @package RelatieApiV3
 */
class GetContactpersoonResponse extends AbstractStructBase
{
    /**
     * The requestTag
     * Meta information extracted from the WSDL
     * - documentation: Vrij veld voor aanroepende partij. De inhoud van dit veld wordt altijd identiek teruggestuurd.
     * - base: xsd:string
     * - maxLength: 4000
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $requestTag;
    /**
     * The contactpersoon
     * Meta information extracted from the WSDL
     * - documentation: De gegevens van de contactpersoon
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \RelatieApiV3\StructType\ContactpersooninfoRecV3
     */
    public $contactpersoon;
    /**
     * Constructor method for getContactpersoonResponse
     * @uses GetContactpersoonResponse::setRequestTag()
     * @uses GetContactpersoonResponse::setContactpersoon()
     * @param string $requestTag
     * @param \RelatieApiV3\StructType\ContactpersooninfoRecV3 $contactpersoon
     */
    public function __construct($requestTag = null, \RelatieApiV3\StructType\ContactpersooninfoRecV3 $contactpersoon = null)
    {
        $this
            ->setRequestTag($requestTag)
            ->setContactpersoon($contactpersoon);
    }
    /**
     * Get requestTag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRequestTag()
    {
        return isset($this->requestTag) ? $this->requestTag : null;
    }
    /**
     * Set requestTag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $requestTag
     * @return \RelatieApiV3\StructType\GetContactpersoonResponse
     */
    public function setRequestTag($requestTag = null)
    {
        // validation for constraint: string
        if (!is_null($requestTag) && !is_string($requestTag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($requestTag, true), gettype($requestTag)), __LINE__);
        }
        // validation for constraint: maxLength(4000)
        if (!is_null($requestTag) && mb_strlen($requestTag) > 4000) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 4000', mb_strlen($requestTag)), __LINE__);
        }
        if (is_null($requestTag) || (is_array($requestTag) && empty($requestTag))) {
            unset($this->requestTag);
        } else {
            $this->requestTag = $requestTag;
        }
        return $this;
    }
    /**
     * Get contactpersoon value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \RelatieApiV3\StructType\ContactpersooninfoRecV3|null
     */
    public function getContactpersoon()
    {
        return isset($this->contactpersoon) ? $this->contactpersoon : null;
    }
    /**
     * Set contactpersoon value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \RelatieApiV3\StructType\ContactpersooninfoRecV3 $contactpersoon
     * @return \RelatieApiV3\StructType\GetContactpersoonResponse
     */
    public function setContactpersoon(\RelatieApiV3\StructType\ContactpersooninfoRecV3 $contactpersoon = null)
    {
        if (is_null($contactpersoon) || (is_array($contactpersoon) && empty($contactpersoon))) {
            unset($this->contactpersoon);
        } else {
            $this->contactpersoon = $contactpersoon;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \RelatieApiV3\StructType\GetContactpersoonResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
