<?php

namespace RelatieApiV3\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FunctietableV3 StructType
 * Meta information extracted from the WSDL
 * - documentation: Lijst met functie codes
 * @subpackage Structs
 * @date 20200204
 * @package RelatieApiV3
 */
class FunctietableV3 extends AbstractStructBase
{
    /**
     * The functie
     * Meta information extracted from the WSDL
     * - documentation: Functies
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: false
     * @var \RelatieApiV3\StructType\FunctieRecV3[]
     */
    public $functie;
    /**
     * Constructor method for FunctietableV3
     * @uses FunctietableV3::setFunctie()
     * @param \RelatieApiV3\StructType\FunctieRecV3[] $functie
     */
    public function __construct(array $functie = array())
    {
        $this
            ->setFunctie($functie);
    }
    /**
     * Get functie value
     * @return \RelatieApiV3\StructType\FunctieRecV3[]|null
     */
    public function getFunctie()
    {
        return $this->functie;
    }
    /**
     * This method is responsible for validating the values passed to the setFunctie method
     * This method is willingly generated in order to preserve the one-line inline validation within the setFunctie method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateFunctieForArrayConstraintsFromSetFunctie(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $functietableV3FunctieItem) {
            // validation for constraint: itemType
            if (!$functietableV3FunctieItem instanceof \RelatieApiV3\StructType\FunctieRecV3) {
                $invalidValues[] = is_object($functietableV3FunctieItem) ? get_class($functietableV3FunctieItem) : sprintf('%s(%s)', gettype($functietableV3FunctieItem), var_export($functietableV3FunctieItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The functie property can only contain items of type \RelatieApiV3\StructType\FunctieRecV3, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set functie value
     * @throws \InvalidArgumentException
     * @param \RelatieApiV3\StructType\FunctieRecV3[] $functie
     * @return \RelatieApiV3\StructType\FunctietableV3
     */
    public function setFunctie(array $functie = array())
    {
        // validation for constraint: array
        if ('' !== ($functieArrayErrorMessage = self::validateFunctieForArrayConstraintsFromSetFunctie($functie))) {
            throw new \InvalidArgumentException($functieArrayErrorMessage, __LINE__);
        }
        $this->functie = $functie;
        return $this;
    }
    /**
     * Add item to functie value
     * @throws \InvalidArgumentException
     * @param \RelatieApiV3\StructType\FunctieRecV3 $item
     * @return \RelatieApiV3\StructType\FunctietableV3
     */
    public function addToFunctie(\RelatieApiV3\StructType\FunctieRecV3 $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \RelatieApiV3\StructType\FunctieRecV3) {
            throw new \InvalidArgumentException(sprintf('The functie property can only contain items of type \RelatieApiV3\StructType\FunctieRecV3, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->functie[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \RelatieApiV3\StructType\FunctietableV3
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
