<?php

namespace RelatieApiV3\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for createBedrijfResponse StructType
 * Meta information extracted from the WSDL
 * - documentation: error100: Op basis van de input bestaan al meerdere relaties | error72: De opgegeven valutacode is niet gevonden | error71: De opgegeven taalcode is niet gevonden | error60: Er is een ongeldig BTW-nummer meegegeven | error58: Bij
 * BTW-indicatie intra-communautair is een BTW-nummer verplicht | error54: Op basis van de opgegeven waarde voor codeveld 6 is niets gevonden | error53: Op basis van de opgegeven waarde voor codeveld 5 is niets gevonden | error52: Op basis van de
 * opgegeven waarde voor codeveld 4 is niets gevonden | error51: Op basis van de opgegeven waarde voor codeveld 3 is niets gevonden | error50: Op basis van de opgegeven waarde voor codeveld 2 is niets gevonden | error49: Op basis van de opgegeven waarde
 * voor codeveld 1 is niets gevonden | error48: De opgegeven relatie kortinggroepcode is niet gevonden | error46: De opgegeven plaatsnaam komt niet overeen met de plaatsnaam behorende bij de postcode/huisnummer combinatie | error45: De opgegeven
 * straatnaam komt niet overeen met de straatnaam behorende bij de postcode/huisnummer combinatie | error41: Het opgegeven (NL-) IBAN nummer en de BIC code horen niet bij elkaar | error40: De opgegeven bic code is niet geldig | error39: Het opgegeven
 * IBAN nummer voldoet niet aan de eisen | error38: Bij automatische incasso is een iban nummer verplicht | error37: Het opgegeven bankrekeningnummer voldoet niet aan de 11-proef | error36: Bij automatische incasso is een bankrekeningnummer verplicht |
 * error35: De opgegeven betaalwijze is niet geldig | error21: Het opgegeven faxnummer is ongeldig | error20: Het e-mail adres (2) is niet valide | error19: Er is voor het bedrijf geen naam opgegeven | error9: Het opgegeven telefoonnummer is niet valide
 * | error8: Het e-mail adres (1) is niet valide | error6: Provincie komt niet voor in het opgegeven land | error5: Indien een provincie opgegeven wordt, is een land verplicht | error4: Provincie is niet gevonden | error3: Adres is niet gevonden in de
 * postcodetabel | error2: Adresgegevens zijn niet compleet | error1: Adresgegevens ontbreken | error0: De opgegeven landcode is niet gevonden
 * @subpackage Structs
 * @date 20200204
 * @package RelatieApiV3
 */
class CreateBedrijfResponse extends AbstractStructBase
{
    /**
     * The requestTag
     * Meta information extracted from the WSDL
     * - documentation: Vrij veld voor aanroepende partij. De inhoud van dit veld wordt altijd identiek teruggestuurd.
     * - base: xsd:string
     * - maxLength: 4000
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $requestTag;
    /**
     * The relatienummer
     * Meta information extracted from the WSDL
     * - documentation: Het relatienummer van de aangemaakte relatiekaart
     * - base: xsd:decimal
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 38
     * @var float
     */
    public $relatienummer;
    /**
     * The isNieuweRelatie
     * Meta information extracted from the WSDL
     * - documentation: Is dit een nieuwe (true) of een bestaande (false) relatie?
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $isNieuweRelatie;
    /**
     * Constructor method for createBedrijfResponse
     * @uses CreateBedrijfResponse::setRequestTag()
     * @uses CreateBedrijfResponse::setRelatienummer()
     * @uses CreateBedrijfResponse::setIsNieuweRelatie()
     * @param string $requestTag
     * @param float $relatienummer
     * @param bool $isNieuweRelatie
     */
    public function __construct($requestTag = null, $relatienummer = null, $isNieuweRelatie = null)
    {
        $this
            ->setRequestTag($requestTag)
            ->setRelatienummer($relatienummer)
            ->setIsNieuweRelatie($isNieuweRelatie);
    }
    /**
     * Get requestTag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRequestTag()
    {
        return isset($this->requestTag) ? $this->requestTag : null;
    }
    /**
     * Set requestTag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $requestTag
     * @return \RelatieApiV3\StructType\CreateBedrijfResponse
     */
    public function setRequestTag($requestTag = null)
    {
        // validation for constraint: string
        if (!is_null($requestTag) && !is_string($requestTag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($requestTag, true), gettype($requestTag)), __LINE__);
        }
        // validation for constraint: maxLength(4000)
        if (!is_null($requestTag) && mb_strlen($requestTag) > 4000) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 4000', mb_strlen($requestTag)), __LINE__);
        }
        if (is_null($requestTag) || (is_array($requestTag) && empty($requestTag))) {
            unset($this->requestTag);
        } else {
            $this->requestTag = $requestTag;
        }
        return $this;
    }
    /**
     * Get relatienummer value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getRelatienummer()
    {
        return isset($this->relatienummer) ? $this->relatienummer : null;
    }
    /**
     * Set relatienummer value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $relatienummer
     * @return \RelatieApiV3\StructType\CreateBedrijfResponse
     */
    public function setRelatienummer($relatienummer = null)
    {
        // validation for constraint: float
        if (!is_null($relatienummer) && !(is_float($relatienummer) || is_numeric($relatienummer))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($relatienummer, true), gettype($relatienummer)), __LINE__);
        }
        // validation for constraint: totalDigits(38)
        if (!is_null($relatienummer) && mb_strlen(preg_replace('/(\D)/', '', $relatienummer)) > 38) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 38 digits, "%d" given', var_export($relatienummer, true), mb_strlen(preg_replace('/(\D)/', '', $relatienummer))), __LINE__);
        }
        if (is_null($relatienummer) || (is_array($relatienummer) && empty($relatienummer))) {
            unset($this->relatienummer);
        } else {
            $this->relatienummer = $relatienummer;
        }
        return $this;
    }
    /**
     * Get isNieuweRelatie value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsNieuweRelatie()
    {
        return isset($this->isNieuweRelatie) ? $this->isNieuweRelatie : null;
    }
    /**
     * Set isNieuweRelatie value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isNieuweRelatie
     * @return \RelatieApiV3\StructType\CreateBedrijfResponse
     */
    public function setIsNieuweRelatie($isNieuweRelatie = null)
    {
        // validation for constraint: boolean
        if (!is_null($isNieuweRelatie) && !is_bool($isNieuweRelatie)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isNieuweRelatie, true), gettype($isNieuweRelatie)), __LINE__);
        }
        if (is_null($isNieuweRelatie) || (is_array($isNieuweRelatie) && empty($isNieuweRelatie))) {
            unset($this->isNieuweRelatie);
        } else {
            $this->isNieuweRelatie = $isNieuweRelatie;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \RelatieApiV3\StructType\CreateBedrijfResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
