<?php

namespace RelatieApiV3\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for createBedrijfInclContRequest StructType
 * Meta information extracted from the WSDL
 * - documentation: Aanmaken van een nieuwe gecombineerde bedrijf en/of contactpersoon relatie (zowel bedrijf als persoonsgegevens op 1 relatiekaart). Kan alleen gebruikt worden indien systeem-constante "Invoer van bedrijven op de relatiekaart inclusief
 * contactpersoon" geactiveerd is.
 * @subpackage Structs
 * @date 20200204
 * @package RelatieApiV3
 */
class CreateBedrijfInclContRequest extends AbstractStructBase
{
    /**
     * The bedrijfInclCont
     * Meta information extracted from the WSDL
     * - documentation: De gegevens van de aan te maken relatie
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var \RelatieApiV3\StructType\BedrijfInclContRecV3
     */
    public $bedrijfInclCont;
    /**
     * The requestTag
     * Meta information extracted from the WSDL
     * - documentation: Vrij veld voor aanroepende partij. De inhoud van dit veld wordt altijd identiek teruggestuurd.
     * - base: xsd:string
     * - maxLength: 4000
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $requestTag;
    /**
     * The forceerKandidaat
     * Meta information extracted from the WSDL
     * - documentation: False (default): Geef een foutmelding indien meerdere kandidaten voldoen aan de input.<BR>True: In geval van meerdere kandidaten wordt de beste match (o.b.v. klantspecifieke instelling) geretourneerd.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $forceerKandidaat;
    /**
     * Constructor method for createBedrijfInclContRequest
     * @uses CreateBedrijfInclContRequest::setBedrijfInclCont()
     * @uses CreateBedrijfInclContRequest::setRequestTag()
     * @uses CreateBedrijfInclContRequest::setForceerKandidaat()
     * @param \RelatieApiV3\StructType\BedrijfInclContRecV3 $bedrijfInclCont
     * @param string $requestTag
     * @param bool $forceerKandidaat
     */
    public function __construct(\RelatieApiV3\StructType\BedrijfInclContRecV3 $bedrijfInclCont = null, $requestTag = null, $forceerKandidaat = null)
    {
        $this
            ->setBedrijfInclCont($bedrijfInclCont)
            ->setRequestTag($requestTag)
            ->setForceerKandidaat($forceerKandidaat);
    }
    /**
     * Get bedrijfInclCont value
     * @return \RelatieApiV3\StructType\BedrijfInclContRecV3
     */
    public function getBedrijfInclCont()
    {
        return $this->bedrijfInclCont;
    }
    /**
     * Set bedrijfInclCont value
     * @param \RelatieApiV3\StructType\BedrijfInclContRecV3 $bedrijfInclCont
     * @return \RelatieApiV3\StructType\CreateBedrijfInclContRequest
     */
    public function setBedrijfInclCont(\RelatieApiV3\StructType\BedrijfInclContRecV3 $bedrijfInclCont = null)
    {
        $this->bedrijfInclCont = $bedrijfInclCont;
        return $this;
    }
    /**
     * Get requestTag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRequestTag()
    {
        return isset($this->requestTag) ? $this->requestTag : null;
    }
    /**
     * Set requestTag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $requestTag
     * @return \RelatieApiV3\StructType\CreateBedrijfInclContRequest
     */
    public function setRequestTag($requestTag = null)
    {
        // validation for constraint: string
        if (!is_null($requestTag) && !is_string($requestTag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($requestTag, true), gettype($requestTag)), __LINE__);
        }
        // validation for constraint: maxLength(4000)
        if (!is_null($requestTag) && mb_strlen($requestTag) > 4000) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 4000', mb_strlen($requestTag)), __LINE__);
        }
        if (is_null($requestTag) || (is_array($requestTag) && empty($requestTag))) {
            unset($this->requestTag);
        } else {
            $this->requestTag = $requestTag;
        }
        return $this;
    }
    /**
     * Get forceerKandidaat value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getForceerKandidaat()
    {
        return isset($this->forceerKandidaat) ? $this->forceerKandidaat : null;
    }
    /**
     * Set forceerKandidaat value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $forceerKandidaat
     * @return \RelatieApiV3\StructType\CreateBedrijfInclContRequest
     */
    public function setForceerKandidaat($forceerKandidaat = null)
    {
        // validation for constraint: boolean
        if (!is_null($forceerKandidaat) && !is_bool($forceerKandidaat)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($forceerKandidaat, true), gettype($forceerKandidaat)), __LINE__);
        }
        if (is_null($forceerKandidaat) || (is_array($forceerKandidaat) && empty($forceerKandidaat))) {
            unset($this->forceerKandidaat);
        } else {
            $this->forceerKandidaat = $forceerKandidaat;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \RelatieApiV3\StructType\CreateBedrijfInclContRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
