<?php

namespace RelatieApiV3\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for createActiviteitRequest StructType
 * Meta information extracted from the WSDL
 * - documentation: Aanmaken van een activiteit of todo. De activiteit wordt bij een relatie opgeslagen. Door het activiteittype (op te vragen via getActiviteittypen) op te geven wordt bepaald wat voor type activiteit aangemaakt wordt, en aan welke
 * gebruiker deze toebedeeld wordt.<BR> Als bij het activiteittype geen gebruiker is gekoppeld, kan bij het aanmaken van de activiteit ook een gebruikerscode opgegeven worden
 * @subpackage Structs
 * @date 20200204
 * @package RelatieApiV3
 */
class CreateActiviteitRequest extends AbstractStructBase
{
    /**
     * The relatienummer
     * Meta information extracted from the WSDL
     * - documentation: Relatienummer van de relatie bij wie de activiteit aangemaakt wordt.
     * - base: xsd:integer
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * - totalDigits: 15
     * @var int
     */
    public $relatienummer;
    /**
     * The activiteitTypeCode
     * Meta information extracted from the WSDL
     * - documentation: Code van het activiteitstype. Instellingen bij het activiteittype bepalen of de activiteit als todo aangemaakt wordt, en aan wie de activiteit toebedeeld wordt.
     * - base: xsd:string
     * - maxLength: 12
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $activiteitTypeCode;
    /**
     * The requestTag
     * Meta information extracted from the WSDL
     * - documentation: Vrij veld voor aanroepende partij. De inhoud van dit veld wordt altijd identiek teruggestuurd.
     * - base: xsd:string
     * - maxLength: 4000
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $requestTag;
    /**
     * The activiteitTekst
     * Meta information extracted from the WSDL
     * - documentation: De activiteit tekst. Indien leeg wordt de default activiteittekst van het type gebruikt.
     * - base: xsd:string
     * - maxLength: 3999
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $activiteitTekst;
    /**
     * The gebruikersCode
     * Meta information extracted from the WSDL
     * - documentation: Code van de gebruiker. Indien leeg wordt de default gebruiker van het type gebruikt. Als er op het type geen gebruiker is aangegeven en het betreft een type todo, dan is dit veld verplicht
     * - base: xsd:string
     * - maxLength: 20
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $gebruikersCode;
    /**
     * Constructor method for createActiviteitRequest
     * @uses CreateActiviteitRequest::setRelatienummer()
     * @uses CreateActiviteitRequest::setActiviteitTypeCode()
     * @uses CreateActiviteitRequest::setRequestTag()
     * @uses CreateActiviteitRequest::setActiviteitTekst()
     * @uses CreateActiviteitRequest::setGebruikersCode()
     * @param int $relatienummer
     * @param string $activiteitTypeCode
     * @param string $requestTag
     * @param string $activiteitTekst
     * @param string $gebruikersCode
     */
    public function __construct($relatienummer = null, $activiteitTypeCode = null, $requestTag = null, $activiteitTekst = null, $gebruikersCode = null)
    {
        $this
            ->setRelatienummer($relatienummer)
            ->setActiviteitTypeCode($activiteitTypeCode)
            ->setRequestTag($requestTag)
            ->setActiviteitTekst($activiteitTekst)
            ->setGebruikersCode($gebruikersCode);
    }
    /**
     * Get relatienummer value
     * @return int
     */
    public function getRelatienummer()
    {
        return $this->relatienummer;
    }
    /**
     * Set relatienummer value
     * @param int $relatienummer
     * @return \RelatieApiV3\StructType\CreateActiviteitRequest
     */
    public function setRelatienummer($relatienummer = null)
    {
        // validation for constraint: int
        if (!is_null($relatienummer) && !(is_int($relatienummer) || ctype_digit($relatienummer))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($relatienummer, true), gettype($relatienummer)), __LINE__);
        }
        // validation for constraint: totalDigits(15)
        if (!is_null($relatienummer) && mb_strlen(preg_replace('/(\D)/', '', $relatienummer)) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 15 digits, "%d" given', var_export($relatienummer, true), mb_strlen(preg_replace('/(\D)/', '', $relatienummer))), __LINE__);
        }
        $this->relatienummer = $relatienummer;
        return $this;
    }
    /**
     * Get activiteitTypeCode value
     * @return string
     */
    public function getActiviteitTypeCode()
    {
        return $this->activiteitTypeCode;
    }
    /**
     * Set activiteitTypeCode value
     * @param string $activiteitTypeCode
     * @return \RelatieApiV3\StructType\CreateActiviteitRequest
     */
    public function setActiviteitTypeCode($activiteitTypeCode = null)
    {
        // validation for constraint: string
        if (!is_null($activiteitTypeCode) && !is_string($activiteitTypeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($activiteitTypeCode, true), gettype($activiteitTypeCode)), __LINE__);
        }
        // validation for constraint: maxLength(12)
        if (!is_null($activiteitTypeCode) && mb_strlen($activiteitTypeCode) > 12) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 12', mb_strlen($activiteitTypeCode)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($activiteitTypeCode) && mb_strlen($activiteitTypeCode) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($activiteitTypeCode)), __LINE__);
        }
        $this->activiteitTypeCode = $activiteitTypeCode;
        return $this;
    }
    /**
     * Get requestTag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRequestTag()
    {
        return isset($this->requestTag) ? $this->requestTag : null;
    }
    /**
     * Set requestTag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $requestTag
     * @return \RelatieApiV3\StructType\CreateActiviteitRequest
     */
    public function setRequestTag($requestTag = null)
    {
        // validation for constraint: string
        if (!is_null($requestTag) && !is_string($requestTag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($requestTag, true), gettype($requestTag)), __LINE__);
        }
        // validation for constraint: maxLength(4000)
        if (!is_null($requestTag) && mb_strlen($requestTag) > 4000) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 4000', mb_strlen($requestTag)), __LINE__);
        }
        if (is_null($requestTag) || (is_array($requestTag) && empty($requestTag))) {
            unset($this->requestTag);
        } else {
            $this->requestTag = $requestTag;
        }
        return $this;
    }
    /**
     * Get activiteitTekst value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getActiviteitTekst()
    {
        return isset($this->activiteitTekst) ? $this->activiteitTekst : null;
    }
    /**
     * Set activiteitTekst value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $activiteitTekst
     * @return \RelatieApiV3\StructType\CreateActiviteitRequest
     */
    public function setActiviteitTekst($activiteitTekst = null)
    {
        // validation for constraint: string
        if (!is_null($activiteitTekst) && !is_string($activiteitTekst)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($activiteitTekst, true), gettype($activiteitTekst)), __LINE__);
        }
        // validation for constraint: maxLength(3999)
        if (!is_null($activiteitTekst) && mb_strlen($activiteitTekst) > 3999) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 3999', mb_strlen($activiteitTekst)), __LINE__);
        }
        if (is_null($activiteitTekst) || (is_array($activiteitTekst) && empty($activiteitTekst))) {
            unset($this->activiteitTekst);
        } else {
            $this->activiteitTekst = $activiteitTekst;
        }
        return $this;
    }
    /**
     * Get gebruikersCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGebruikersCode()
    {
        return isset($this->gebruikersCode) ? $this->gebruikersCode : null;
    }
    /**
     * Set gebruikersCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $gebruikersCode
     * @return \RelatieApiV3\StructType\CreateActiviteitRequest
     */
    public function setGebruikersCode($gebruikersCode = null)
    {
        // validation for constraint: string
        if (!is_null($gebruikersCode) && !is_string($gebruikersCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gebruikersCode, true), gettype($gebruikersCode)), __LINE__);
        }
        // validation for constraint: maxLength(20)
        if (!is_null($gebruikersCode) && mb_strlen($gebruikersCode) > 20) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 20', mb_strlen($gebruikersCode)), __LINE__);
        }
        if (is_null($gebruikersCode) || (is_array($gebruikersCode) && empty($gebruikersCode))) {
            unset($this->gebruikersCode);
        } else {
            $this->gebruikersCode = $gebruikersCode;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \RelatieApiV3\StructType\CreateActiviteitRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
