<?php

namespace RelatieApiV3\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for checkEmailResponse StructType
 * Meta information extracted from the WSDL
 * - documentation: error70: De relatie met het opgegeven relatienummer is niet van het type 'Afdeling'. | error16: Op basis van het relatienummer is geen relatie gevonden | error15: Er is geen relatienummer opgegeven
 * @subpackage Structs
 * @date 20200204
 * @package RelatieApiV3
 */
class CheckEmailResponse extends AbstractStructBase
{
    /**
     * The requestTag
     * Meta information extracted from the WSDL
     * - documentation: Vrij veld voor aanroepende partij. De inhoud van dit veld wordt altijd identiek teruggestuurd.
     * - base: xsd:string
     * - maxLength: 4000
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $requestTag;
    /**
     * The status
     * Meta information extracted from the WSDL
     * - documentation: De status van het e-mail adres. 0= Geen relatie bekend onder dit e-mail adres. 1= Relatie bekend echter zonder username (geen user) 2= Relatie bekend met username (user bekend). 3= Meerdere relaties bekend met dit e-mail adres.
     * - base: xsd:decimal
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 38
     * @var float
     */
    public $status;
    /**
     * The relatieNummer
     * Meta information extracted from the WSDL
     * - documentation: Het relatienummer indien er exact 1 relatie gevonden is op basis van het e-mail adres
     * - base: xsd:integer
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 15
     * @var int
     */
    public $relatieNummer;
    /**
     * Constructor method for checkEmailResponse
     * @uses CheckEmailResponse::setRequestTag()
     * @uses CheckEmailResponse::setStatus()
     * @uses CheckEmailResponse::setRelatieNummer()
     * @param string $requestTag
     * @param float $status
     * @param int $relatieNummer
     */
    public function __construct($requestTag = null, $status = null, $relatieNummer = null)
    {
        $this
            ->setRequestTag($requestTag)
            ->setStatus($status)
            ->setRelatieNummer($relatieNummer);
    }
    /**
     * Get requestTag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRequestTag()
    {
        return isset($this->requestTag) ? $this->requestTag : null;
    }
    /**
     * Set requestTag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $requestTag
     * @return \RelatieApiV3\StructType\CheckEmailResponse
     */
    public function setRequestTag($requestTag = null)
    {
        // validation for constraint: string
        if (!is_null($requestTag) && !is_string($requestTag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($requestTag, true), gettype($requestTag)), __LINE__);
        }
        // validation for constraint: maxLength(4000)
        if (!is_null($requestTag) && mb_strlen($requestTag) > 4000) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 4000', mb_strlen($requestTag)), __LINE__);
        }
        if (is_null($requestTag) || (is_array($requestTag) && empty($requestTag))) {
            unset($this->requestTag);
        } else {
            $this->requestTag = $requestTag;
        }
        return $this;
    }
    /**
     * Get status value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getStatus()
    {
        return isset($this->status) ? $this->status : null;
    }
    /**
     * Set status value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $status
     * @return \RelatieApiV3\StructType\CheckEmailResponse
     */
    public function setStatus($status = null)
    {
        // validation for constraint: float
        if (!is_null($status) && !(is_float($status) || is_numeric($status))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($status, true), gettype($status)), __LINE__);
        }
        // validation for constraint: totalDigits(38)
        if (!is_null($status) && mb_strlen(preg_replace('/(\D)/', '', $status)) > 38) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 38 digits, "%d" given', var_export($status, true), mb_strlen(preg_replace('/(\D)/', '', $status))), __LINE__);
        }
        if (is_null($status) || (is_array($status) && empty($status))) {
            unset($this->status);
        } else {
            $this->status = $status;
        }
        return $this;
    }
    /**
     * Get relatieNummer value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getRelatieNummer()
    {
        return isset($this->relatieNummer) ? $this->relatieNummer : null;
    }
    /**
     * Set relatieNummer value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $relatieNummer
     * @return \RelatieApiV3\StructType\CheckEmailResponse
     */
    public function setRelatieNummer($relatieNummer = null)
    {
        // validation for constraint: int
        if (!is_null($relatieNummer) && !(is_int($relatieNummer) || ctype_digit($relatieNummer))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($relatieNummer, true), gettype($relatieNummer)), __LINE__);
        }
        // validation for constraint: totalDigits(15)
        if (!is_null($relatieNummer) && mb_strlen(preg_replace('/(\D)/', '', $relatieNummer)) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 15 digits, "%d" given', var_export($relatieNummer, true), mb_strlen(preg_replace('/(\D)/', '', $relatieNummer))), __LINE__);
        }
        if (is_null($relatieNummer) || (is_array($relatieNummer) && empty($relatieNummer))) {
            unset($this->relatieNummer);
        } else {
            $this->relatieNummer = $relatieNummer;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \RelatieApiV3\StructType\CheckEmailResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
