<?php

namespace RelatieApiV3\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BiccodeRecV3 StructType
 * Meta information extracted from the WSDL
 * - documentation: Bic code
 * @subpackage Structs
 * @date 20200204
 * @package RelatieApiV3
 */
class BiccodeRecV3 extends AbstractStructBase
{
    /**
     * The bicCode
     * Meta information extracted from the WSDL
     * - documentation: Code van de bic categorie
     * - base: xsd:string
     * - maxLength: 20
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $bicCode;
    /**
     * The bicOmschrijving
     * Meta information extracted from the WSDL
     * - documentation: Omschrijving van de bic categorie
     * - base: xsd:string
     * - maxLength: 500
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $bicOmschrijving;
    /**
     * Constructor method for BiccodeRecV3
     * @uses BiccodeRecV3::setBicCode()
     * @uses BiccodeRecV3::setBicOmschrijving()
     * @param string $bicCode
     * @param string $bicOmschrijving
     */
    public function __construct($bicCode = null, $bicOmschrijving = null)
    {
        $this
            ->setBicCode($bicCode)
            ->setBicOmschrijving($bicOmschrijving);
    }
    /**
     * Get bicCode value
     * @return string
     */
    public function getBicCode()
    {
        return $this->bicCode;
    }
    /**
     * Set bicCode value
     * @param string $bicCode
     * @return \RelatieApiV3\StructType\BiccodeRecV3
     */
    public function setBicCode($bicCode = null)
    {
        // validation for constraint: string
        if (!is_null($bicCode) && !is_string($bicCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bicCode, true), gettype($bicCode)), __LINE__);
        }
        // validation for constraint: maxLength(20)
        if (!is_null($bicCode) && mb_strlen($bicCode) > 20) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 20', mb_strlen($bicCode)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($bicCode) && mb_strlen($bicCode) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($bicCode)), __LINE__);
        }
        $this->bicCode = $bicCode;
        return $this;
    }
    /**
     * Get bicOmschrijving value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBicOmschrijving()
    {
        return isset($this->bicOmschrijving) ? $this->bicOmschrijving : null;
    }
    /**
     * Set bicOmschrijving value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bicOmschrijving
     * @return \RelatieApiV3\StructType\BiccodeRecV3
     */
    public function setBicOmschrijving($bicOmschrijving = null)
    {
        // validation for constraint: string
        if (!is_null($bicOmschrijving) && !is_string($bicOmschrijving)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bicOmschrijving, true), gettype($bicOmschrijving)), __LINE__);
        }
        // validation for constraint: maxLength(500)
        if (!is_null($bicOmschrijving) && mb_strlen($bicOmschrijving) > 500) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 500', mb_strlen($bicOmschrijving)), __LINE__);
        }
        if (is_null($bicOmschrijving) || (is_array($bicOmschrijving) && empty($bicOmschrijving))) {
            unset($this->bicOmschrijving);
        } else {
            $this->bicOmschrijving = $bicOmschrijving;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \RelatieApiV3\StructType\BiccodeRecV3
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
