<?php

namespace RelatieApiV3\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BedrijftableV3 StructType
 * Meta information extracted from the WSDL
 * - documentation: Lijst met bedrijven
 * @subpackage Structs
 * @date 20200204
 * @package RelatieApiV3
 */
class BedrijftableV3 extends AbstractStructBase
{
    /**
     * The bedrijf
     * Meta information extracted from the WSDL
     * - documentation: bedrijven
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: false
     * @var \RelatieApiV3\StructType\BedrijfinfoRecV3[]
     */
    public $bedrijf;
    /**
     * Constructor method for BedrijftableV3
     * @uses BedrijftableV3::setBedrijf()
     * @param \RelatieApiV3\StructType\BedrijfinfoRecV3[] $bedrijf
     */
    public function __construct(array $bedrijf = array())
    {
        $this
            ->setBedrijf($bedrijf);
    }
    /**
     * Get bedrijf value
     * @return \RelatieApiV3\StructType\BedrijfinfoRecV3[]|null
     */
    public function getBedrijf()
    {
        return $this->bedrijf;
    }
    /**
     * This method is responsible for validating the values passed to the setBedrijf method
     * This method is willingly generated in order to preserve the one-line inline validation within the setBedrijf method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateBedrijfForArrayConstraintsFromSetBedrijf(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $bedrijftableV3BedrijfItem) {
            // validation for constraint: itemType
            if (!$bedrijftableV3BedrijfItem instanceof \RelatieApiV3\StructType\BedrijfinfoRecV3) {
                $invalidValues[] = is_object($bedrijftableV3BedrijfItem) ? get_class($bedrijftableV3BedrijfItem) : sprintf('%s(%s)', gettype($bedrijftableV3BedrijfItem), var_export($bedrijftableV3BedrijfItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The bedrijf property can only contain items of type \RelatieApiV3\StructType\BedrijfinfoRecV3, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set bedrijf value
     * @throws \InvalidArgumentException
     * @param \RelatieApiV3\StructType\BedrijfinfoRecV3[] $bedrijf
     * @return \RelatieApiV3\StructType\BedrijftableV3
     */
    public function setBedrijf(array $bedrijf = array())
    {
        // validation for constraint: array
        if ('' !== ($bedrijfArrayErrorMessage = self::validateBedrijfForArrayConstraintsFromSetBedrijf($bedrijf))) {
            throw new \InvalidArgumentException($bedrijfArrayErrorMessage, __LINE__);
        }
        $this->bedrijf = $bedrijf;
        return $this;
    }
    /**
     * Add item to bedrijf value
     * @throws \InvalidArgumentException
     * @param \RelatieApiV3\StructType\BedrijfinfoRecV3 $item
     * @return \RelatieApiV3\StructType\BedrijftableV3
     */
    public function addToBedrijf(\RelatieApiV3\StructType\BedrijfinfoRecV3 $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \RelatieApiV3\StructType\BedrijfinfoRecV3) {
            throw new \InvalidArgumentException(sprintf('The bedrijf property can only contain items of type \RelatieApiV3\StructType\BedrijfinfoRecV3, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->bedrijf[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \RelatieApiV3\StructType\BedrijftableV3
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
