<?php

namespace RelatieApiV3\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BedrijfInclConttableV3 StructType
 * Meta information extracted from the WSDL
 * - documentation: Lijst met gecombineerde bedrijf en contactpersoon relaties
 * @subpackage Structs
 * @date 20200204
 * @package RelatieApiV3
 */
class BedrijfInclConttableV3 extends AbstractStructBase
{
    /**
     * The bedrijfInclCont
     * Meta information extracted from the WSDL
     * - documentation: Bedrijf incl contactpersonen
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: false
     * @var \RelatieApiV3\StructType\BedrijfInclContinfoRecV3[]
     */
    public $bedrijfInclCont;
    /**
     * Constructor method for BedrijfInclConttableV3
     * @uses BedrijfInclConttableV3::setBedrijfInclCont()
     * @param \RelatieApiV3\StructType\BedrijfInclContinfoRecV3[] $bedrijfInclCont
     */
    public function __construct(array $bedrijfInclCont = array())
    {
        $this
            ->setBedrijfInclCont($bedrijfInclCont);
    }
    /**
     * Get bedrijfInclCont value
     * @return \RelatieApiV3\StructType\BedrijfInclContinfoRecV3[]|null
     */
    public function getBedrijfInclCont()
    {
        return $this->bedrijfInclCont;
    }
    /**
     * This method is responsible for validating the values passed to the setBedrijfInclCont method
     * This method is willingly generated in order to preserve the one-line inline validation within the setBedrijfInclCont method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateBedrijfInclContForArrayConstraintsFromSetBedrijfInclCont(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $bedrijfInclConttableV3BedrijfInclContItem) {
            // validation for constraint: itemType
            if (!$bedrijfInclConttableV3BedrijfInclContItem instanceof \RelatieApiV3\StructType\BedrijfInclContinfoRecV3) {
                $invalidValues[] = is_object($bedrijfInclConttableV3BedrijfInclContItem) ? get_class($bedrijfInclConttableV3BedrijfInclContItem) : sprintf('%s(%s)', gettype($bedrijfInclConttableV3BedrijfInclContItem), var_export($bedrijfInclConttableV3BedrijfInclContItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The bedrijfInclCont property can only contain items of type \RelatieApiV3\StructType\BedrijfInclContinfoRecV3, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set bedrijfInclCont value
     * @throws \InvalidArgumentException
     * @param \RelatieApiV3\StructType\BedrijfInclContinfoRecV3[] $bedrijfInclCont
     * @return \RelatieApiV3\StructType\BedrijfInclConttableV3
     */
    public function setBedrijfInclCont(array $bedrijfInclCont = array())
    {
        // validation for constraint: array
        if ('' !== ($bedrijfInclContArrayErrorMessage = self::validateBedrijfInclContForArrayConstraintsFromSetBedrijfInclCont($bedrijfInclCont))) {
            throw new \InvalidArgumentException($bedrijfInclContArrayErrorMessage, __LINE__);
        }
        $this->bedrijfInclCont = $bedrijfInclCont;
        return $this;
    }
    /**
     * Add item to bedrijfInclCont value
     * @throws \InvalidArgumentException
     * @param \RelatieApiV3\StructType\BedrijfInclContinfoRecV3 $item
     * @return \RelatieApiV3\StructType\BedrijfInclConttableV3
     */
    public function addToBedrijfInclCont(\RelatieApiV3\StructType\BedrijfInclContinfoRecV3 $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \RelatieApiV3\StructType\BedrijfInclContinfoRecV3) {
            throw new \InvalidArgumentException(sprintf('The bedrijfInclCont property can only contain items of type \RelatieApiV3\StructType\BedrijfInclContinfoRecV3, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->bedrijfInclCont[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \RelatieApiV3\StructType\BedrijfInclConttableV3
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
