<?php

namespace RelatieApiV3\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ActiviteittypeRecV3 StructType
 * Meta information extracted from the WSDL
 * - documentation: Activiteit type
 * @subpackage Structs
 * @date 20200204
 * @package RelatieApiV3
 */
class ActiviteittypeRecV3 extends AbstractStructBase
{
    /**
     * The code
     * Meta information extracted from the WSDL
     * - documentation: Code van de activiteittype
     * - base: xsd:string
     * - maxLength: 12
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $code;
    /**
     * The omschrijving
     * Meta information extracted from the WSDL
     * - documentation: Omschrijving van de activiteittype
     * - base: xsd:string
     * - maxLength: 120
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $omschrijving;
    /**
     * The todo
     * Meta information extracted from the WSDL
     * - documentation: Indicatie dat het activiteittype bedoeld is voor Todo's
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $todo;
    /**
     * Constructor method for ActiviteittypeRecV3
     * @uses ActiviteittypeRecV3::setCode()
     * @uses ActiviteittypeRecV3::setOmschrijving()
     * @uses ActiviteittypeRecV3::setTodo()
     * @param string $code
     * @param string $omschrijving
     * @param bool $todo
     */
    public function __construct($code = null, $omschrijving = null, $todo = null)
    {
        $this
            ->setCode($code)
            ->setOmschrijving($omschrijving)
            ->setTodo($todo);
    }
    /**
     * Get code value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCode()
    {
        return isset($this->code) ? $this->code : null;
    }
    /**
     * Set code value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $code
     * @return \RelatieApiV3\StructType\ActiviteittypeRecV3
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($code, true), gettype($code)), __LINE__);
        }
        // validation for constraint: maxLength(12)
        if (!is_null($code) && mb_strlen($code) > 12) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 12', mb_strlen($code)), __LINE__);
        }
        if (is_null($code) || (is_array($code) && empty($code))) {
            unset($this->code);
        } else {
            $this->code = $code;
        }
        return $this;
    }
    /**
     * Get omschrijving value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOmschrijving()
    {
        return isset($this->omschrijving) ? $this->omschrijving : null;
    }
    /**
     * Set omschrijving value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $omschrijving
     * @return \RelatieApiV3\StructType\ActiviteittypeRecV3
     */
    public function setOmschrijving($omschrijving = null)
    {
        // validation for constraint: string
        if (!is_null($omschrijving) && !is_string($omschrijving)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($omschrijving, true), gettype($omschrijving)), __LINE__);
        }
        // validation for constraint: maxLength(120)
        if (!is_null($omschrijving) && mb_strlen($omschrijving) > 120) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 120', mb_strlen($omschrijving)), __LINE__);
        }
        if (is_null($omschrijving) || (is_array($omschrijving) && empty($omschrijving))) {
            unset($this->omschrijving);
        } else {
            $this->omschrijving = $omschrijving;
        }
        return $this;
    }
    /**
     * Get todo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getTodo()
    {
        return isset($this->todo) ? $this->todo : null;
    }
    /**
     * Set todo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $todo
     * @return \RelatieApiV3\StructType\ActiviteittypeRecV3
     */
    public function setTodo($todo = null)
    {
        // validation for constraint: boolean
        if (!is_null($todo) && !is_bool($todo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($todo, true), gettype($todo)), __LINE__);
        }
        if (is_null($todo) || (is_array($todo) && empty($todo))) {
            unset($this->todo);
        } else {
            $this->todo = $todo;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \RelatieApiV3\StructType\ActiviteittypeRecV3
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
