<?php

namespace RelatieApiV3\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Update ServiceType
 * @subpackage Services
 * @date 20200204
 * @package RelatieApiV3
 */
class Update extends AbstractSoapClientBase
{
    /**
     * Sets the Authentication SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \RelatieApiV3\StructType\Authentication $authentication
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderAuthentication(\RelatieApiV3\StructType\Authentication $authentication, $nameSpace = 'http://zeno.socho.nl', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'authentication', $authentication, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named updatePersoon
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: authentication
     * - SOAPHeaderNamespaces: http://zeno.socho.nl
     * - SOAPHeaderTypes: \RelatieApiV3\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Wijzigen van de persoonsgegevens van een prive persoon <br/><u>Let op:</u> bij wijzigingen van een bestaande persoon dienen alle elementen opnieuw te worden meegegeven. Lege elementen of niet meegegeven (groepen) elementen worden
     * leeg gemaakt door de update.error0: De opgegeven landcode is niet gevondenerror1: Adresgegevens ontbrekenerror2: Adresgegevens zijn niet compleeterror3: Adres is niet gevonden in de postcodetabelerror4: Provincie is niet gevondenerror5: Indien een
     * provincie opgegeven wordt, is een land verplichterror6: Provincie komt niet voor in het opgegeven landerror7: Er is geen achternaam opgegevenerror8: Het e-mail adres (1) is niet valideerror9: Het opgegeven telefoonnummer is niet valideerror10: Het
     * opgegeven mobiele telefoonnummer is niet geldigerror11: De opgegeven titulatuurcode is niet gevondenerror12: De opgegeven geboortedatum is niet geldigerror13: Het opgegeven geslacht is niet geldigerror15: Er is geen relatienummer opgegevenerror16: Op
     * basis van het relatienummer is geen relatie gevondenerror20: Het e-mail adres (2) is niet valideerror23: Op basis van het relatienummer is een bedrijf gevonden. Wijzigen persoonsgegevens is niet mogelijkerror35: De opgegeven betaalwijze is niet
     * geldigerror36: Bij automatische incasso is een bankrekeningnummer verplichterror37: Het opgegeven bankrekeningnummer voldoet niet aan de 11-proeferror38: Bij automatische incasso is een iban nummer verplichterror39: Het opgegeven IBAN nummer voldoet
     * niet aan de eisenerror40: De opgegeven bic code is niet geldigerror41: Het opgegeven (NL-) IBAN nummer en de BIC code horen niet bij elkaarerror45: De opgegeven straatnaam komt niet overeen met de straatnaam behorende bij de postcode/huisnummer
     * combinatieerror46: De opgegeven plaatsnaam komt niet overeen met de plaatsnaam behorende bij de postcode/huisnummer combinatieerror48: De opgegeven relatie kortinggroepcode is niet gevondenerror49: Op basis van de opgegeven waarde voor codeveld 1 is
     * niets gevondenerror50: Op basis van de opgegeven waarde voor codeveld 2 is niets gevondenerror51: Op basis van de opgegeven waarde voor codeveld 3 is niets gevondenerror52: Op basis van de opgegeven waarde voor codeveld 4 is niets gevondenerror53: Op
     * basis van de opgegeven waarde voor codeveld 5 is niets gevondenerror54: Op basis van de opgegeven waarde voor codeveld 6 is niets gevondenerror71: De opgegeven taalcode is niet gevondenerror72: De opgegeven valutacode is niet gevondenerror101: De
     * opgegeven username is niet uniekerror103: Er zijn ongeldige voorletters opgegeven.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \RelatieApiV3\StructType\UpdatePersoonRequest $request_parameters
     * @return \RelatieApiV3\StructType\UpdatePersoonResponse|bool
     */
    public function updatePersoon(\RelatieApiV3\StructType\UpdatePersoonRequest $request_parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->updatePersoon($request_parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateBedrijf
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: authentication
     * - SOAPHeaderNamespaces: http://zeno.socho.nl
     * - SOAPHeaderTypes: \RelatieApiV3\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Wijzigen van de bedrijfsgegevens van een bedrijf <br/><u>Let op:</u> bij wijzigingen van een bestaand bedrijf dienen alle elementen opnieuw te worden meegegeven. Lege elementen of niet meegegeven (groepen) elementen worden leeg
     * gemaakt door de update.error0: De opgegeven landcode is niet gevondenerror1: Adresgegevens ontbrekenerror2: Adresgegevens zijn niet compleeterror3: Adres is niet gevonden in de postcodetabelerror4: Provincie is niet gevondenerror5: Indien een
     * provincie opgegeven wordt, is een land verplichterror6: Provincie komt niet voor in het opgegeven landerror8: Het e-mail adres (1) is niet valideerror9: Het opgegeven telefoonnummer is niet valideerror15: Er is geen relatienummer opgegevenerror16: Op
     * basis van het relatienummer is geen relatie gevondenerror18: De op basis van het relatienummer bedrijf gevonden relatie is geen bedrijferror19: Er is voor het bedrijf geen naam opgegevenerror20: Het e-mail adres (2) is niet valideerror21: Het
     * opgegeven faxnummer is ongeldigerror35: De opgegeven betaalwijze is niet geldigerror36: Bij automatische incasso is een bankrekeningnummer verplichterror37: Het opgegeven bankrekeningnummer voldoet niet aan de 11-proeferror38: Bij automatische
     * incasso is een iban nummer verplichterror39: Het opgegeven IBAN nummer voldoet niet aan de eisenerror40: De opgegeven bic code is niet geldigerror41: Het opgegeven (NL-) IBAN nummer en de BIC code horen niet bij elkaarerror45: De opgegeven straatnaam
     * komt niet overeen met de straatnaam behorende bij de postcode/huisnummer combinatieerror46: De opgegeven plaatsnaam komt niet overeen met de plaatsnaam behorende bij de postcode/huisnummer combinatieerror48: De opgegeven relatie kortinggroepcode is
     * niet gevondenerror49: Op basis van de opgegeven waarde voor codeveld 1 is niets gevondenerror50: Op basis van de opgegeven waarde voor codeveld 2 is niets gevondenerror51: Op basis van de opgegeven waarde voor codeveld 3 is niets gevondenerror52: Op
     * basis van de opgegeven waarde voor codeveld 4 is niets gevondenerror53: Op basis van de opgegeven waarde voor codeveld 5 is niets gevondenerror54: Op basis van de opgegeven waarde voor codeveld 6 is niets gevondenerror58: Bij BTW-indicatie
     * intra-communautair is een BTW-nummer verplichterror60: Er is een ongeldig BTW-nummer meegegevenerror71: De opgegeven taalcode is niet gevondenerror72: De opgegeven valutacode is niet gevonden
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \RelatieApiV3\StructType\UpdateBedrijfRequest $request_parameters
     * @return \RelatieApiV3\StructType\UpdateBedrijfResponse|bool
     */
    public function updateBedrijf(\RelatieApiV3\StructType\UpdateBedrijfRequest $request_parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->updateBedrijf($request_parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateContactpersoon
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: authentication
     * - SOAPHeaderNamespaces: http://zeno.socho.nl
     * - SOAPHeaderTypes: \RelatieApiV3\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Wijzigen van de gegevens van een contactpersoon bij een bedrijf <br/><u>Let op:</u> bij wijzigingen van een bestaande contactpersoon dienen alle elementen opnieuw te worden meegegeven. Lege elementen of niet meegegeven (groepen)
     * elementen worden leeg gemaakt door de update.error0: De opgegeven landcode is niet gevondenerror2: Adresgegevens zijn niet compleeterror3: Adres is niet gevonden in de postcodetabelerror4: Provincie is niet gevondenerror5: Indien een provincie
     * opgegeven wordt, is een land verplichterror6: Provincie komt niet voor in het opgegeven landerror7: Er is geen achternaam opgegevenerror8: Het e-mail adres (1) is niet valideerror9: Het opgegeven telefoonnummer is niet valideerror10: Het opgegeven
     * mobiele telefoonnummer is niet geldigerror11: De opgegeven titulatuurcode is niet gevondenerror12: De opgegeven geboortedatum is niet geldigerror13: Het opgegeven geslacht is niet geldigerror15: Er is geen relatienummer opgegevenerror16: Op basis van
     * het relatienummer is geen relatie gevondenerror20: Het e-mail adres (2) is niet valideerror23: Op basis van het relatienummer is een bedrijf gevonden. Wijzigen persoons- of afdelingsgegevens is niet mogelijk'error35: De opgegeven betaalwijze is niet
     * geldigerror36: Bij automatische incasso is een bankrekeningnummer verplichterror37: Het opgegeven bankrekeningnummer voldoet niet aan de 11-proeferror38: Bij automatische incasso is een iban nummer verplichterror39: Het opgegeven IBAN nummer voldoet
     * niet aan de eisenerror40: De opgegeven bic code is niet geldigerror41: Het opgegeven (NL-) IBAN nummer en de BIC code horen niet bij elkaarerror45: De opgegeven straatnaam komt niet overeen met de straatnaam behorende bij de postcode/huisnummer
     * combinatieerror46: De opgegeven plaatsnaam komt niet overeen met de plaatsnaam behorende bij de postcode/huisnummer combinatieerror48: De opgegeven relatie kortinggroepcode is niet gevondenerror49: Op basis van de opgegeven waarde voor codeveld 1 is
     * niets gevondenerror50: Op basis van de opgegeven waarde voor codeveld 2 is niets gevondenerror51: Op basis van de opgegeven waarde voor codeveld 3 is niets gevondenerror52: Op basis van de opgegeven waarde voor codeveld 4 is niets gevondenerror53: Op
     * basis van de opgegeven waarde voor codeveld 5 is niets gevondenerror54: Op basis van de opgegeven waarde voor codeveld 6 is niets gevondenerror71: De opgegeven taalcode is niet gevondenerror72: De opgegeven valutacode is niet gevondenerror101: De
     * opgegeven username is niet uniekerror103: Er zijn ongeldige voorletters opgegeven.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \RelatieApiV3\StructType\UpdateContactpersoonRequest $request_parameters
     * @return \RelatieApiV3\StructType\UpdateContactpersoonResponse|bool
     */
    public function updateContactpersoon(\RelatieApiV3\StructType\UpdateContactpersoonRequest $request_parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->updateContactpersoon($request_parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updatePersoonNrContact
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: authentication
     * - SOAPHeaderNamespaces: http://zeno.socho.nl
     * - SOAPHeaderTypes: \RelatieApiV3\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Koppelt een bestaande prive persoon als contactpersoon aan een bestaand bedrijf.error15: Er is geen relatienummer opgegevenerror16: Op basis van het relatienummer is geen relatie gevondenerror17: Op basis van het relatienummer
     * bedrijf is geen relatie gevondenerror55: Persoon is al als contactpersoon aan een ander bedrijf gekoppelderror56: Persoon is al als contactpersoon aan dit bedrijf gekoppelderror57: Er is reeds een persoon met dezelfde gegevens en een ander
     * relatienummer als contactpersoon gekoppelderror100: Er voldoen meerdere kandidaten
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \RelatieApiV3\StructType\UpdatePersoonNrContactRequest $request_parameters
     * @return \RelatieApiV3\StructType\UpdatePersoonNrContactResponse|bool
     */
    public function updatePersoonNrContact(\RelatieApiV3\StructType\UpdatePersoonNrContactRequest $request_parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->updatePersoonNrContact($request_parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateContPersoonNrContact
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: authentication
     * - SOAPHeaderNamespaces: http://zeno.socho.nl
     * - SOAPHeaderTypes: \RelatieApiV3\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Koppelt een bestaand contactpersoon als contactpersoon van een ander bestaand bedrijf.error15: Er is geen relatienummer opgegevenerror16: Op basis van het relatienummer is geen relatie gevondenerror17: Op basis van het relatienummer
     * bedrijf is geen relatie gevondenerror18: Op basis van het relatienummer bestaand bedrijf is geen relatie gevondenerror19: Persoon is als contactpersoon aan een ander bedrijf gekoppeld dan relatienummer_bestand_bedrijferror57: Er is reeds een persoon
     * met dezelfde gegevens en een ander relatienummer als contactpersoon gekoppelderror100: Er voldoen meerdere kandidaten
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \RelatieApiV3\StructType\UpdateContPersoonNrContactRequest $request_parameters
     * @return \RelatieApiV3\StructType\UpdateContPersoonNrContactResponse|bool
     */
    public function updateContPersoonNrContact(\RelatieApiV3\StructType\UpdateContPersoonNrContactRequest $request_parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->updateContPersoonNrContact($request_parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateAfdeling
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: authentication
     * - SOAPHeaderNamespaces: http://zeno.socho.nl
     * - SOAPHeaderTypes: \RelatieApiV3\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Wijzigen van de gegevens van een afdeling bij een bedrijf <br/><u>Let op:</u> bij wijzigingen van een bestaande afdeling dienen alle elementen opnieuw te worden meegegeven. Lege elementen of niet meegegeven (groepen) elementen worden
     * leeg gemaakt door de update.error0: De opgegeven landcode is niet gevondenerror2: Adresgegevens zijn niet compleeterror3: Adres is niet gevonden in de postcodetabelerror4: Provincie is niet gevondenerror5: Indien een provincie opgegeven wordt, is een
     * land verplichterror6: Provincie komt niet voor in het opgegeven landerror8: Het e-mail adres (1) is niet valideerror9: Het opgegeven telefoonnummer is niet valideerror15: Er is geen relatienummer opgegevenerror16: Op basis van het relatienummer is
     * geen relatie gevondenerror20: Het e-mail adres (2) is niet valideerror21: Het opgegeven faxnummer is ongeldigerror23: Op basis van het relatienummer is een bedrijf gevonden. Wijzigen persoons- of afdelingsgegevens is niet mogelijk'error24: Er is voor
     * de afdeling geen naam opgegevenerror35: De opgegeven betaalwijze is niet geldigerror36: Bij automatische incasso is een bankrekeningnummer verplichterror37: Het opgegeven bankrekeningnummer voldoet niet aan de 11-proeferror38: Bij automatische
     * incasso is een iban nummer verplichterror39: Het opgegeven IBAN nummer voldoet niet aan de eisenerror40: De opgegeven bic code is niet geldigerror41: Het opgegeven (NL-) IBAN nummer en de BIC code horen niet bij elkaarerror45: De opgegeven straatnaam
     * komt niet overeen met de straatnaam behorende bij de postcode/huisnummer combinatieerror46: De opgegeven plaatsnaam komt niet overeen met de plaatsnaam behorende bij de postcode/huisnummer combinatieerror48: De opgegeven relatie kortinggroepcode is
     * niet gevondenerror49: Op basis van de opgegeven waarde voor codeveld 1 is niets gevondenerror50: Op basis van de opgegeven waarde voor codeveld 2 is niets gevondenerror51: Op basis van de opgegeven waarde voor codeveld 3 is niets gevondenerror52: Op
     * basis van de opgegeven waarde voor codeveld 4 is niets gevondenerror53: Op basis van de opgegeven waarde voor codeveld 5 is niets gevondenerror54: Op basis van de opgegeven waarde voor codeveld 6 is niets gevondenerror71: De opgegeven taalcode is
     * niet gevondenerror72: De opgegeven valutacode is niet gevonden
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \RelatieApiV3\StructType\UpdateAfdelingRequest $request_parameters
     * @return \RelatieApiV3\StructType\UpdateAfdelingResponse|bool
     */
    public function updateAfdeling(\RelatieApiV3\StructType\UpdateAfdelingRequest $request_parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->updateAfdeling($request_parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateBedrijfInclCont
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: authentication
     * - SOAPHeaderNamespaces: http://zeno.socho.nl
     * - SOAPHeaderTypes: \RelatieApiV3\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Bijwerken van een gecombineerde bedrijf en/of contactpersoon relatiekaart (waarbij zowel bedrijf als persoonsgegevens op 1 relatiekaart opgenomen zijn). Kan alleen gebruikt worden indien systeem-constante "Invoer van bedrijven op de
     * relatiekaart inclusief contactpersoon" geactiveerd is. <br/><u>Let op:</u> bij wijzigingen van een bestaande relatie dienen alle elementen opnieuw te worden meegegeven. Lege elementen of niet meegegeven (groepen) elementen worden leeg gemaakt door de
     * update.error0: De opgegeven landcode is niet gevondenerror1: Adresgegevens ontbrekenerror2: Adresgegevens zijn niet compleeterror3: Adres is niet gevonden in de postcodetabelerror4: Provincie is niet gevondenerror5: Indien een provincie opgegeven
     * wordt, is een land verplichterror6: Provincie komt niet voor in het opgegeven landerror7: Er is geen achternaam opgegevenerror8: Het e-mail adres (1) is niet valideerror9: Het opgegeven telefoonnummer is niet valideerror10: Het opgegeven mobiele
     * telefoonnummer is niet geldigerror11: De opgegeven titulatuurcode is niet gevondenerror12: De opgegeven geboortedatum is niet geldigerror13: Het opgegeven geslacht is niet geldigerror15: Er is geen relatienummer opgegevenerror16: Op basis van het
     * relatienummer is geen relatie gevondenerror20: Het e-mail adres (2) is niet valideerror21: Het opgegeven faxnummer is ongeldigerror23: Op basis van het relatienummer is een bedrijf gevonden. Wijzigen persoonsgegevens is niet mogelijkerror35: De
     * opgegeven betaalwijze is niet geldigerror36: Bij automatische incasso is een bankrekeningnummer verplichterror37: Het opgegeven bankrekeningnummer voldoet niet aan de 11-proeferror38: Bij automatische incasso is een iban nummer verplichterror39: Het
     * opgegeven IBAN nummer voldoet niet aan de eisenerror40: De opgegeven bic code is niet geldigerror41: Het opgegeven (NL-) IBAN nummer en de BIC code horen niet bij elkaarerror45: De opgegeven straatnaam komt niet overeen met de straatnaam behorende
     * bij de postcode/huisnummer combinatieerror46: De opgegeven plaatsnaam komt niet overeen met de plaatsnaam behorende bij de postcode/huisnummer combinatieerror48: De opgegeven relatie kortinggroepcode is niet gevondenerror49: Op basis van de opgegeven
     * waarde voor codeveld 1 is niets gevondenerror50: Op basis van de opgegeven waarde voor codeveld 2 is niets gevondenerror51: Op basis van de opgegeven waarde voor codeveld 3 is niets gevondenerror52: Op basis van de opgegeven waarde voor codeveld 4 is
     * niets gevondenerror53: Op basis van de opgegeven waarde voor codeveld 5 is niets gevondenerror54: Op basis van de opgegeven waarde voor codeveld 6 is niets gevondenerror71: De opgegeven taalcode is niet gevondenerror72: De opgegeven valutacode is
     * niet gevondenerror101: De opgegeven username is niet uniekerror103: Er zijn ongeldige voorletters opgegeven.error106: Zeno is niet ingesteld om te werken met relatiekaarten met gecombineerde bedrijf en persoons gegevenserror107: Bij een relatie moet
     * minimaal een bedrijfsnaam of een achternaam opgegeven wordenerror108: Het is niet toegestaan een bedrijf, afdeling of contactpersoon te wijzigen naar een gecombineerde bedrijf en contactpersoon relatie
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \RelatieApiV3\StructType\UpdateBedrijfInclContRequest $request_parameters
     * @return \RelatieApiV3\StructType\UpdateBedrijfInclContResponse|bool
     */
    public function updateBedrijfInclCont(\RelatieApiV3\StructType\UpdateBedrijfInclContRequest $request_parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->updateBedrijfInclCont($request_parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updatePassword
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: authentication
     * - SOAPHeaderNamespaces: http://zeno.socho.nl
     * - SOAPHeaderTypes: \RelatieApiV3\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Bijwerken van het wachtwoord bij een gebruiker. Dat moet op basis van Ã³f een relatienummer, Ã³f een smartcodeerror16: Op basis van het relatienummer of de smartcode is geen relatie gevondenerror61: Het oude wachtwoord komt niet
     * overeen
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \RelatieApiV3\StructType\UpdatePasswordRequest $request_parameters
     * @return \RelatieApiV3\StructType\UpdatePasswordResponse|bool
     */
    public function updatePassword(\RelatieApiV3\StructType\UpdatePasswordRequest $request_parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->updatePassword($request_parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateEmail
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: authentication
     * - SOAPHeaderNamespaces: http://zeno.socho.nl
     * - SOAPHeaderTypes: \RelatieApiV3\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Bijwerken van het email adres bij een relatie.error16: Op basis van het relatienummer is geen relatie gevondenerror64: Eenduiding van het email veld dient {1, 2, 3 of 4} te zijn.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \RelatieApiV3\StructType\UpdateEmailRequest $request_parameters
     * @return \RelatieApiV3\StructType\UpdateEmailResponse|bool
     */
    public function updateEmail(\RelatieApiV3\StructType\UpdateEmailRequest $request_parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->updateEmail($request_parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \RelatieApiV3\StructType\UpdateAfdelingResponse|\RelatieApiV3\StructType\UpdateBedrijfInclContResponse|\RelatieApiV3\StructType\UpdateBedrijfResponse|\RelatieApiV3\StructType\UpdateContactpersoonResponse|\RelatieApiV3\StructType\UpdateContPersoonNrContactResponse|\RelatieApiV3\StructType\UpdateEmailResponse|\RelatieApiV3\StructType\UpdatePasswordResponse|\RelatieApiV3\StructType\UpdatePersoonNrContactResponse|\RelatieApiV3\StructType\UpdatePersoonResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
