<?php

namespace RelatieApiV3\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Search ServiceType
 * @subpackage Services
 * @date 20200204
 * @package RelatieApiV3
 */
class Search extends AbstractSoapClientBase
{
    /**
     * Sets the Authentication SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \RelatieApiV3\StructType\Authentication $authentication
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderAuthentication(\RelatieApiV3\StructType\Authentication $authentication, $nameSpace = 'http://zeno.socho.nl', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'authentication', $authentication, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named searchEmail
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: authentication
     * - SOAPHeaderNamespaces: http://zeno.socho.nl
     * - SOAPHeaderTypes: \RelatieApiV3\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Zoekt relatienummers bij het opgegeven e-mail adres
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \RelatieApiV3\StructType\SearchEmailRequest $request_parameters
     * @return \RelatieApiV3\StructType\SearchEmailResponse|bool
     */
    public function searchEmail(\RelatieApiV3\StructType\SearchEmailRequest $request_parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->searchEmail($request_parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named searchBedrijf
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: authentication
     * - SOAPHeaderNamespaces: http://zeno.socho.nl
     * - SOAPHeaderTypes: \RelatieApiV3\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Zoeken naar bedrijven op basis van postcode + huisnummer
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \RelatieApiV3\StructType\SearchBedrijfRequest $request_parameters
     * @return \RelatieApiV3\StructType\SearchBedrijfResponse|bool
     */
    public function searchBedrijf(\RelatieApiV3\StructType\SearchBedrijfRequest $request_parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->searchBedrijf($request_parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named searchNaam
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: authentication
     * - SOAPHeaderNamespaces: http://zeno.socho.nl
     * - SOAPHeaderTypes: \RelatieApiV3\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Zoeken naar relaties op basis van de naamerror15: Er is geen zoekvoorwaarde opgegevenerror1104: Ongeldige zoekMethodeerror1105: Ongeldige relatieType
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \RelatieApiV3\StructType\SearchNaamRequest $request_parameters
     * @return \RelatieApiV3\StructType\SearchNaamResponse|bool
     */
    public function searchNaam(\RelatieApiV3\StructType\SearchNaamRequest $request_parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->searchNaam($request_parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named searchPersoon
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: authentication
     * - SOAPHeaderNamespaces: http://zeno.socho.nl
     * - SOAPHeaderTypes: \RelatieApiV3\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Zoeken naar personen op basis van postcode + huisnummer of e-mail 1 of e-mail 2
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \RelatieApiV3\StructType\SearchPersoonRequest $request_parameters
     * @return \RelatieApiV3\StructType\SearchPersoonResponse|bool
     */
    public function searchPersoon(\RelatieApiV3\StructType\SearchPersoonRequest $request_parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->searchPersoon($request_parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named searchBedrijfInclCont
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: authentication
     * - SOAPHeaderNamespaces: http://zeno.socho.nl
     * - SOAPHeaderTypes: \RelatieApiV3\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Zoeken naar relaties op basis van postcode + huisnummer of e-mail 1, e-mail 2, e-mail 3 of e-mail 4 Kan alleen gebruikt worden indien systeem-constante "Invoer van bedrijven op de relatiekaart inclusief contactpersoon" geactiveerd
     * is.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \RelatieApiV3\StructType\SearchBedrijfInclContRequest $request_parameters
     * @return \RelatieApiV3\StructType\SearchBedrijfInclContResponse|bool
     */
    public function searchBedrijfInclCont(\RelatieApiV3\StructType\SearchBedrijfInclContRequest $request_parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->searchBedrijfInclCont($request_parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named searchUsername
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: authentication
     * - SOAPHeaderNamespaces: http://zeno.socho.nl
     * - SOAPHeaderTypes: \RelatieApiV3\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Geeft het relatienummer terug van de relatie behorende bij de usernameerror1: Op basis van de username is geen unieke relatie gevonden.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \RelatieApiV3\StructType\SearchUsernameRequest $request_parameters
     * @return \RelatieApiV3\StructType\SearchUsernameResponse|bool
     */
    public function searchUsername(\RelatieApiV3\StructType\SearchUsernameRequest $request_parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->searchUsername($request_parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named searchSmartcode
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: authentication
     * - SOAPHeaderNamespaces: http://zeno.socho.nl
     * - SOAPHeaderTypes: \RelatieApiV3\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Geeft het relatienummer terug van de relatie behorende bij de smartcodeerror1: Op basis van de smartcode is geen relatie gevonden
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \RelatieApiV3\StructType\SearchSmartcodeRequest $request_parameters
     * @return \RelatieApiV3\StructType\SearchSmartcodeResponse|bool
     */
    public function searchSmartcode(\RelatieApiV3\StructType\SearchSmartcodeRequest $request_parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->searchSmartcode($request_parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \RelatieApiV3\StructType\SearchBedrijfInclContResponse|\RelatieApiV3\StructType\SearchBedrijfResponse|\RelatieApiV3\StructType\SearchEmailResponse|\RelatieApiV3\StructType\SearchNaamResponse|\RelatieApiV3\StructType\SearchPersoonResponse|\RelatieApiV3\StructType\SearchSmartcodeResponse|\RelatieApiV3\StructType\SearchUsernameResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
