<?php

namespace RelatieApiV3\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Create ServiceType
 * @subpackage Services
 * @date 20200204
 * @package RelatieApiV3
 */
class Create extends AbstractSoapClientBase
{
    /**
     * Sets the Authentication SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \RelatieApiV3\StructType\Authentication $authentication
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderAuthentication(\RelatieApiV3\StructType\Authentication $authentication, $nameSpace = 'http://zeno.socho.nl', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'authentication', $authentication, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named createPersoon
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: authentication
     * - SOAPHeaderNamespaces: http://zeno.socho.nl
     * - SOAPHeaderTypes: \RelatieApiV3\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Aanmaken van een nieuw prive persoonerror0: De opgegeven landcode is niet gevondenerror1: Adresgegevens ontbrekenerror2: Adresgegevens zijn niet compleeterror3: Adres is niet gevonden in de postcodetabelerror4: Provincie is niet
     * gevondenerror5: Indien een provincie opgegeven wordt, is een land verplichterror6: Provincie komt niet voor in het opgegeven landerror7: Er is geen achternaam opgegevenerror8: Het e-mail adres (1) is niet valideerror9: Het opgegeven telefoonnummer is
     * niet valideerror10: Het opgegeven mobiele telefoonnummer is niet geldigerror11: De opgegeven titulatuurcode is niet gevondenerror12: De opgegeven geboortedatum is niet geldigerror13: Het opgegeven geslacht is niet geldigerror20: Het e-mail adres (2)
     * is niet valideerror35: De opgegeven betaalwijze is niet geldigerror36: Bij automatische incasso is een bankrekeningnummer verplichterror37: Het opgegeven bankrekeningnummer voldoet niet aan de 11-proeferror38: Bij automatische incasso is een iban
     * nummer verplichterror39: Het opgegeven IBAN nummer voldoet niet aan de eisenerror40: De opgegeven bic code is niet geldigerror41: Het opgegeven (NL-) IBAN nummer en de BIC code horen niet bij elkaarerror45: De opgegeven straatnaam komt niet overeen
     * met de straatnaam behorende bij de postcode/huisnummer combinatieerror46: De opgegeven plaatsnaam komt niet overeen met de plaatsnaam behorende bij de postcode/huisnummer combinatieerror48: De opgegeven relatie kortinggroepcode is niet
     * gevondenerror49: Op basis van de opgegeven waarde voor codeveld 1 is niets gevondenerror50: Op basis van de opgegeven waarde voor codeveld 2 is niets gevondenerror51: Op basis van de opgegeven waarde voor codeveld 3 is niets gevondenerror52: Op basis
     * van de opgegeven waarde voor codeveld 4 is niets gevondenerror53: Op basis van de opgegeven waarde voor codeveld 5 is niets gevondenerror54: Op basis van de opgegeven waarde voor codeveld 6 is niets gevondenerror71: De opgegeven taalcode is niet
     * gevondenerror72: De opgegeven valutacode is niet gevondenerror100: Op basis van de input bestaan al meerdere relatieserror101: De opgegeven username is niet uniekerror102: Het opgegeven e-mail adres 2 is niet uniekerror103: Er zijn ongeldige
     * voorletters opgegeven.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \RelatieApiV3\StructType\CreatePersoonRequest $request_parameters
     * @return \RelatieApiV3\StructType\CreatePersoonResponse|bool
     */
    public function createPersoon(\RelatieApiV3\StructType\CreatePersoonRequest $request_parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->createPersoon($request_parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named createBedrijf
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: authentication
     * - SOAPHeaderNamespaces: http://zeno.socho.nl
     * - SOAPHeaderTypes: \RelatieApiV3\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Aanmaken van een nieuw bedrijferror0: De opgegeven landcode is niet gevondenerror1: Adresgegevens ontbrekenerror2: Adresgegevens zijn niet compleeterror3: Adres is niet gevonden in de postcodetabelerror4: Provincie is niet
     * gevondenerror5: Indien een provincie opgegeven wordt, is een land verplichterror6: Provincie komt niet voor in het opgegeven landerror8: Het e-mail adres (1) is niet valideerror9: Het opgegeven telefoonnummer is niet valideerror19: Er is voor het
     * bedrijf geen naam opgegevenerror20: Het e-mail adres (2) is niet valideerror21: Het opgegeven faxnummer is ongeldigerror35: De opgegeven betaalwijze is niet geldigerror36: Bij automatische incasso is een bankrekeningnummer verplichterror37: Het
     * opgegeven bankrekeningnummer voldoet niet aan de 11-proeferror38: Bij automatische incasso is een iban nummer verplichterror39: Het opgegeven IBAN nummer voldoet niet aan de eisenerror40: De opgegeven bic code is niet geldigerror41: Het opgegeven
     * (NL-) IBAN nummer en de BIC code horen niet bij elkaarerror45: De opgegeven straatnaam komt niet overeen met de straatnaam behorende bij de postcode/huisnummer combinatieerror46: De opgegeven plaatsnaam komt niet overeen met de plaatsnaam behorende
     * bij de postcode/huisnummer combinatieerror48: De opgegeven relatie kortinggroepcode is niet gevondenerror49: Op basis van de opgegeven waarde voor codeveld 1 is niets gevondenerror50: Op basis van de opgegeven waarde voor codeveld 2 is niets
     * gevondenerror51: Op basis van de opgegeven waarde voor codeveld 3 is niets gevondenerror52: Op basis van de opgegeven waarde voor codeveld 4 is niets gevondenerror53: Op basis van de opgegeven waarde voor codeveld 5 is niets gevondenerror54: Op basis
     * van de opgegeven waarde voor codeveld 6 is niets gevondenerror58: Bij BTW-indicatie intra-communautair is een BTW-nummer verplichterror60: Er is een ongeldig BTW-nummer meegegevenerror71: De opgegeven taalcode is niet gevondenerror72: De opgegeven
     * valutacode is niet gevondenerror100: Op basis van de input bestaan al meerdere relaties
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \RelatieApiV3\StructType\CreateBedrijfRequest $request_parameters
     * @return \RelatieApiV3\StructType\CreateBedrijfResponse|bool
     */
    public function createBedrijf(\RelatieApiV3\StructType\CreateBedrijfRequest $request_parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->createBedrijf($request_parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named createContactpersoon
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: authentication
     * - SOAPHeaderNamespaces: http://zeno.socho.nl
     * - SOAPHeaderTypes: \RelatieApiV3\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Aanmaken van een nieuw contactpersoon bij een bedrijf<BR><BR> Indien een nieuw bedrijf aangemaakt wordt, zie voor de foutmeldingen createBedrijf!error0: De opgegeven landcode is niet gevondenerror2: Adresgegevens zijn niet
     * compleeterror3: Adres is niet gevonden in de postcodetabelerror4: Provincie is niet gevondenerror5: Indien een provincie opgegeven wordt, is een land verplichterror6: Provincie komt niet voor in het opgegeven landerror7: Er is geen achternaam
     * opgegevenerror8: Het e-mail adres (1) is niet valideerror9: Het opgegeven telefoonnummer is niet valideerror10: Het opgegeven mobiele telefoonnummer is niet geldigerror11: De opgegeven titulatuurcode is niet gevondenerror12: De opgegeven
     * geboortedatum is niet geldigerror13: Het opgegeven geslacht is niet geldigerror17: Op basis van het relatienummer bedrijf is geen relatie gevondenerror18: De op basis van het relatienummer bedrijf gevonden relatie is geen bedrijferror20: Het e-mail
     * adres (2) is niet valideerror22: Er is geen relatienummer voor het bedrijf opgegevenerror35: De opgegeven betaalwijze is niet geldigerror36: Bij automatische incasso is een bankrekeningnummer verplichterror37: Het opgegeven bankrekeningnummer voldoet
     * niet aan de 11-proeferror38: Bij automatische incasso is een iban nummer verplichterror39: Het opgegeven IBAN nummer voldoet niet aan de eisenerror40: De opgegeven bic code is niet geldigerror41: Het opgegeven (NL-) IBAN nummer en de BIC code horen
     * niet bij elkaarerror45: De opgegeven straatnaam komt niet overeen met de straatnaam behorende bij de postcode/huisnummer combinatieerror46: De opgegeven plaatsnaam komt niet overeen met de plaatsnaam behorende bij de postcode/huisnummer
     * combinatieerror48: De opgegeven relatie kortinggroepcode is niet gevondenerror49: Op basis van de opgegeven waarde voor codeveld 1 is niets gevondenerror50: Op basis van de opgegeven waarde voor codeveld 2 is niets gevondenerror51: Op basis van de
     * opgegeven waarde voor codeveld 3 is niets gevondenerror52: Op basis van de opgegeven waarde voor codeveld 4 is niets gevondenerror53: Op basis van de opgegeven waarde voor codeveld 5 is niets gevondenerror54: Op basis van de opgegeven waarde voor
     * codeveld 6 is niets gevondenerror71: De opgegeven taalcode is niet gevondenerror72: De opgegeven valutacode is niet gevondenerror100: Er voldoen meerdere kandidatenerror101: De opgegeven username is niet uniekerror103: Er zijn ongeldige voorletters
     * opgegeven.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \RelatieApiV3\StructType\CreateContactpersoonRequest $request_parameters
     * @return \RelatieApiV3\StructType\CreateContactpersoonResponse|bool
     */
    public function createContactpersoon(\RelatieApiV3\StructType\CreateContactpersoonRequest $request_parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->createContactpersoon($request_parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named createAfdeling
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: authentication
     * - SOAPHeaderNamespaces: http://zeno.socho.nl
     * - SOAPHeaderTypes: \RelatieApiV3\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Aanmaken van een nieuwe afdeling bij een bedrijferror0: De opgegeven landcode is niet gevondenerror1: Adresgegevens ontbrekenerror2: Adresgegevens zijn niet compleeterror3: Adres is niet gevonden in de postcodetabelerror4: Provincie
     * is niet gevondenerror5: Indien een provincie opgegeven wordt, is een land verplichterror6: Provincie komt niet voor in het opgegeven landerror8: Het e-mail adres (1) is niet valideerror9: Het opgegeven telefoonnummer is niet valideerror17: Op basis
     * van het relatienummer bedrijf is geen relatie gevondenerror18: De op basis van het relatienummer bedrijf gevonden relatie is geen bedrijferror20: Het e-mail adres (2) is niet valideerror21: Het opgegeven faxnummer is ongeldigerror22: Er is geen
     * relatienummer voor het bedrijf opgegevenerror24: Er is voor de afdeling geen naam opgegevenerror35: De opgegeven betaalwijze is niet geldigerror36: Bij automatische incasso is een bankrekeningnummer verplichterror37: Het opgegeven bankrekeningnummer
     * voldoet niet aan de 11-proeferror38: Bij automatische incasso is een iban nummer verplichterror39: Het opgegeven IBAN nummer voldoet niet aan de eisenerror40: De opgegeven bic code is niet geldigerror41: Het opgegeven (NL-) IBAN nummer en de BIC code
     * horen niet bij elkaarerror45: De opgegeven straatnaam komt niet overeen met de straatnaam behorende bij de postcode/huisnummer combinatieerror46: De opgegeven plaatsnaam komt niet overeen met de plaatsnaam behorende bij de postcode/huisnummer
     * combinatieerror48: De opgegeven relatie kortinggroepcode is niet gevondenerror49: Op basis van de opgegeven waarde voor codeveld 1 is niets gevondenerror50: Op basis van de opgegeven waarde voor codeveld 2 is niets gevondenerror51: Op basis van de
     * opgegeven waarde voor codeveld 3 is niets gevondenerror52: Op basis van de opgegeven waarde voor codeveld 4 is niets gevondenerror53: Op basis van de opgegeven waarde voor codeveld 5 is niets gevondenerror54: Op basis van de opgegeven waarde voor
     * codeveld 6 is niets gevondenerror71: De opgegeven taalcode is niet gevondenerror72: De opgegeven valutacode is niet gevondenerror100: Op basis van de input bestaan al meerdere relaties
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \RelatieApiV3\StructType\CreateAfdelingRequest $request_parameters
     * @return \RelatieApiV3\StructType\CreateAfdelingResponse|bool
     */
    public function createAfdeling(\RelatieApiV3\StructType\CreateAfdelingRequest $request_parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->createAfdeling($request_parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named createBedrijfInclCont
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: authentication
     * - SOAPHeaderNamespaces: http://zeno.socho.nl
     * - SOAPHeaderTypes: \RelatieApiV3\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Aanmaken van een nieuwe gecombineerde bedrijf en/of contactpersoon relatie (zowel bedrijf als persoonsgegevens op 1 relatiekaart). Kan alleen gebruikt worden indien systeem-constante "Invoer van bedrijven op de relatiekaart inclusief
     * contactpersoon" geactiveerd is.error0: De opgegeven landcode is niet gevondenerror1: Adresgegevens ontbrekenerror2: Adresgegevens zijn niet compleeterror3: Adres is niet gevonden in de postcodetabelerror4: Provincie is niet gevondenerror5: Indien een
     * provincie opgegeven wordt, is een land verplichterror6: Provincie komt niet voor in het opgegeven landerror7: Er is geen achternaam opgegevenerror8: Het e-mail adres (1) is niet valideerror9: Het opgegeven telefoonnummer is niet valideerror10: Het
     * opgegeven mobiele telefoonnummer is niet geldigerror11: De opgegeven titulatuurcode is niet gevondenerror12: De opgegeven geboortedatum is niet geldigerror13: Het opgegeven geslacht is niet geldigerror20: Het e-mail adres (2) is niet valideerror21:
     * Het opgegeven faxnummer is ongeldigerror35: De opgegeven betaalwijze is niet geldigerror36: Bij automatische incasso is een bankrekeningnummer verplichterror37: Het opgegeven bankrekeningnummer voldoet niet aan de 11-proeferror38: Bij automatische
     * incasso is een iban nummer verplichterror39: Het opgegeven IBAN nummer voldoet niet aan de eisenerror40: De opgegeven bic code is niet geldigerror41: Het opgegeven (NL-) IBAN nummer en de BIC code horen niet bij elkaarerror43: Het e-mail adres (3) is
     * niet valideerror44: Het e-mail adres (4) is niet valideerror45: De opgegeven straatnaam komt niet overeen met de straatnaam behorende bij de postcode/huisnummer combinatieerror46: De opgegeven plaatsnaam komt niet overeen met de plaatsnaam behorende
     * bij de postcode/huisnummer combinatieerror48: De opgegeven relatie kortinggroepcode is niet gevondenerror49: Op basis van de opgegeven waarde voor codeveld 1 is niets gevondenerror50: Op basis van de opgegeven waarde voor codeveld 2 is niets
     * gevondenerror51: Op basis van de opgegeven waarde voor codeveld 3 is niets gevondenerror52: Op basis van de opgegeven waarde voor codeveld 4 is niets gevondenerror53: Op basis van de opgegeven waarde voor codeveld 5 is niets gevondenerror54: Op basis
     * van de opgegeven waarde voor codeveld 6 is niets gevondenerror58: Bij BTW-indicatie intra-communautair is een BTW-nummer verplichterror60: Er is een ongeldig BTW-nummer meegegevenerror71: De opgegeven taalcode is niet gevondenerror72: De opgegeven
     * valutacode is niet gevondenerror100: Op basis van de input bestaan al meerdere relatieserror101: De opgegeven username is niet uniekerror102: Het opgegeven e-mail adres 2 is niet uniekerror103: Er zijn ongeldige voorletters opgegeven.error106: Zeno
     * is niet ingesteld om te werken met relatiekaarten met gecombineerde bedrijf en persoons gegevenserror107: Bij een relatie moet minimaal een bedrijfsnaam of een achternaam opgegeven worden
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \RelatieApiV3\StructType\CreateBedrijfInclContRequest $request_parameters
     * @return \RelatieApiV3\StructType\CreateBedrijfInclContResponse|bool
     */
    public function createBedrijfInclCont(\RelatieApiV3\StructType\CreateBedrijfInclContRequest $request_parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->createBedrijfInclCont($request_parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named createActiviteit
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: authentication
     * - SOAPHeaderNamespaces: http://zeno.socho.nl
     * - SOAPHeaderTypes: \RelatieApiV3\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Aanmaken van een activiteit of todo. De activiteit wordt bij een relatie opgeslagen. Door het activiteittype (op te vragen via getActiviteittypen) op te geven wordt bepaald wat voor type activiteit aangemaakt wordt, en aan welke
     * gebruiker deze toebedeeld wordt.<BR> Als bij het activiteittype geen gebruiker is gekoppeld, kan bij het aanmaken van de activiteit ook een gebruikerscode opgegeven wordenerror16: Op basis van het relatienummer is geen relatie gevondenerror58: Het
     * activiteittype is niet gevondenerror59: Het opgegeven activiteittype is niet actieferror65: De gebruiker is niet gevondenerror66: De opgegeven gebruiker is niet actieferror67: Bij het aanmaken van een todo is het opgeven van een gebruiker verplicht
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \RelatieApiV3\StructType\CreateActiviteitRequest $request_parameters
     * @return \RelatieApiV3\StructType\CreateActiviteitResponse|bool
     */
    public function createActiviteit(\RelatieApiV3\StructType\CreateActiviteitRequest $request_parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->createActiviteit($request_parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \RelatieApiV3\StructType\CreateActiviteitResponse|\RelatieApiV3\StructType\CreateAfdelingResponse|\RelatieApiV3\StructType\CreateBedrijfInclContResponse|\RelatieApiV3\StructType\CreateBedrijfResponse|\RelatieApiV3\StructType\CreateContactpersoonResponse|\RelatieApiV3\StructType\CreatePersoonResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
