<?php

namespace RelatieApiV3\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Check ServiceType
 * @subpackage Services
 * @date 20200204
 * @package RelatieApiV3
 */
class Check extends AbstractSoapClientBase
{
    /**
     * Sets the Authentication SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \RelatieApiV3\StructType\Authentication $authentication
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderAuthentication(\RelatieApiV3\StructType\Authentication $authentication, $nameSpace = 'http://zeno.socho.nl', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'authentication', $authentication, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named checkEmail
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: authentication
     * - SOAPHeaderNamespaces: http://zeno.socho.nl
     * - SOAPHeaderTypes: \RelatieApiV3\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Controleren van gebruik van een e-mail adres. Controleer eerst of de relatie kan worden bepaald aan de hand van het email adres van de relatie, als er op basis daarvan meerdere worden gevonden, wordt bepaald of op basis van ook de
     * username toch een unieke relatie kan worden gevonden.error15: Er is geen relatienummer opgegevenerror16: Op basis van het relatienummer is geen relatie gevondenerror70: De relatie met het opgegeven relatienummer is niet van het type 'Afdeling'.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \RelatieApiV3\StructType\CheckEmailRequest $request_parameters
     * @return \RelatieApiV3\StructType\CheckEmailResponse|bool
     */
    public function checkEmail(\RelatieApiV3\StructType\CheckEmailRequest $request_parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->checkEmail($request_parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named checkCredentials
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: authentication
     * - SOAPHeaderNamespaces: http://zeno.socho.nl
     * - SOAPHeaderTypes: \RelatieApiV3\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Controleren van username + password combinatieerror45: Op basis van de inloggegevens is geen relatie gevonden
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \RelatieApiV3\StructType\CheckCredentialsRequest $request_parameters
     * @return \RelatieApiV3\StructType\CheckCredentialsResponse|bool
     */
    public function checkCredentials(\RelatieApiV3\StructType\CheckCredentialsRequest $request_parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->checkCredentials($request_parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named checkIban
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: authentication
     * - SOAPHeaderNamespaces: http://zeno.socho.nl
     * - SOAPHeaderTypes: \RelatieApiV3\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Checkt of een IBAN nummer voldoet aan de eisen, d.w.z. de algemene specs. voor valide IBAN, zoals check op controle getal, maximum aantal cijfers, etc.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \RelatieApiV3\StructType\CheckIbanRequest $request_parameters
     * @return \RelatieApiV3\StructType\CheckIbanResponse|bool
     */
    public function checkIban(\RelatieApiV3\StructType\CheckIbanRequest $request_parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->checkIban($request_parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named checkTelefoon
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: authentication
     * - SOAPHeaderNamespaces: http://zeno.socho.nl
     * - SOAPHeaderTypes: \RelatieApiV3\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Checkt of een telefoon nummer voldoet aan de eisen die Zeno stelt. <br/>Een leeg telefoonnummer is niet geldig. <br/> <br/>Als het land Nederland is of geen land is meegegeven: <br/>- Haal alle niet numerieke karakters uit het
     * telefoonnummer. <br/>- Haal eventueel +31 eraf als het aan het begin staat. (en + aan het begin wordt overgeslagen in de vorige stap) en zet er dan nog een 0 voor om een compleet netnummer te krijgen. <br/>- Als het nummer op dit moment niet uit 9 of
     * 10 cijfers bestaat is het ongeldig. <br/>- Als het nummer uit 9 cijfers bestaat, maar het eerste cijfer is ongelijk aan 0 wordt er nog een voorloopnul voor gezet. Anders is het ongeldig. <br/>- Er wordt gecontroleerd of het nummer begin met een van
     * de netnummers uit de Zeno netnummer tabel, anders is het ongeldig. <br/> <br/>Anders als het buitenland is: <br/>- Er wordt gecontroleerd of het nummer uit de tekens 0 t/m 9 bestaat of een (, ), - of een + aan het begin, als dat niet zo is is het
     * ongeldig.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \RelatieApiV3\StructType\CheckTelefoonRequest $request_parameters
     * @return \RelatieApiV3\StructType\CheckTelefoonResponse|bool
     */
    public function checkTelefoon(\RelatieApiV3\StructType\CheckTelefoonRequest $request_parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->checkTelefoon($request_parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \RelatieApiV3\StructType\CheckCredentialsResponse|\RelatieApiV3\StructType\CheckEmailResponse|\RelatieApiV3\StructType\CheckIbanResponse|\RelatieApiV3\StructType\CheckTelefoonResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
