<?php

namespace RelatieApiV3\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Add ServiceType
 * @subpackage Services
 * @date 20200204
 * @package RelatieApiV3
 */
class Add extends AbstractSoapClientBase
{
    /**
     * Sets the Authentication SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \RelatieApiV3\StructType\Authentication $authentication
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderAuthentication(\RelatieApiV3\StructType\Authentication $authentication, $nameSpace = 'http://zeno.socho.nl', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'authentication', $authentication, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named addBic
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: authentication
     * - SOAPHeaderNamespaces: http://zeno.socho.nl
     * - SOAPHeaderTypes: \RelatieApiV3\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Toevoegen van een Bic code aan een bestaande relatie in Zeno op basis van relatienummer en Bic-codeerror15: Er is geen relatienummer opgegevenerror16: Op basis van het opgegeven nummer is geen relatie gevondenerror25: Er is geen
     * Bic-code opgegevenerror26: De opgegeven bic-code is niet gevondenerror31: De opgegeven bic-code is al gekoppeld aan de relatie
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \RelatieApiV3\StructType\AddBicRequest $request_parameters
     * @return \RelatieApiV3\StructType\AddBicResponse|bool
     */
    public function addBic(\RelatieApiV3\StructType\AddBicRequest $request_parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->addBic($request_parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addFunctie
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: authentication
     * - SOAPHeaderNamespaces: http://zeno.socho.nl
     * - SOAPHeaderTypes: \RelatieApiV3\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Toevoegen van een functie aan een bestaande relatieerror15: Er is geen relatienummer opgegevenerror16: Op basis van het opgegeven nummer is geen relatie gevondenerror29: Er is geen functiecode opgegevenerror30: De opgegeven
     * functiecode is niet gevondenerror32: De opgegeven functiecode is al gekoppeld aan de relatie
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \RelatieApiV3\StructType\AddFunctieRequest $request_parameters
     * @return \RelatieApiV3\StructType\AddFunctieResponse|bool
     */
    public function addFunctie(\RelatieApiV3\StructType\AddFunctieRequest $request_parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->addFunctie($request_parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \RelatieApiV3\StructType\AddBicResponse|\RelatieApiV3\StructType\AddFunctieResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
