<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the fist needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientbase class each generated ServiceType class extends this class
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'main.wsdl',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc....
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'main.wsdl',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => \RelatieApiV3\ClassMap::get(),
);
/**
 * Samples for Test ServiceType
 */
$test = new \RelatieApiV3\ServiceType\Test($options);
$test->setSoapHeaderAuthentication(new \RelatieApiV3\StructType\Authentication());
/**
 * Sample call for testConnection operation/method
 */
if ($test->testConnection(new \RelatieApiV3\StructType\TestConnectionRequest()) !== false) {
    print_r($test->getResult());
} else {
    print_r($test->getLastError());
}
/**
 * Samples for Create ServiceType
 */
$create = new \RelatieApiV3\ServiceType\Create($options);
$create->setSoapHeaderAuthentication(new \RelatieApiV3\StructType\Authentication());
/**
 * Sample call for createPersoon operation/method
 */
if ($create->createPersoon(new \RelatieApiV3\StructType\CreatePersoonRequest()) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Sample call for createBedrijf operation/method
 */
if ($create->createBedrijf(new \RelatieApiV3\StructType\CreateBedrijfRequest()) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Sample call for createContactpersoon operation/method
 */
if ($create->createContactpersoon(new \RelatieApiV3\StructType\CreateContactpersoonRequest()) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Sample call for createAfdeling operation/method
 */
if ($create->createAfdeling(new \RelatieApiV3\StructType\CreateAfdelingRequest()) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Sample call for createBedrijfInclCont operation/method
 */
if ($create->createBedrijfInclCont(new \RelatieApiV3\StructType\CreateBedrijfInclContRequest()) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Sample call for createActiviteit operation/method
 */
if ($create->createActiviteit(new \RelatieApiV3\StructType\CreateActiviteitRequest()) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Samples for Update ServiceType
 */
$update = new \RelatieApiV3\ServiceType\Update($options);
$update->setSoapHeaderAuthentication(new \RelatieApiV3\StructType\Authentication());
/**
 * Sample call for updatePersoon operation/method
 */
if ($update->updatePersoon(new \RelatieApiV3\StructType\UpdatePersoonRequest()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for updateBedrijf operation/method
 */
if ($update->updateBedrijf(new \RelatieApiV3\StructType\UpdateBedrijfRequest()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for updateContactpersoon operation/method
 */
if ($update->updateContactpersoon(new \RelatieApiV3\StructType\UpdateContactpersoonRequest()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for updatePersoonNrContact operation/method
 */
if ($update->updatePersoonNrContact(new \RelatieApiV3\StructType\UpdatePersoonNrContactRequest()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for updateContPersoonNrContact operation/method
 */
if ($update->updateContPersoonNrContact(new \RelatieApiV3\StructType\UpdateContPersoonNrContactRequest()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for updateAfdeling operation/method
 */
if ($update->updateAfdeling(new \RelatieApiV3\StructType\UpdateAfdelingRequest()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for updateBedrijfInclCont operation/method
 */
if ($update->updateBedrijfInclCont(new \RelatieApiV3\StructType\UpdateBedrijfInclContRequest()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for updatePassword operation/method
 */
if ($update->updatePassword(new \RelatieApiV3\StructType\UpdatePasswordRequest()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for updateEmail operation/method
 */
if ($update->updateEmail(new \RelatieApiV3\StructType\UpdateEmailRequest()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Samples for Delete ServiceType
 */
$delete = new \RelatieApiV3\ServiceType\Delete($options);
$delete->setSoapHeaderAuthentication(new \RelatieApiV3\StructType\Authentication());
/**
 * Sample call for deleteContPersoonNrContact operation/method
 */
if ($delete->deleteContPersoonNrContact(new \RelatieApiV3\StructType\DeleteContPersoonNrContactRequest()) !== false) {
    print_r($delete->getResult());
} else {
    print_r($delete->getLastError());
}
/**
 * Sample call for deleteBic operation/method
 */
if ($delete->deleteBic(new \RelatieApiV3\StructType\DeleteBicRequest()) !== false) {
    print_r($delete->getResult());
} else {
    print_r($delete->getLastError());
}
/**
 * Sample call for deleteFunctie operation/method
 */
if ($delete->deleteFunctie(new \RelatieApiV3\StructType\DeleteFunctieRequest()) !== false) {
    print_r($delete->getResult());
} else {
    print_r($delete->getLastError());
}
/**
 * Samples for Add ServiceType
 */
$add = new \RelatieApiV3\ServiceType\Add($options);
$add->setSoapHeaderAuthentication(new \RelatieApiV3\StructType\Authentication());
/**
 * Sample call for addBic operation/method
 */
if ($add->addBic(new \RelatieApiV3\StructType\AddBicRequest()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for addFunctie operation/method
 */
if ($add->addFunctie(new \RelatieApiV3\StructType\AddFunctieRequest()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Samples for Get ServiceType
 */
$get = new \RelatieApiV3\ServiceType\Get($options);
$get->setSoapHeaderAuthentication(new \RelatieApiV3\StructType\Authentication());
/**
 * Sample call for getFuncties operation/method
 */
if ($get->getFuncties(new \RelatieApiV3\StructType\GetFunctiesRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getBiccodes operation/method
 */
if ($get->getBiccodes(new \RelatieApiV3\StructType\GetBiccodesRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getTitulatuurcodes operation/method
 */
if ($get->getTitulatuurcodes(new \RelatieApiV3\StructType\GetTitulatuurcodesRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getLandcodes operation/method
 */
if ($get->getLandcodes(new \RelatieApiV3\StructType\GetLandcodesRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getTaalcodes operation/method
 */
if ($get->getTaalcodes(new \RelatieApiV3\StructType\GetTaalcodesRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getProvinciecodes operation/method
 */
if ($get->getProvinciecodes(new \RelatieApiV3\StructType\GetProvinciecodesRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getRelatietype operation/method
 */
if ($get->getRelatietype(new \RelatieApiV3\StructType\GetRelatietypeRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getPersoon operation/method
 */
if ($get->getPersoon(new \RelatieApiV3\StructType\GetPersoonRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getPersonen operation/method
 */
if ($get->getPersonen(new \RelatieApiV3\StructType\GetPersonenRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getBedrijf operation/method
 */
if ($get->getBedrijf(new \RelatieApiV3\StructType\GetBedrijfRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getContactpersoon operation/method
 */
if ($get->getContactpersoon(new \RelatieApiV3\StructType\GetContactpersoonRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getAfdeling operation/method
 */
if ($get->getAfdeling(new \RelatieApiV3\StructType\GetAfdelingRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getBedrijfInclCont operation/method
 */
if ($get->getBedrijfInclCont(new \RelatieApiV3\StructType\GetBedrijfInclContRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getRelatieKortinggroepen operation/method
 */
if ($get->getRelatieKortinggroepen(new \RelatieApiV3\StructType\GetRelatieKortinggroepenRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getNetnummers operation/method
 */
if ($get->getNetnummers(new \RelatieApiV3\StructType\GetNetnummersRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getActiviteittypen operation/method
 */
if ($get->getActiviteittypen(new \RelatieApiV3\StructType\GetActiviteittypenRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getAdres operation/method
 */
if ($get->getAdres(new \RelatieApiV3\StructType\GetAdresRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getBicVanIban operation/method
 */
if ($get->getBicVanIban(new \RelatieApiV3\StructType\GetBicVanIbanRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getIbanVanBankrekening operation/method
 */
if ($get->getIbanVanBankrekening(new \RelatieApiV3\StructType\GetIbanVanBankrekeningRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getSmartcodeByRelNo operation/method
 */
if ($get->getSmartcodeByRelNo(new \RelatieApiV3\StructType\GetSmartcodeByRelNoRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getKenmerken operation/method
 */
if ($get->getKenmerken(new \RelatieApiV3\StructType\GetKenmerkenRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Samples for Check ServiceType
 */
$check = new \RelatieApiV3\ServiceType\Check($options);
$check->setSoapHeaderAuthentication(new \RelatieApiV3\StructType\Authentication());
/**
 * Sample call for checkEmail operation/method
 */
if ($check->checkEmail(new \RelatieApiV3\StructType\CheckEmailRequest()) !== false) {
    print_r($check->getResult());
} else {
    print_r($check->getLastError());
}
/**
 * Sample call for checkCredentials operation/method
 */
if ($check->checkCredentials(new \RelatieApiV3\StructType\CheckCredentialsRequest()) !== false) {
    print_r($check->getResult());
} else {
    print_r($check->getLastError());
}
/**
 * Sample call for checkIban operation/method
 */
if ($check->checkIban(new \RelatieApiV3\StructType\CheckIbanRequest()) !== false) {
    print_r($check->getResult());
} else {
    print_r($check->getLastError());
}
/**
 * Sample call for checkTelefoon operation/method
 */
if ($check->checkTelefoon(new \RelatieApiV3\StructType\CheckTelefoonRequest()) !== false) {
    print_r($check->getResult());
} else {
    print_r($check->getLastError());
}
/**
 * Samples for Search ServiceType
 */
$search = new \RelatieApiV3\ServiceType\Search($options);
$search->setSoapHeaderAuthentication(new \RelatieApiV3\StructType\Authentication());
/**
 * Sample call for searchEmail operation/method
 */
if ($search->searchEmail(new \RelatieApiV3\StructType\SearchEmailRequest()) !== false) {
    print_r($search->getResult());
} else {
    print_r($search->getLastError());
}
/**
 * Sample call for searchBedrijf operation/method
 */
if ($search->searchBedrijf(new \RelatieApiV3\StructType\SearchBedrijfRequest()) !== false) {
    print_r($search->getResult());
} else {
    print_r($search->getLastError());
}
/**
 * Sample call for searchNaam operation/method
 */
if ($search->searchNaam(new \RelatieApiV3\StructType\SearchNaamRequest()) !== false) {
    print_r($search->getResult());
} else {
    print_r($search->getLastError());
}
/**
 * Sample call for searchPersoon operation/method
 */
if ($search->searchPersoon(new \RelatieApiV3\StructType\SearchPersoonRequest()) !== false) {
    print_r($search->getResult());
} else {
    print_r($search->getLastError());
}
/**
 * Sample call for searchBedrijfInclCont operation/method
 */
if ($search->searchBedrijfInclCont(new \RelatieApiV3\StructType\SearchBedrijfInclContRequest()) !== false) {
    print_r($search->getResult());
} else {
    print_r($search->getLastError());
}
/**
 * Sample call for searchUsername operation/method
 */
if ($search->searchUsername(new \RelatieApiV3\StructType\SearchUsernameRequest()) !== false) {
    print_r($search->getResult());
} else {
    print_r($search->getLastError());
}
/**
 * Sample call for searchSmartcode operation/method
 */
if ($search->searchSmartcode(new \RelatieApiV3\StructType\SearchSmartcodeRequest()) !== false) {
    print_r($search->getResult());
} else {
    print_r($search->getLastError());
}
/**
 * Samples for Generate ServiceType
 */
$generate = new \RelatieApiV3\ServiceType\Generate($options);
$generate->setSoapHeaderAuthentication(new \RelatieApiV3\StructType\Authentication());
/**
 * Sample call for generatePassword operation/method
 */
if ($generate->generatePassword(new \RelatieApiV3\StructType\GeneratePasswordRequest()) !== false) {
    print_r($generate->getResult());
} else {
    print_r($generate->getLastError());
}
