<?php

namespace RelatieApiV3\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for WebserviceOperatie StructType
 * Meta information extracted from the WSDL
 * - documentation: Beschikbare webservice operatie.
 * @subpackage Structs
 * @date 20200204
 * @package RelatieApiV3
 */
class WebserviceOperatie extends AbstractStructBase
{
    /**
     * The webservice
     * Meta information extracted from the WSDL
     * - documentation: De naam van de webservice api.
     * - base: xsd:string
     * - maxLength: 30
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $webservice;
    /**
     * The operatie
     * Meta information extracted from the WSDL
     * - documentation: De naam van de beschikbare operatie.
     * - base: xsd:string
     * - maxLength: 30
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $operatie;
    /**
     * Constructor method for WebserviceOperatie
     * @uses WebserviceOperatie::setWebservice()
     * @uses WebserviceOperatie::setOperatie()
     * @param string $webservice
     * @param string $operatie
     */
    public function __construct($webservice = null, $operatie = null)
    {
        $this
            ->setWebservice($webservice)
            ->setOperatie($operatie);
    }
    /**
     * Get webservice value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getWebservice()
    {
        return isset($this->webservice) ? $this->webservice : null;
    }
    /**
     * Set webservice value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $webservice
     * @return \RelatieApiV3\StructType\WebserviceOperatie
     */
    public function setWebservice($webservice = null)
    {
        // validation for constraint: string
        if (!is_null($webservice) && !is_string($webservice)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($webservice, true), gettype($webservice)), __LINE__);
        }
        // validation for constraint: maxLength(30)
        if (!is_null($webservice) && mb_strlen($webservice) > 30) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 30', mb_strlen($webservice)), __LINE__);
        }
        if (is_null($webservice) || (is_array($webservice) && empty($webservice))) {
            unset($this->webservice);
        } else {
            $this->webservice = $webservice;
        }
        return $this;
    }
    /**
     * Get operatie value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOperatie()
    {
        return isset($this->operatie) ? $this->operatie : null;
    }
    /**
     * Set operatie value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $operatie
     * @return \RelatieApiV3\StructType\WebserviceOperatie
     */
    public function setOperatie($operatie = null)
    {
        // validation for constraint: string
        if (!is_null($operatie) && !is_string($operatie)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($operatie, true), gettype($operatie)), __LINE__);
        }
        // validation for constraint: maxLength(30)
        if (!is_null($operatie) && mb_strlen($operatie) > 30) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 30', mb_strlen($operatie)), __LINE__);
        }
        if (is_null($operatie) || (is_array($operatie) && empty($operatie))) {
            unset($this->operatie);
        } else {
            $this->operatie = $operatie;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \RelatieApiV3\StructType\WebserviceOperatie
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
