<?php

namespace RelatieApiV3\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for updateEmailRequest StructType
 * Meta information extracted from the WSDL
 * - documentation: Bijwerken van het email adres bij een relatie.
 * @subpackage Structs
 * @date 20200204
 * @package RelatieApiV3
 */
class UpdateEmailRequest extends AbstractStructBase
{
    /**
     * The relatienummer
     * Meta information extracted from the WSDL
     * - documentation: Het relatienummer van de relatie waarvan het email adres bijgewerkt moet worden.
     * - base: xsd:integer
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * - totalDigits: 15
     * @var int
     */
    public $relatienummer;
    /**
     * The emailVeld
     * Meta information extracted from the WSDL
     * - documentation: {1,2,3,4} Geeft aan welk email veld moet worden gewijzigd.
     * - base: xsd:decimal
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * - totalDigits: 38
     * @var float
     */
    public $emailVeld;
    /**
     * The requestTag
     * Meta information extracted from the WSDL
     * - documentation: Vrij veld voor aanroepende partij. De inhoud van dit veld wordt altijd identiek teruggestuurd.
     * - base: xsd:string
     * - maxLength: 4000
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $requestTag;
    /**
     * The emailAdres
     * Meta information extracted from the WSDL
     * - documentation: Het te wijzigen email adres.
     * - base: xsd:string
     * - maxLength: 80
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $emailAdres;
    /**
     * Constructor method for updateEmailRequest
     * @uses UpdateEmailRequest::setRelatienummer()
     * @uses UpdateEmailRequest::setEmailVeld()
     * @uses UpdateEmailRequest::setRequestTag()
     * @uses UpdateEmailRequest::setEmailAdres()
     * @param int $relatienummer
     * @param float $emailVeld
     * @param string $requestTag
     * @param string $emailAdres
     */
    public function __construct($relatienummer = null, $emailVeld = null, $requestTag = null, $emailAdres = null)
    {
        $this
            ->setRelatienummer($relatienummer)
            ->setEmailVeld($emailVeld)
            ->setRequestTag($requestTag)
            ->setEmailAdres($emailAdres);
    }
    /**
     * Get relatienummer value
     * @return int
     */
    public function getRelatienummer()
    {
        return $this->relatienummer;
    }
    /**
     * Set relatienummer value
     * @param int $relatienummer
     * @return \RelatieApiV3\StructType\UpdateEmailRequest
     */
    public function setRelatienummer($relatienummer = null)
    {
        // validation for constraint: int
        if (!is_null($relatienummer) && !(is_int($relatienummer) || ctype_digit($relatienummer))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($relatienummer, true), gettype($relatienummer)), __LINE__);
        }
        // validation for constraint: totalDigits(15)
        if (!is_null($relatienummer) && mb_strlen(preg_replace('/(\D)/', '', $relatienummer)) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 15 digits, "%d" given', var_export($relatienummer, true), mb_strlen(preg_replace('/(\D)/', '', $relatienummer))), __LINE__);
        }
        $this->relatienummer = $relatienummer;
        return $this;
    }
    /**
     * Get emailVeld value
     * @return float
     */
    public function getEmailVeld()
    {
        return $this->emailVeld;
    }
    /**
     * Set emailVeld value
     * @param float $emailVeld
     * @return \RelatieApiV3\StructType\UpdateEmailRequest
     */
    public function setEmailVeld($emailVeld = null)
    {
        // validation for constraint: float
        if (!is_null($emailVeld) && !(is_float($emailVeld) || is_numeric($emailVeld))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($emailVeld, true), gettype($emailVeld)), __LINE__);
        }
        // validation for constraint: totalDigits(38)
        if (!is_null($emailVeld) && mb_strlen(preg_replace('/(\D)/', '', $emailVeld)) > 38) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 38 digits, "%d" given', var_export($emailVeld, true), mb_strlen(preg_replace('/(\D)/', '', $emailVeld))), __LINE__);
        }
        $this->emailVeld = $emailVeld;
        return $this;
    }
    /**
     * Get requestTag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRequestTag()
    {
        return isset($this->requestTag) ? $this->requestTag : null;
    }
    /**
     * Set requestTag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $requestTag
     * @return \RelatieApiV3\StructType\UpdateEmailRequest
     */
    public function setRequestTag($requestTag = null)
    {
        // validation for constraint: string
        if (!is_null($requestTag) && !is_string($requestTag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($requestTag, true), gettype($requestTag)), __LINE__);
        }
        // validation for constraint: maxLength(4000)
        if (!is_null($requestTag) && mb_strlen($requestTag) > 4000) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 4000', mb_strlen($requestTag)), __LINE__);
        }
        if (is_null($requestTag) || (is_array($requestTag) && empty($requestTag))) {
            unset($this->requestTag);
        } else {
            $this->requestTag = $requestTag;
        }
        return $this;
    }
    /**
     * Get emailAdres value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEmailAdres()
    {
        return isset($this->emailAdres) ? $this->emailAdres : null;
    }
    /**
     * Set emailAdres value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $emailAdres
     * @return \RelatieApiV3\StructType\UpdateEmailRequest
     */
    public function setEmailAdres($emailAdres = null)
    {
        // validation for constraint: string
        if (!is_null($emailAdres) && !is_string($emailAdres)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($emailAdres, true), gettype($emailAdres)), __LINE__);
        }
        // validation for constraint: maxLength(80)
        if (!is_null($emailAdres) && mb_strlen($emailAdres) > 80) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 80', mb_strlen($emailAdres)), __LINE__);
        }
        if (is_null($emailAdres) || (is_array($emailAdres) && empty($emailAdres))) {
            unset($this->emailAdres);
        } else {
            $this->emailAdres = $emailAdres;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \RelatieApiV3\StructType\UpdateEmailRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
