<?php

namespace RelatieApiV3\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for updateContPersoonNrContactRequest StructType
 * Meta information extracted from the WSDL
 * - documentation: Koppelt een bestaand contactpersoon als contactpersoon van een ander bestaand bedrijf.
 * @subpackage Structs
 * @date 20200204
 * @package RelatieApiV3
 */
class UpdateContPersoonNrContactRequest extends AbstractStructBase
{
    /**
     * The relatienummerBestaandBedrijf
     * Meta information extracted from the WSDL
     * - documentation: Het relatienummer van het huidige bedrijf van de contactpersoon.
     * - base: xsd:integer
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * - totalDigits: 15
     * @var int
     */
    public $relatienummerBestaandBedrijf;
    /**
     * The relatienummerPersoon
     * Meta information extracted from the WSDL
     * - documentation: Het relatienummer van de contactpersoon.
     * - base: xsd:integer
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * - totalDigits: 15
     * @var int
     */
    public $relatienummerPersoon;
    /**
     * The relatienummerNieuwBedrijf
     * Meta information extracted from the WSDL
     * - documentation: Het relatienummer van het nieuwe bedrijf van de contactpersoon.
     * - base: xsd:integer
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * - totalDigits: 15
     * @var int
     */
    public $relatienummerNieuwBedrijf;
    /**
     * The requestTag
     * Meta information extracted from the WSDL
     * - documentation: Vrij veld voor aanroepende partij. De inhoud van dit veld wordt altijd identiek teruggestuurd.
     * - base: xsd:string
     * - maxLength: 4000
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $requestTag;
    /**
     * The leegPersoonBezoekadres
     * Meta information extracted from the WSDL
     * - documentation: false (Default)= Laat het bezoekadres bij de persoon ongewijzigd<BR>true=Leeg het bezoekadres bij de prive persoon, zodat het bezoekadres bedrijf gebruikt wordt.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $leegPersoonBezoekadres;
    /**
     * The leegPersoonCorradres
     * Meta information extracted from the WSDL
     * - documentation: false (Default)= Laat het correspondentie adres bij de persoon ongewijzigd<BR>true=Leeg het correspondentie adres bij de prive persoon, zodat het correspondentieadres bedrijf gebruikt wordt.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $leegPersoonCorradres;
    /**
     * The leegPersoonPriveadres
     * Meta information extracted from the WSDL
     * - documentation: false (Default)= Laat het priveadres bij de persoon ongewijzigd<BR>true=Leeg het prive adres bij de prive persoon, zodat het prive adres bedrijf gebruikt wordt.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $leegPersoonPriveadres;
    /**
     * Constructor method for updateContPersoonNrContactRequest
     * @uses UpdateContPersoonNrContactRequest::setRelatienummerBestaandBedrijf()
     * @uses UpdateContPersoonNrContactRequest::setRelatienummerPersoon()
     * @uses UpdateContPersoonNrContactRequest::setRelatienummerNieuwBedrijf()
     * @uses UpdateContPersoonNrContactRequest::setRequestTag()
     * @uses UpdateContPersoonNrContactRequest::setLeegPersoonBezoekadres()
     * @uses UpdateContPersoonNrContactRequest::setLeegPersoonCorradres()
     * @uses UpdateContPersoonNrContactRequest::setLeegPersoonPriveadres()
     * @param int $relatienummerBestaandBedrijf
     * @param int $relatienummerPersoon
     * @param int $relatienummerNieuwBedrijf
     * @param string $requestTag
     * @param bool $leegPersoonBezoekadres
     * @param bool $leegPersoonCorradres
     * @param bool $leegPersoonPriveadres
     */
    public function __construct($relatienummerBestaandBedrijf = null, $relatienummerPersoon = null, $relatienummerNieuwBedrijf = null, $requestTag = null, $leegPersoonBezoekadres = null, $leegPersoonCorradres = null, $leegPersoonPriveadres = null)
    {
        $this
            ->setRelatienummerBestaandBedrijf($relatienummerBestaandBedrijf)
            ->setRelatienummerPersoon($relatienummerPersoon)
            ->setRelatienummerNieuwBedrijf($relatienummerNieuwBedrijf)
            ->setRequestTag($requestTag)
            ->setLeegPersoonBezoekadres($leegPersoonBezoekadres)
            ->setLeegPersoonCorradres($leegPersoonCorradres)
            ->setLeegPersoonPriveadres($leegPersoonPriveadres);
    }
    /**
     * Get relatienummerBestaandBedrijf value
     * @return int
     */
    public function getRelatienummerBestaandBedrijf()
    {
        return $this->relatienummerBestaandBedrijf;
    }
    /**
     * Set relatienummerBestaandBedrijf value
     * @param int $relatienummerBestaandBedrijf
     * @return \RelatieApiV3\StructType\UpdateContPersoonNrContactRequest
     */
    public function setRelatienummerBestaandBedrijf($relatienummerBestaandBedrijf = null)
    {
        // validation for constraint: int
        if (!is_null($relatienummerBestaandBedrijf) && !(is_int($relatienummerBestaandBedrijf) || ctype_digit($relatienummerBestaandBedrijf))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($relatienummerBestaandBedrijf, true), gettype($relatienummerBestaandBedrijf)), __LINE__);
        }
        // validation for constraint: totalDigits(15)
        if (!is_null($relatienummerBestaandBedrijf) && mb_strlen(preg_replace('/(\D)/', '', $relatienummerBestaandBedrijf)) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 15 digits, "%d" given', var_export($relatienummerBestaandBedrijf, true), mb_strlen(preg_replace('/(\D)/', '', $relatienummerBestaandBedrijf))), __LINE__);
        }
        $this->relatienummerBestaandBedrijf = $relatienummerBestaandBedrijf;
        return $this;
    }
    /**
     * Get relatienummerPersoon value
     * @return int
     */
    public function getRelatienummerPersoon()
    {
        return $this->relatienummerPersoon;
    }
    /**
     * Set relatienummerPersoon value
     * @param int $relatienummerPersoon
     * @return \RelatieApiV3\StructType\UpdateContPersoonNrContactRequest
     */
    public function setRelatienummerPersoon($relatienummerPersoon = null)
    {
        // validation for constraint: int
        if (!is_null($relatienummerPersoon) && !(is_int($relatienummerPersoon) || ctype_digit($relatienummerPersoon))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($relatienummerPersoon, true), gettype($relatienummerPersoon)), __LINE__);
        }
        // validation for constraint: totalDigits(15)
        if (!is_null($relatienummerPersoon) && mb_strlen(preg_replace('/(\D)/', '', $relatienummerPersoon)) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 15 digits, "%d" given', var_export($relatienummerPersoon, true), mb_strlen(preg_replace('/(\D)/', '', $relatienummerPersoon))), __LINE__);
        }
        $this->relatienummerPersoon = $relatienummerPersoon;
        return $this;
    }
    /**
     * Get relatienummerNieuwBedrijf value
     * @return int
     */
    public function getRelatienummerNieuwBedrijf()
    {
        return $this->relatienummerNieuwBedrijf;
    }
    /**
     * Set relatienummerNieuwBedrijf value
     * @param int $relatienummerNieuwBedrijf
     * @return \RelatieApiV3\StructType\UpdateContPersoonNrContactRequest
     */
    public function setRelatienummerNieuwBedrijf($relatienummerNieuwBedrijf = null)
    {
        // validation for constraint: int
        if (!is_null($relatienummerNieuwBedrijf) && !(is_int($relatienummerNieuwBedrijf) || ctype_digit($relatienummerNieuwBedrijf))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($relatienummerNieuwBedrijf, true), gettype($relatienummerNieuwBedrijf)), __LINE__);
        }
        // validation for constraint: totalDigits(15)
        if (!is_null($relatienummerNieuwBedrijf) && mb_strlen(preg_replace('/(\D)/', '', $relatienummerNieuwBedrijf)) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 15 digits, "%d" given', var_export($relatienummerNieuwBedrijf, true), mb_strlen(preg_replace('/(\D)/', '', $relatienummerNieuwBedrijf))), __LINE__);
        }
        $this->relatienummerNieuwBedrijf = $relatienummerNieuwBedrijf;
        return $this;
    }
    /**
     * Get requestTag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRequestTag()
    {
        return isset($this->requestTag) ? $this->requestTag : null;
    }
    /**
     * Set requestTag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $requestTag
     * @return \RelatieApiV3\StructType\UpdateContPersoonNrContactRequest
     */
    public function setRequestTag($requestTag = null)
    {
        // validation for constraint: string
        if (!is_null($requestTag) && !is_string($requestTag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($requestTag, true), gettype($requestTag)), __LINE__);
        }
        // validation for constraint: maxLength(4000)
        if (!is_null($requestTag) && mb_strlen($requestTag) > 4000) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 4000', mb_strlen($requestTag)), __LINE__);
        }
        if (is_null($requestTag) || (is_array($requestTag) && empty($requestTag))) {
            unset($this->requestTag);
        } else {
            $this->requestTag = $requestTag;
        }
        return $this;
    }
    /**
     * Get leegPersoonBezoekadres value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getLeegPersoonBezoekadres()
    {
        return isset($this->leegPersoonBezoekadres) ? $this->leegPersoonBezoekadres : null;
    }
    /**
     * Set leegPersoonBezoekadres value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $leegPersoonBezoekadres
     * @return \RelatieApiV3\StructType\UpdateContPersoonNrContactRequest
     */
    public function setLeegPersoonBezoekadres($leegPersoonBezoekadres = null)
    {
        // validation for constraint: boolean
        if (!is_null($leegPersoonBezoekadres) && !is_bool($leegPersoonBezoekadres)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($leegPersoonBezoekadres, true), gettype($leegPersoonBezoekadres)), __LINE__);
        }
        if (is_null($leegPersoonBezoekadres) || (is_array($leegPersoonBezoekadres) && empty($leegPersoonBezoekadres))) {
            unset($this->leegPersoonBezoekadres);
        } else {
            $this->leegPersoonBezoekadres = $leegPersoonBezoekadres;
        }
        return $this;
    }
    /**
     * Get leegPersoonCorradres value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getLeegPersoonCorradres()
    {
        return isset($this->leegPersoonCorradres) ? $this->leegPersoonCorradres : null;
    }
    /**
     * Set leegPersoonCorradres value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $leegPersoonCorradres
     * @return \RelatieApiV3\StructType\UpdateContPersoonNrContactRequest
     */
    public function setLeegPersoonCorradres($leegPersoonCorradres = null)
    {
        // validation for constraint: boolean
        if (!is_null($leegPersoonCorradres) && !is_bool($leegPersoonCorradres)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($leegPersoonCorradres, true), gettype($leegPersoonCorradres)), __LINE__);
        }
        if (is_null($leegPersoonCorradres) || (is_array($leegPersoonCorradres) && empty($leegPersoonCorradres))) {
            unset($this->leegPersoonCorradres);
        } else {
            $this->leegPersoonCorradres = $leegPersoonCorradres;
        }
        return $this;
    }
    /**
     * Get leegPersoonPriveadres value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getLeegPersoonPriveadres()
    {
        return isset($this->leegPersoonPriveadres) ? $this->leegPersoonPriveadres : null;
    }
    /**
     * Set leegPersoonPriveadres value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $leegPersoonPriveadres
     * @return \RelatieApiV3\StructType\UpdateContPersoonNrContactRequest
     */
    public function setLeegPersoonPriveadres($leegPersoonPriveadres = null)
    {
        // validation for constraint: boolean
        if (!is_null($leegPersoonPriveadres) && !is_bool($leegPersoonPriveadres)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($leegPersoonPriveadres, true), gettype($leegPersoonPriveadres)), __LINE__);
        }
        if (is_null($leegPersoonPriveadres) || (is_array($leegPersoonPriveadres) && empty($leegPersoonPriveadres))) {
            unset($this->leegPersoonPriveadres);
        } else {
            $this->leegPersoonPriveadres = $leegPersoonPriveadres;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \RelatieApiV3\StructType\UpdateContPersoonNrContactRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
