<?php

namespace RelatieApiV3\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for searchEmailRequest StructType
 * Meta information extracted from the WSDL
 * - documentation: Zoekt relatienummers bij het opgegeven e-mail adres
 * @subpackage Structs
 * @date 20200204
 * @package RelatieApiV3
 */
class SearchEmailRequest extends AbstractStructBase
{
    /**
     * The email
     * Meta information extracted from the WSDL
     * - documentation: Het te controleren e-mail adres
     * - base: xsd:string
     * - maxLength: 80
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $email;
    /**
     * The requestTag
     * Meta information extracted from the WSDL
     * - documentation: Vrij veld voor aanroepende partij. De inhoud van dit veld wordt altijd identiek teruggestuurd.
     * - base: xsd:string
     * - maxLength: 4000
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $requestTag;
    /**
     * The zoekEmailVeld
     * Meta information extracted from the WSDL
     * - documentation: Geef aan welk e-mail veld er doorzocht moet worden. <br /> 0 = Zowel e-mail veld 1, 2, 3 als 4 <br /> 1 = E-mail veld 1 (default) <br /> 2 = E-mail veld 2 <br /> 3 = E-mail veld 1 of E-mail veld 2 als E-mail veld 1 leeg is <br /> 4 =
     * E-mail veld 2 of E-mail veld 1 als E-mail veld 2 leeg is <br /> 5 = E-mail veld 3 <br /> 6 = E-mail veld 4 <br />
     * - base: xsd:decimal
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 38
     * @var float
     */
    public $zoekEmailVeld;
    /**
     * Constructor method for searchEmailRequest
     * @uses SearchEmailRequest::setEmail()
     * @uses SearchEmailRequest::setRequestTag()
     * @uses SearchEmailRequest::setZoekEmailVeld()
     * @param string $email
     * @param string $requestTag
     * @param float $zoekEmailVeld
     */
    public function __construct($email = null, $requestTag = null, $zoekEmailVeld = null)
    {
        $this
            ->setEmail($email)
            ->setRequestTag($requestTag)
            ->setZoekEmailVeld($zoekEmailVeld);
    }
    /**
     * Get email value
     * @return string
     */
    public function getEmail()
    {
        return $this->email;
    }
    /**
     * Set email value
     * @param string $email
     * @return \RelatieApiV3\StructType\SearchEmailRequest
     */
    public function setEmail($email = null)
    {
        // validation for constraint: string
        if (!is_null($email) && !is_string($email)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($email, true), gettype($email)), __LINE__);
        }
        // validation for constraint: maxLength(80)
        if (!is_null($email) && mb_strlen($email) > 80) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 80', mb_strlen($email)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($email) && mb_strlen($email) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($email)), __LINE__);
        }
        $this->email = $email;
        return $this;
    }
    /**
     * Get requestTag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRequestTag()
    {
        return isset($this->requestTag) ? $this->requestTag : null;
    }
    /**
     * Set requestTag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $requestTag
     * @return \RelatieApiV3\StructType\SearchEmailRequest
     */
    public function setRequestTag($requestTag = null)
    {
        // validation for constraint: string
        if (!is_null($requestTag) && !is_string($requestTag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($requestTag, true), gettype($requestTag)), __LINE__);
        }
        // validation for constraint: maxLength(4000)
        if (!is_null($requestTag) && mb_strlen($requestTag) > 4000) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 4000', mb_strlen($requestTag)), __LINE__);
        }
        if (is_null($requestTag) || (is_array($requestTag) && empty($requestTag))) {
            unset($this->requestTag);
        } else {
            $this->requestTag = $requestTag;
        }
        return $this;
    }
    /**
     * Get zoekEmailVeld value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getZoekEmailVeld()
    {
        return isset($this->zoekEmailVeld) ? $this->zoekEmailVeld : null;
    }
    /**
     * Set zoekEmailVeld value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $zoekEmailVeld
     * @return \RelatieApiV3\StructType\SearchEmailRequest
     */
    public function setZoekEmailVeld($zoekEmailVeld = null)
    {
        // validation for constraint: float
        if (!is_null($zoekEmailVeld) && !(is_float($zoekEmailVeld) || is_numeric($zoekEmailVeld))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($zoekEmailVeld, true), gettype($zoekEmailVeld)), __LINE__);
        }
        // validation for constraint: totalDigits(38)
        if (!is_null($zoekEmailVeld) && mb_strlen(preg_replace('/(\D)/', '', $zoekEmailVeld)) > 38) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 38 digits, "%d" given', var_export($zoekEmailVeld, true), mb_strlen(preg_replace('/(\D)/', '', $zoekEmailVeld))), __LINE__);
        }
        if (is_null($zoekEmailVeld) || (is_array($zoekEmailVeld) && empty($zoekEmailVeld))) {
            unset($this->zoekEmailVeld);
        } else {
            $this->zoekEmailVeld = $zoekEmailVeld;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \RelatieApiV3\StructType\SearchEmailRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
