<?php

namespace RelatieApiV3\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RelatieBiccodetableV3 StructType
 * Meta information extracted from the WSDL
 * - documentation: Lijst met aan de relatie gekoppeld bic codes
 * @subpackage Structs
 * @date 20200204
 * @package RelatieApiV3
 */
class RelatieBiccodetableV3 extends AbstractStructBase
{
    /**
     * The relatieBiccode
     * Meta information extracted from the WSDL
     * - documentation: Bic codes
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: false
     * @var \RelatieApiV3\StructType\RelatieBiccodeRecV3[]
     */
    public $relatieBiccode;
    /**
     * Constructor method for RelatieBiccodetableV3
     * @uses RelatieBiccodetableV3::setRelatieBiccode()
     * @param \RelatieApiV3\StructType\RelatieBiccodeRecV3[] $relatieBiccode
     */
    public function __construct(array $relatieBiccode = array())
    {
        $this
            ->setRelatieBiccode($relatieBiccode);
    }
    /**
     * Get relatieBiccode value
     * @return \RelatieApiV3\StructType\RelatieBiccodeRecV3[]|null
     */
    public function getRelatieBiccode()
    {
        return $this->relatieBiccode;
    }
    /**
     * This method is responsible for validating the values passed to the setRelatieBiccode method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRelatieBiccode method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRelatieBiccodeForArrayConstraintsFromSetRelatieBiccode(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $relatieBiccodetableV3RelatieBiccodeItem) {
            // validation for constraint: itemType
            if (!$relatieBiccodetableV3RelatieBiccodeItem instanceof \RelatieApiV3\StructType\RelatieBiccodeRecV3) {
                $invalidValues[] = is_object($relatieBiccodetableV3RelatieBiccodeItem) ? get_class($relatieBiccodetableV3RelatieBiccodeItem) : sprintf('%s(%s)', gettype($relatieBiccodetableV3RelatieBiccodeItem), var_export($relatieBiccodetableV3RelatieBiccodeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The relatieBiccode property can only contain items of type \RelatieApiV3\StructType\RelatieBiccodeRecV3, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set relatieBiccode value
     * @throws \InvalidArgumentException
     * @param \RelatieApiV3\StructType\RelatieBiccodeRecV3[] $relatieBiccode
     * @return \RelatieApiV3\StructType\RelatieBiccodetableV3
     */
    public function setRelatieBiccode(array $relatieBiccode = array())
    {
        // validation for constraint: array
        if ('' !== ($relatieBiccodeArrayErrorMessage = self::validateRelatieBiccodeForArrayConstraintsFromSetRelatieBiccode($relatieBiccode))) {
            throw new \InvalidArgumentException($relatieBiccodeArrayErrorMessage, __LINE__);
        }
        $this->relatieBiccode = $relatieBiccode;
        return $this;
    }
    /**
     * Add item to relatieBiccode value
     * @throws \InvalidArgumentException
     * @param \RelatieApiV3\StructType\RelatieBiccodeRecV3 $item
     * @return \RelatieApiV3\StructType\RelatieBiccodetableV3
     */
    public function addToRelatieBiccode(\RelatieApiV3\StructType\RelatieBiccodeRecV3 $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \RelatieApiV3\StructType\RelatieBiccodeRecV3) {
            throw new \InvalidArgumentException(sprintf('The relatieBiccode property can only contain items of type \RelatieApiV3\StructType\RelatieBiccodeRecV3, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->relatieBiccode[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \RelatieApiV3\StructType\RelatieBiccodetableV3
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
