<?php

namespace RelatieApiV3\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RelatieBiccodeRecV3 StructType
 * Meta information extracted from the WSDL
 * - documentation: Relatie Bic code
 * @subpackage Structs
 * @date 20200204
 * @package RelatieApiV3
 */
class RelatieBiccodeRecV3 extends AbstractStructBase
{
    /**
     * The relatieBicSleutel
     * Meta information extracted from the WSDL
     * - documentation: Unieke sleutel van de koppeling van de Bic code van de bic categorie aan de relatie
     * - base: xsd:integer
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * - totalDigits: 15
     * @var int
     */
    public $relatieBicSleutel;
    /**
     * The biccode
     * Meta information extracted from the WSDL
     * - documentation: De gekoppelde bic code
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \RelatieApiV3\StructType\BiccodeRecV3
     */
    public $biccode;
    /**
     * Constructor method for RelatieBiccodeRecV3
     * @uses RelatieBiccodeRecV3::setRelatieBicSleutel()
     * @uses RelatieBiccodeRecV3::setBiccode()
     * @param int $relatieBicSleutel
     * @param \RelatieApiV3\StructType\BiccodeRecV3 $biccode
     */
    public function __construct($relatieBicSleutel = null, \RelatieApiV3\StructType\BiccodeRecV3 $biccode = null)
    {
        $this
            ->setRelatieBicSleutel($relatieBicSleutel)
            ->setBiccode($biccode);
    }
    /**
     * Get relatieBicSleutel value
     * @return int
     */
    public function getRelatieBicSleutel()
    {
        return $this->relatieBicSleutel;
    }
    /**
     * Set relatieBicSleutel value
     * @param int $relatieBicSleutel
     * @return \RelatieApiV3\StructType\RelatieBiccodeRecV3
     */
    public function setRelatieBicSleutel($relatieBicSleutel = null)
    {
        // validation for constraint: int
        if (!is_null($relatieBicSleutel) && !(is_int($relatieBicSleutel) || ctype_digit($relatieBicSleutel))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($relatieBicSleutel, true), gettype($relatieBicSleutel)), __LINE__);
        }
        // validation for constraint: totalDigits(15)
        if (!is_null($relatieBicSleutel) && mb_strlen(preg_replace('/(\D)/', '', $relatieBicSleutel)) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 15 digits, "%d" given', var_export($relatieBicSleutel, true), mb_strlen(preg_replace('/(\D)/', '', $relatieBicSleutel))), __LINE__);
        }
        $this->relatieBicSleutel = $relatieBicSleutel;
        return $this;
    }
    /**
     * Get biccode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \RelatieApiV3\StructType\BiccodeRecV3|null
     */
    public function getBiccode()
    {
        return isset($this->biccode) ? $this->biccode : null;
    }
    /**
     * Set biccode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \RelatieApiV3\StructType\BiccodeRecV3 $biccode
     * @return \RelatieApiV3\StructType\RelatieBiccodeRecV3
     */
    public function setBiccode(\RelatieApiV3\StructType\BiccodeRecV3 $biccode = null)
    {
        if (is_null($biccode) || (is_array($biccode) && empty($biccode))) {
            unset($this->biccode);
        } else {
            $this->biccode = $biccode;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \RelatieApiV3\StructType\RelatieBiccodeRecV3
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
