<?php

namespace RelatieApiV3\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for KenmerkgroepRecV3 StructType
 * Meta information extracted from the WSDL
 * - documentation: Kenmerkgroepen
 * @subpackage Structs
 * @date 20200204
 * @package RelatieApiV3
 */
class KenmerkgroepRecV3 extends AbstractStructBase
{
    /**
     * The kenmerkgroepCode
     * Meta information extracted from the WSDL
     * - documentation: Code van de kenmerkgroep
     * - base: xsd:string
     * - maxLength: 12
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $kenmerkgroepCode;
    /**
     * The kenmerkgroepOmschrijving
     * Meta information extracted from the WSDL
     * - documentation: Omschrijving van het kenmerkgroep
     * - base: xsd:string
     * - maxLength: 120
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $kenmerkgroepOmschrijving;
    /**
     * The actief
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $actief;
    /**
     * The hoofdgroepCode
     * Meta information extracted from the WSDL
     * - documentation: Code van de kenmerkhoofdgroep, indien de kenmerkgroep in een hoofdgroep is ingedeeld
     * - base: xsd:string
     * - maxLength: 12
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $hoofdgroepCode;
    /**
     * The hoofdgroepOmschrijving
     * Meta information extracted from the WSDL
     * - documentation: Omschrijving van het kenmerkhoofdgroep, indien de kenmerkgroep in een hoofdgroep is ingedeeld
     * - base: xsd:string
     * - maxLength: 12
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $hoofdgroepOmschrijving;
    /**
     * The kenmerken
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \RelatieApiV3\StructType\KenmerktableV3
     */
    public $kenmerken;
    /**
     * Constructor method for KenmerkgroepRecV3
     * @uses KenmerkgroepRecV3::setKenmerkgroepCode()
     * @uses KenmerkgroepRecV3::setKenmerkgroepOmschrijving()
     * @uses KenmerkgroepRecV3::setActief()
     * @uses KenmerkgroepRecV3::setHoofdgroepCode()
     * @uses KenmerkgroepRecV3::setHoofdgroepOmschrijving()
     * @uses KenmerkgroepRecV3::setKenmerken()
     * @param string $kenmerkgroepCode
     * @param string $kenmerkgroepOmschrijving
     * @param bool $actief
     * @param string $hoofdgroepCode
     * @param string $hoofdgroepOmschrijving
     * @param \RelatieApiV3\StructType\KenmerktableV3 $kenmerken
     */
    public function __construct($kenmerkgroepCode = null, $kenmerkgroepOmschrijving = null, $actief = null, $hoofdgroepCode = null, $hoofdgroepOmschrijving = null, \RelatieApiV3\StructType\KenmerktableV3 $kenmerken = null)
    {
        $this
            ->setKenmerkgroepCode($kenmerkgroepCode)
            ->setKenmerkgroepOmschrijving($kenmerkgroepOmschrijving)
            ->setActief($actief)
            ->setHoofdgroepCode($hoofdgroepCode)
            ->setHoofdgroepOmschrijving($hoofdgroepOmschrijving)
            ->setKenmerken($kenmerken);
    }
    /**
     * Get kenmerkgroepCode value
     * @return string
     */
    public function getKenmerkgroepCode()
    {
        return $this->kenmerkgroepCode;
    }
    /**
     * Set kenmerkgroepCode value
     * @param string $kenmerkgroepCode
     * @return \RelatieApiV3\StructType\KenmerkgroepRecV3
     */
    public function setKenmerkgroepCode($kenmerkgroepCode = null)
    {
        // validation for constraint: string
        if (!is_null($kenmerkgroepCode) && !is_string($kenmerkgroepCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($kenmerkgroepCode, true), gettype($kenmerkgroepCode)), __LINE__);
        }
        // validation for constraint: maxLength(12)
        if (!is_null($kenmerkgroepCode) && mb_strlen($kenmerkgroepCode) > 12) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 12', mb_strlen($kenmerkgroepCode)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($kenmerkgroepCode) && mb_strlen($kenmerkgroepCode) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($kenmerkgroepCode)), __LINE__);
        }
        $this->kenmerkgroepCode = $kenmerkgroepCode;
        return $this;
    }
    /**
     * Get kenmerkgroepOmschrijving value
     * @return string
     */
    public function getKenmerkgroepOmschrijving()
    {
        return $this->kenmerkgroepOmschrijving;
    }
    /**
     * Set kenmerkgroepOmschrijving value
     * @param string $kenmerkgroepOmschrijving
     * @return \RelatieApiV3\StructType\KenmerkgroepRecV3
     */
    public function setKenmerkgroepOmschrijving($kenmerkgroepOmschrijving = null)
    {
        // validation for constraint: string
        if (!is_null($kenmerkgroepOmschrijving) && !is_string($kenmerkgroepOmschrijving)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($kenmerkgroepOmschrijving, true), gettype($kenmerkgroepOmschrijving)), __LINE__);
        }
        // validation for constraint: maxLength(120)
        if (!is_null($kenmerkgroepOmschrijving) && mb_strlen($kenmerkgroepOmschrijving) > 120) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 120', mb_strlen($kenmerkgroepOmschrijving)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($kenmerkgroepOmschrijving) && mb_strlen($kenmerkgroepOmschrijving) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($kenmerkgroepOmschrijving)), __LINE__);
        }
        $this->kenmerkgroepOmschrijving = $kenmerkgroepOmschrijving;
        return $this;
    }
    /**
     * Get actief value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getActief()
    {
        return isset($this->actief) ? $this->actief : null;
    }
    /**
     * Set actief value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $actief
     * @return \RelatieApiV3\StructType\KenmerkgroepRecV3
     */
    public function setActief($actief = null)
    {
        // validation for constraint: boolean
        if (!is_null($actief) && !is_bool($actief)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($actief, true), gettype($actief)), __LINE__);
        }
        if (is_null($actief) || (is_array($actief) && empty($actief))) {
            unset($this->actief);
        } else {
            $this->actief = $actief;
        }
        return $this;
    }
    /**
     * Get hoofdgroepCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getHoofdgroepCode()
    {
        return isset($this->hoofdgroepCode) ? $this->hoofdgroepCode : null;
    }
    /**
     * Set hoofdgroepCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $hoofdgroepCode
     * @return \RelatieApiV3\StructType\KenmerkgroepRecV3
     */
    public function setHoofdgroepCode($hoofdgroepCode = null)
    {
        // validation for constraint: string
        if (!is_null($hoofdgroepCode) && !is_string($hoofdgroepCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hoofdgroepCode, true), gettype($hoofdgroepCode)), __LINE__);
        }
        // validation for constraint: maxLength(12)
        if (!is_null($hoofdgroepCode) && mb_strlen($hoofdgroepCode) > 12) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 12', mb_strlen($hoofdgroepCode)), __LINE__);
        }
        if (is_null($hoofdgroepCode) || (is_array($hoofdgroepCode) && empty($hoofdgroepCode))) {
            unset($this->hoofdgroepCode);
        } else {
            $this->hoofdgroepCode = $hoofdgroepCode;
        }
        return $this;
    }
    /**
     * Get hoofdgroepOmschrijving value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getHoofdgroepOmschrijving()
    {
        return isset($this->hoofdgroepOmschrijving) ? $this->hoofdgroepOmschrijving : null;
    }
    /**
     * Set hoofdgroepOmschrijving value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $hoofdgroepOmschrijving
     * @return \RelatieApiV3\StructType\KenmerkgroepRecV3
     */
    public function setHoofdgroepOmschrijving($hoofdgroepOmschrijving = null)
    {
        // validation for constraint: string
        if (!is_null($hoofdgroepOmschrijving) && !is_string($hoofdgroepOmschrijving)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hoofdgroepOmschrijving, true), gettype($hoofdgroepOmschrijving)), __LINE__);
        }
        // validation for constraint: maxLength(12)
        if (!is_null($hoofdgroepOmschrijving) && mb_strlen($hoofdgroepOmschrijving) > 12) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 12', mb_strlen($hoofdgroepOmschrijving)), __LINE__);
        }
        if (is_null($hoofdgroepOmschrijving) || (is_array($hoofdgroepOmschrijving) && empty($hoofdgroepOmschrijving))) {
            unset($this->hoofdgroepOmschrijving);
        } else {
            $this->hoofdgroepOmschrijving = $hoofdgroepOmschrijving;
        }
        return $this;
    }
    /**
     * Get kenmerken value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \RelatieApiV3\StructType\KenmerktableV3|null
     */
    public function getKenmerken()
    {
        return isset($this->kenmerken) ? $this->kenmerken : null;
    }
    /**
     * Set kenmerken value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \RelatieApiV3\StructType\KenmerktableV3 $kenmerken
     * @return \RelatieApiV3\StructType\KenmerkgroepRecV3
     */
    public function setKenmerken(\RelatieApiV3\StructType\KenmerktableV3 $kenmerken = null)
    {
        if (is_null($kenmerken) || (is_array($kenmerken) && empty($kenmerken))) {
            unset($this->kenmerken);
        } else {
            $this->kenmerken = $kenmerken;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \RelatieApiV3\StructType\KenmerkgroepRecV3
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
