<?php

namespace RelatieApiV3\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for getProvinciecodesRequest StructType
 * Meta information extracted from the WSDL
 * - documentation: Ophalen van beschikbare provinciecodes die bij een relatie als provincie opgenomen kunnen worden
 * @subpackage Structs
 * @date 20200204
 * @package RelatieApiV3
 */
class GetProvinciecodesRequest extends AbstractStructBase
{
    /**
     * The requestTag
     * Meta information extracted from the WSDL
     * - documentation: Vrij veld voor aanroepende partij. De inhoud van dit veld wordt altijd identiek teruggestuurd.
     * - base: xsd:string
     * - maxLength: 4000
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $requestTag;
    /**
     * The landCode
     * Meta information extracted from the WSDL
     * - documentation: Land code indien alleen provincies van 1 land gezocht worden
     * - base: xsd:string
     * - maxLength: 3
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $landCode;
    /**
     * Constructor method for getProvinciecodesRequest
     * @uses GetProvinciecodesRequest::setRequestTag()
     * @uses GetProvinciecodesRequest::setLandCode()
     * @param string $requestTag
     * @param string $landCode
     */
    public function __construct($requestTag = null, $landCode = null)
    {
        $this
            ->setRequestTag($requestTag)
            ->setLandCode($landCode);
    }
    /**
     * Get requestTag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRequestTag()
    {
        return isset($this->requestTag) ? $this->requestTag : null;
    }
    /**
     * Set requestTag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $requestTag
     * @return \RelatieApiV3\StructType\GetProvinciecodesRequest
     */
    public function setRequestTag($requestTag = null)
    {
        // validation for constraint: string
        if (!is_null($requestTag) && !is_string($requestTag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($requestTag, true), gettype($requestTag)), __LINE__);
        }
        // validation for constraint: maxLength(4000)
        if (!is_null($requestTag) && mb_strlen($requestTag) > 4000) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 4000', mb_strlen($requestTag)), __LINE__);
        }
        if (is_null($requestTag) || (is_array($requestTag) && empty($requestTag))) {
            unset($this->requestTag);
        } else {
            $this->requestTag = $requestTag;
        }
        return $this;
    }
    /**
     * Get landCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLandCode()
    {
        return isset($this->landCode) ? $this->landCode : null;
    }
    /**
     * Set landCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $landCode
     * @return \RelatieApiV3\StructType\GetProvinciecodesRequest
     */
    public function setLandCode($landCode = null)
    {
        // validation for constraint: string
        if (!is_null($landCode) && !is_string($landCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($landCode, true), gettype($landCode)), __LINE__);
        }
        // validation for constraint: maxLength(3)
        if (!is_null($landCode) && mb_strlen($landCode) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 3', mb_strlen($landCode)), __LINE__);
        }
        if (is_null($landCode) || (is_array($landCode) && empty($landCode))) {
            unset($this->landCode);
        } else {
            $this->landCode = $landCode;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \RelatieApiV3\StructType\GetProvinciecodesRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
