<?php

namespace RelatieApiV3\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for getKenmerkenRequest StructType
 * Meta information extracted from the WSDL
 * - documentation: Geeft de beschikbare kenmerk-stamgegevens terug
 * @subpackage Structs
 * @date 20200204
 * @package RelatieApiV3
 */
class GetKenmerkenRequest extends AbstractStructBase
{
    /**
     * The requestTag
     * Meta information extracted from the WSDL
     * - documentation: Vrij veld voor aanroepende partij. De inhoud van dit veld wordt altijd identiek teruggestuurd.
     * - base: xsd:string
     * - maxLength: 4000
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $requestTag;
    /**
     * The kenmerkgroepCode
     * Meta information extracted from the WSDL
     * - documentation: Indien meegegeven, worden alleen de kenmerken van deze kenmerkgroep teruggegeven
     * - base: xsd:string
     * - maxLength: 12
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $kenmerkgroepCode;
    /**
     * The inclusiefInactief
     * Meta information extracted from the WSDL
     * - documentation: Indien true, worden ook inactieve kenmerken en kenmerkgroepen teruggegeven
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $inclusiefInactief;
    /**
     * Constructor method for getKenmerkenRequest
     * @uses GetKenmerkenRequest::setRequestTag()
     * @uses GetKenmerkenRequest::setKenmerkgroepCode()
     * @uses GetKenmerkenRequest::setInclusiefInactief()
     * @param string $requestTag
     * @param string $kenmerkgroepCode
     * @param bool $inclusiefInactief
     */
    public function __construct($requestTag = null, $kenmerkgroepCode = null, $inclusiefInactief = null)
    {
        $this
            ->setRequestTag($requestTag)
            ->setKenmerkgroepCode($kenmerkgroepCode)
            ->setInclusiefInactief($inclusiefInactief);
    }
    /**
     * Get requestTag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRequestTag()
    {
        return isset($this->requestTag) ? $this->requestTag : null;
    }
    /**
     * Set requestTag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $requestTag
     * @return \RelatieApiV3\StructType\GetKenmerkenRequest
     */
    public function setRequestTag($requestTag = null)
    {
        // validation for constraint: string
        if (!is_null($requestTag) && !is_string($requestTag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($requestTag, true), gettype($requestTag)), __LINE__);
        }
        // validation for constraint: maxLength(4000)
        if (!is_null($requestTag) && mb_strlen($requestTag) > 4000) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 4000', mb_strlen($requestTag)), __LINE__);
        }
        if (is_null($requestTag) || (is_array($requestTag) && empty($requestTag))) {
            unset($this->requestTag);
        } else {
            $this->requestTag = $requestTag;
        }
        return $this;
    }
    /**
     * Get kenmerkgroepCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getKenmerkgroepCode()
    {
        return isset($this->kenmerkgroepCode) ? $this->kenmerkgroepCode : null;
    }
    /**
     * Set kenmerkgroepCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $kenmerkgroepCode
     * @return \RelatieApiV3\StructType\GetKenmerkenRequest
     */
    public function setKenmerkgroepCode($kenmerkgroepCode = null)
    {
        // validation for constraint: string
        if (!is_null($kenmerkgroepCode) && !is_string($kenmerkgroepCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($kenmerkgroepCode, true), gettype($kenmerkgroepCode)), __LINE__);
        }
        // validation for constraint: maxLength(12)
        if (!is_null($kenmerkgroepCode) && mb_strlen($kenmerkgroepCode) > 12) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 12', mb_strlen($kenmerkgroepCode)), __LINE__);
        }
        if (is_null($kenmerkgroepCode) || (is_array($kenmerkgroepCode) && empty($kenmerkgroepCode))) {
            unset($this->kenmerkgroepCode);
        } else {
            $this->kenmerkgroepCode = $kenmerkgroepCode;
        }
        return $this;
    }
    /**
     * Get inclusiefInactief value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getInclusiefInactief()
    {
        return isset($this->inclusiefInactief) ? $this->inclusiefInactief : null;
    }
    /**
     * Set inclusiefInactief value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $inclusiefInactief
     * @return \RelatieApiV3\StructType\GetKenmerkenRequest
     */
    public function setInclusiefInactief($inclusiefInactief = null)
    {
        // validation for constraint: boolean
        if (!is_null($inclusiefInactief) && !is_bool($inclusiefInactief)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($inclusiefInactief, true), gettype($inclusiefInactief)), __LINE__);
        }
        if (is_null($inclusiefInactief) || (is_array($inclusiefInactief) && empty($inclusiefInactief))) {
            unset($this->inclusiefInactief);
        } else {
            $this->inclusiefInactief = $inclusiefInactief;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \RelatieApiV3\StructType\GetKenmerkenRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
