<?php

namespace RelatieApiV3\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for getBedrijfRequest StructType
 * Meta information extracted from the WSDL
 * - documentation: Ophalen van de gegevens van een bedrijf
 * @subpackage Structs
 * @date 20200204
 * @package RelatieApiV3
 */
class GetBedrijfRequest extends AbstractStructBase
{
    /**
     * The relatienummer
     * Meta information extracted from the WSDL
     * - documentation: Het relatienummer van de relatie waarvan de gegevens opgehaald worden
     * - base: xsd:integer
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * - totalDigits: 15
     * @var int
     */
    public $relatienummer;
    /**
     * The requestTag
     * Meta information extracted from the WSDL
     * - documentation: Vrij veld voor aanroepende partij. De inhoud van dit veld wordt altijd identiek teruggestuurd.
     * - base: xsd:string
     * - maxLength: 4000
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $requestTag;
    /**
     * The includeContactpersonen
     * Meta information extracted from the WSDL
     * - documentation: Indicatie true= Detailgegevens contactpersonen retourneren, false= Geen detailgegevens contactpersonen retourneren
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $includeContactpersonen;
    /**
     * The includeAfdelingen
     * Meta information extracted from the WSDL
     * - documentation: Indicatie true= Detailgegevens afdelingen retourneren, false= Geen detailgegevens afdelingen retourneren
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $includeAfdelingen;
    /**
     * The includeFuncties
     * Meta information extracted from the WSDL
     * - documentation: Indicatie true= Gekoppelde functies retourneren, false= Geen gekoppelde functies retourneren
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $includeFuncties;
    /**
     * The includeBiccodes
     * Meta information extracted from the WSDL
     * - documentation: Indicatie true= Gekoppelde biccodes retourneren, false= Geen gekoppelde biccodes retourneren
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $includeBiccodes;
    /**
     * Constructor method for getBedrijfRequest
     * @uses GetBedrijfRequest::setRelatienummer()
     * @uses GetBedrijfRequest::setRequestTag()
     * @uses GetBedrijfRequest::setIncludeContactpersonen()
     * @uses GetBedrijfRequest::setIncludeAfdelingen()
     * @uses GetBedrijfRequest::setIncludeFuncties()
     * @uses GetBedrijfRequest::setIncludeBiccodes()
     * @param int $relatienummer
     * @param string $requestTag
     * @param bool $includeContactpersonen
     * @param bool $includeAfdelingen
     * @param bool $includeFuncties
     * @param bool $includeBiccodes
     */
    public function __construct($relatienummer = null, $requestTag = null, $includeContactpersonen = null, $includeAfdelingen = null, $includeFuncties = null, $includeBiccodes = null)
    {
        $this
            ->setRelatienummer($relatienummer)
            ->setRequestTag($requestTag)
            ->setIncludeContactpersonen($includeContactpersonen)
            ->setIncludeAfdelingen($includeAfdelingen)
            ->setIncludeFuncties($includeFuncties)
            ->setIncludeBiccodes($includeBiccodes);
    }
    /**
     * Get relatienummer value
     * @return int
     */
    public function getRelatienummer()
    {
        return $this->relatienummer;
    }
    /**
     * Set relatienummer value
     * @param int $relatienummer
     * @return \RelatieApiV3\StructType\GetBedrijfRequest
     */
    public function setRelatienummer($relatienummer = null)
    {
        // validation for constraint: int
        if (!is_null($relatienummer) && !(is_int($relatienummer) || ctype_digit($relatienummer))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($relatienummer, true), gettype($relatienummer)), __LINE__);
        }
        // validation for constraint: totalDigits(15)
        if (!is_null($relatienummer) && mb_strlen(preg_replace('/(\D)/', '', $relatienummer)) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 15 digits, "%d" given', var_export($relatienummer, true), mb_strlen(preg_replace('/(\D)/', '', $relatienummer))), __LINE__);
        }
        $this->relatienummer = $relatienummer;
        return $this;
    }
    /**
     * Get requestTag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRequestTag()
    {
        return isset($this->requestTag) ? $this->requestTag : null;
    }
    /**
     * Set requestTag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $requestTag
     * @return \RelatieApiV3\StructType\GetBedrijfRequest
     */
    public function setRequestTag($requestTag = null)
    {
        // validation for constraint: string
        if (!is_null($requestTag) && !is_string($requestTag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($requestTag, true), gettype($requestTag)), __LINE__);
        }
        // validation for constraint: maxLength(4000)
        if (!is_null($requestTag) && mb_strlen($requestTag) > 4000) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 4000', mb_strlen($requestTag)), __LINE__);
        }
        if (is_null($requestTag) || (is_array($requestTag) && empty($requestTag))) {
            unset($this->requestTag);
        } else {
            $this->requestTag = $requestTag;
        }
        return $this;
    }
    /**
     * Get includeContactpersonen value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIncludeContactpersonen()
    {
        return isset($this->includeContactpersonen) ? $this->includeContactpersonen : null;
    }
    /**
     * Set includeContactpersonen value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $includeContactpersonen
     * @return \RelatieApiV3\StructType\GetBedrijfRequest
     */
    public function setIncludeContactpersonen($includeContactpersonen = null)
    {
        // validation for constraint: boolean
        if (!is_null($includeContactpersonen) && !is_bool($includeContactpersonen)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($includeContactpersonen, true), gettype($includeContactpersonen)), __LINE__);
        }
        if (is_null($includeContactpersonen) || (is_array($includeContactpersonen) && empty($includeContactpersonen))) {
            unset($this->includeContactpersonen);
        } else {
            $this->includeContactpersonen = $includeContactpersonen;
        }
        return $this;
    }
    /**
     * Get includeAfdelingen value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIncludeAfdelingen()
    {
        return isset($this->includeAfdelingen) ? $this->includeAfdelingen : null;
    }
    /**
     * Set includeAfdelingen value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $includeAfdelingen
     * @return \RelatieApiV3\StructType\GetBedrijfRequest
     */
    public function setIncludeAfdelingen($includeAfdelingen = null)
    {
        // validation for constraint: boolean
        if (!is_null($includeAfdelingen) && !is_bool($includeAfdelingen)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($includeAfdelingen, true), gettype($includeAfdelingen)), __LINE__);
        }
        if (is_null($includeAfdelingen) || (is_array($includeAfdelingen) && empty($includeAfdelingen))) {
            unset($this->includeAfdelingen);
        } else {
            $this->includeAfdelingen = $includeAfdelingen;
        }
        return $this;
    }
    /**
     * Get includeFuncties value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIncludeFuncties()
    {
        return isset($this->includeFuncties) ? $this->includeFuncties : null;
    }
    /**
     * Set includeFuncties value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $includeFuncties
     * @return \RelatieApiV3\StructType\GetBedrijfRequest
     */
    public function setIncludeFuncties($includeFuncties = null)
    {
        // validation for constraint: boolean
        if (!is_null($includeFuncties) && !is_bool($includeFuncties)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($includeFuncties, true), gettype($includeFuncties)), __LINE__);
        }
        if (is_null($includeFuncties) || (is_array($includeFuncties) && empty($includeFuncties))) {
            unset($this->includeFuncties);
        } else {
            $this->includeFuncties = $includeFuncties;
        }
        return $this;
    }
    /**
     * Get includeBiccodes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIncludeBiccodes()
    {
        return isset($this->includeBiccodes) ? $this->includeBiccodes : null;
    }
    /**
     * Set includeBiccodes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $includeBiccodes
     * @return \RelatieApiV3\StructType\GetBedrijfRequest
     */
    public function setIncludeBiccodes($includeBiccodes = null)
    {
        // validation for constraint: boolean
        if (!is_null($includeBiccodes) && !is_bool($includeBiccodes)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($includeBiccodes, true), gettype($includeBiccodes)), __LINE__);
        }
        if (is_null($includeBiccodes) || (is_array($includeBiccodes) && empty($includeBiccodes))) {
            unset($this->includeBiccodes);
        } else {
            $this->includeBiccodes = $includeBiccodes;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \RelatieApiV3\StructType\GetBedrijfRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
