<?php

namespace RelatieApiV3\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BiccodetableV3 StructType
 * Meta information extracted from the WSDL
 * - documentation: Lijst met bic codes
 * @subpackage Structs
 * @date 20200204
 * @package RelatieApiV3
 */
class BiccodetableV3 extends AbstractStructBase
{
    /**
     * The biccode
     * Meta information extracted from the WSDL
     * - documentation: Bic codes
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: false
     * @var \RelatieApiV3\StructType\BiccodeRecV3[]
     */
    public $biccode;
    /**
     * Constructor method for BiccodetableV3
     * @uses BiccodetableV3::setBiccode()
     * @param \RelatieApiV3\StructType\BiccodeRecV3[] $biccode
     */
    public function __construct(array $biccode = array())
    {
        $this
            ->setBiccode($biccode);
    }
    /**
     * Get biccode value
     * @return \RelatieApiV3\StructType\BiccodeRecV3[]|null
     */
    public function getBiccode()
    {
        return $this->biccode;
    }
    /**
     * This method is responsible for validating the values passed to the setBiccode method
     * This method is willingly generated in order to preserve the one-line inline validation within the setBiccode method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateBiccodeForArrayConstraintsFromSetBiccode(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $biccodetableV3BiccodeItem) {
            // validation for constraint: itemType
            if (!$biccodetableV3BiccodeItem instanceof \RelatieApiV3\StructType\BiccodeRecV3) {
                $invalidValues[] = is_object($biccodetableV3BiccodeItem) ? get_class($biccodetableV3BiccodeItem) : sprintf('%s(%s)', gettype($biccodetableV3BiccodeItem), var_export($biccodetableV3BiccodeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The biccode property can only contain items of type \RelatieApiV3\StructType\BiccodeRecV3, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set biccode value
     * @throws \InvalidArgumentException
     * @param \RelatieApiV3\StructType\BiccodeRecV3[] $biccode
     * @return \RelatieApiV3\StructType\BiccodetableV3
     */
    public function setBiccode(array $biccode = array())
    {
        // validation for constraint: array
        if ('' !== ($biccodeArrayErrorMessage = self::validateBiccodeForArrayConstraintsFromSetBiccode($biccode))) {
            throw new \InvalidArgumentException($biccodeArrayErrorMessage, __LINE__);
        }
        $this->biccode = $biccode;
        return $this;
    }
    /**
     * Add item to biccode value
     * @throws \InvalidArgumentException
     * @param \RelatieApiV3\StructType\BiccodeRecV3 $item
     * @return \RelatieApiV3\StructType\BiccodetableV3
     */
    public function addToBiccode(\RelatieApiV3\StructType\BiccodeRecV3 $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \RelatieApiV3\StructType\BiccodeRecV3) {
            throw new \InvalidArgumentException(sprintf('The biccode property can only contain items of type \RelatieApiV3\StructType\BiccodeRecV3, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->biccode[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \RelatieApiV3\StructType\BiccodetableV3
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
