<?php

namespace RelatieApiV3\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BedrijfinfoRecV3 StructType
 * Meta information extracted from the WSDL
 * - documentation: Bedrijfsgegevens
 * @subpackage Structs
 * @date 20200204
 * @package RelatieApiV3
 */
class BedrijfinfoRecV3 extends AbstractStructBase
{
    /**
     * The bedrijf
     * Meta information extracted from the WSDL
     * - documentation: De bedrijfsgegevens
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \RelatieApiV3\StructType\BedrijfRecV3
     */
    public $bedrijf;
    /**
     * The contactpersonen
     * Meta information extracted from the WSDL
     * - documentation: Een lijst met de contactpersonen binnen het bedrijf
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \RelatieApiV3\StructType\ContactpersoontableV3
     */
    public $contactpersonen;
    /**
     * The afdelingen
     * Meta information extracted from the WSDL
     * - documentation: Een lijst met de afdelingen binnen het bedrijf
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \RelatieApiV3\StructType\AfdelingtableV3
     */
    public $afdelingen;
    /**
     * The leververbod
     * Meta information extracted from the WSDL
     * - documentation: De relatie heeft een leververbod
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $leververbod;
    /**
     * The relatienummerDebiteur
     * Meta information extracted from the WSDL
     * - documentation: Het relatienummer van de vaste debiteur van het bedrijf
     * - base: xsd:integer
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 15
     * @var int
     */
    public $relatienummerDebiteur;
    /**
     * The functies
     * Meta information extracted from the WSDL
     * - documentation: De bij het bedrijf aanwezige functies
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \RelatieApiV3\StructType\RelatieFunctietableV3
     */
    public $functies;
    /**
     * The biccodes
     * Meta information extracted from the WSDL
     * - documentation: De bij het bedrijf aanwezige biccodes
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \RelatieApiV3\StructType\RelatieBiccodetableV3
     */
    public $biccodes;
    /**
     * Constructor method for BedrijfinfoRecV3
     * @uses BedrijfinfoRecV3::setBedrijf()
     * @uses BedrijfinfoRecV3::setContactpersonen()
     * @uses BedrijfinfoRecV3::setAfdelingen()
     * @uses BedrijfinfoRecV3::setLeververbod()
     * @uses BedrijfinfoRecV3::setRelatienummerDebiteur()
     * @uses BedrijfinfoRecV3::setFuncties()
     * @uses BedrijfinfoRecV3::setBiccodes()
     * @param \RelatieApiV3\StructType\BedrijfRecV3 $bedrijf
     * @param \RelatieApiV3\StructType\ContactpersoontableV3 $contactpersonen
     * @param \RelatieApiV3\StructType\AfdelingtableV3 $afdelingen
     * @param bool $leververbod
     * @param int $relatienummerDebiteur
     * @param \RelatieApiV3\StructType\RelatieFunctietableV3 $functies
     * @param \RelatieApiV3\StructType\RelatieBiccodetableV3 $biccodes
     */
    public function __construct(\RelatieApiV3\StructType\BedrijfRecV3 $bedrijf = null, \RelatieApiV3\StructType\ContactpersoontableV3 $contactpersonen = null, \RelatieApiV3\StructType\AfdelingtableV3 $afdelingen = null, $leververbod = null, $relatienummerDebiteur = null, \RelatieApiV3\StructType\RelatieFunctietableV3 $functies = null, \RelatieApiV3\StructType\RelatieBiccodetableV3 $biccodes = null)
    {
        $this
            ->setBedrijf($bedrijf)
            ->setContactpersonen($contactpersonen)
            ->setAfdelingen($afdelingen)
            ->setLeververbod($leververbod)
            ->setRelatienummerDebiteur($relatienummerDebiteur)
            ->setFuncties($functies)
            ->setBiccodes($biccodes);
    }
    /**
     * Get bedrijf value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \RelatieApiV3\StructType\BedrijfRecV3|null
     */
    public function getBedrijf()
    {
        return isset($this->bedrijf) ? $this->bedrijf : null;
    }
    /**
     * Set bedrijf value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \RelatieApiV3\StructType\BedrijfRecV3 $bedrijf
     * @return \RelatieApiV3\StructType\BedrijfinfoRecV3
     */
    public function setBedrijf(\RelatieApiV3\StructType\BedrijfRecV3 $bedrijf = null)
    {
        if (is_null($bedrijf) || (is_array($bedrijf) && empty($bedrijf))) {
            unset($this->bedrijf);
        } else {
            $this->bedrijf = $bedrijf;
        }
        return $this;
    }
    /**
     * Get contactpersonen value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \RelatieApiV3\StructType\ContactpersoontableV3|null
     */
    public function getContactpersonen()
    {
        return isset($this->contactpersonen) ? $this->contactpersonen : null;
    }
    /**
     * Set contactpersonen value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \RelatieApiV3\StructType\ContactpersoontableV3 $contactpersonen
     * @return \RelatieApiV3\StructType\BedrijfinfoRecV3
     */
    public function setContactpersonen(\RelatieApiV3\StructType\ContactpersoontableV3 $contactpersonen = null)
    {
        if (is_null($contactpersonen) || (is_array($contactpersonen) && empty($contactpersonen))) {
            unset($this->contactpersonen);
        } else {
            $this->contactpersonen = $contactpersonen;
        }
        return $this;
    }
    /**
     * Get afdelingen value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \RelatieApiV3\StructType\AfdelingtableV3|null
     */
    public function getAfdelingen()
    {
        return isset($this->afdelingen) ? $this->afdelingen : null;
    }
    /**
     * Set afdelingen value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \RelatieApiV3\StructType\AfdelingtableV3 $afdelingen
     * @return \RelatieApiV3\StructType\BedrijfinfoRecV3
     */
    public function setAfdelingen(\RelatieApiV3\StructType\AfdelingtableV3 $afdelingen = null)
    {
        if (is_null($afdelingen) || (is_array($afdelingen) && empty($afdelingen))) {
            unset($this->afdelingen);
        } else {
            $this->afdelingen = $afdelingen;
        }
        return $this;
    }
    /**
     * Get leververbod value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getLeververbod()
    {
        return isset($this->leververbod) ? $this->leververbod : null;
    }
    /**
     * Set leververbod value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $leververbod
     * @return \RelatieApiV3\StructType\BedrijfinfoRecV3
     */
    public function setLeververbod($leververbod = null)
    {
        // validation for constraint: boolean
        if (!is_null($leververbod) && !is_bool($leververbod)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($leververbod, true), gettype($leververbod)), __LINE__);
        }
        if (is_null($leververbod) || (is_array($leververbod) && empty($leververbod))) {
            unset($this->leververbod);
        } else {
            $this->leververbod = $leververbod;
        }
        return $this;
    }
    /**
     * Get relatienummerDebiteur value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getRelatienummerDebiteur()
    {
        return isset($this->relatienummerDebiteur) ? $this->relatienummerDebiteur : null;
    }
    /**
     * Set relatienummerDebiteur value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $relatienummerDebiteur
     * @return \RelatieApiV3\StructType\BedrijfinfoRecV3
     */
    public function setRelatienummerDebiteur($relatienummerDebiteur = null)
    {
        // validation for constraint: int
        if (!is_null($relatienummerDebiteur) && !(is_int($relatienummerDebiteur) || ctype_digit($relatienummerDebiteur))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($relatienummerDebiteur, true), gettype($relatienummerDebiteur)), __LINE__);
        }
        // validation for constraint: totalDigits(15)
        if (!is_null($relatienummerDebiteur) && mb_strlen(preg_replace('/(\D)/', '', $relatienummerDebiteur)) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 15 digits, "%d" given', var_export($relatienummerDebiteur, true), mb_strlen(preg_replace('/(\D)/', '', $relatienummerDebiteur))), __LINE__);
        }
        if (is_null($relatienummerDebiteur) || (is_array($relatienummerDebiteur) && empty($relatienummerDebiteur))) {
            unset($this->relatienummerDebiteur);
        } else {
            $this->relatienummerDebiteur = $relatienummerDebiteur;
        }
        return $this;
    }
    /**
     * Get functies value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \RelatieApiV3\StructType\RelatieFunctietableV3|null
     */
    public function getFuncties()
    {
        return isset($this->functies) ? $this->functies : null;
    }
    /**
     * Set functies value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \RelatieApiV3\StructType\RelatieFunctietableV3 $functies
     * @return \RelatieApiV3\StructType\BedrijfinfoRecV3
     */
    public function setFuncties(\RelatieApiV3\StructType\RelatieFunctietableV3 $functies = null)
    {
        if (is_null($functies) || (is_array($functies) && empty($functies))) {
            unset($this->functies);
        } else {
            $this->functies = $functies;
        }
        return $this;
    }
    /**
     * Get biccodes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \RelatieApiV3\StructType\RelatieBiccodetableV3|null
     */
    public function getBiccodes()
    {
        return isset($this->biccodes) ? $this->biccodes : null;
    }
    /**
     * Set biccodes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \RelatieApiV3\StructType\RelatieBiccodetableV3 $biccodes
     * @return \RelatieApiV3\StructType\BedrijfinfoRecV3
     */
    public function setBiccodes(\RelatieApiV3\StructType\RelatieBiccodetableV3 $biccodes = null)
    {
        if (is_null($biccodes) || (is_array($biccodes) && empty($biccodes))) {
            unset($this->biccodes);
        } else {
            $this->biccodes = $biccodes;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \RelatieApiV3\StructType\BedrijfinfoRecV3
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
