<?php

namespace RelatieApiV3\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AfdelingRecV3 StructType
 * Meta information extracted from the WSDL
 * - documentation: Afdeling
 * @subpackage Structs
 * @date 20200204
 * @package RelatieApiV3
 */
class AfdelingRecV3 extends AbstractStructBase
{
    /**
     * The relatienummer
     * Meta information extracted from the WSDL
     * - documentation: Het unieke nummer voor de afdeling
     * - base: xsd:integer
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 15
     * @var int
     */
    public $relatienummer;
    /**
     * The afdeling
     * Meta information extracted from the WSDL
     * - documentation: De afdelingsnaam
     * - base: xsd:string
     * - maxLength: 120
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $afdeling;
    /**
     * The email
     * Meta information extracted from the WSDL
     * - documentation: E-mail adres 1
     * - base: xsd:string
     * - maxLength: 80
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $email;
    /**
     * The email2
     * Meta information extracted from the WSDL
     * - documentation: E-mail adres 2
     * - base: xsd:string
     * - maxLength: 80
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $email2;
    /**
     * The email3
     * Meta information extracted from the WSDL
     * - documentation: E-mail adres 3
     * - base: xsd:string
     * - maxLength: 80
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $email3;
    /**
     * The email4
     * Meta information extracted from the WSDL
     * - documentation: E-mail adres 4
     * - base: xsd:string
     * - maxLength: 80
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $email4;
    /**
     * The telefoonnummer
     * Meta information extracted from the WSDL
     * - documentation: Telefoonnummer van de afdeling
     * - base: xsd:string
     * - maxLength: 80
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $telefoonnummer;
    /**
     * The faxnummer
     * Meta information extracted from the WSDL
     * - documentation: Faxnummer
     * - base: xsd:string
     * - maxLength: 80
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $faxnummer;
    /**
     * The betaling
     * Meta information extracted from the WSDL
     * - documentation: De betaalgegevens
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \RelatieApiV3\StructType\BetaalRecV3
     */
    public $betaling;
    /**
     * The kortinggroepCode
     * Meta information extracted from the WSDL
     * - documentation: De kortinggroep code
     * - base: xsd:string
     * - maxLength: 12
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $kortinggroepCode;
    /**
     * The adresBezoek
     * Meta information extracted from the WSDL
     * - documentation: Het bezoekadres van de afdeling
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \RelatieApiV3\StructType\AdresRecV3
     */
    public $adresBezoek;
    /**
     * The adresCorrespondentie
     * Meta information extracted from the WSDL
     * - documentation: Het correspondentieadres van de afdeling
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \RelatieApiV3\StructType\AdresRecV3
     */
    public $adresCorrespondentie;
    /**
     * The adresPrive
     * Meta information extracted from the WSDL
     * - documentation: Het priveadres van de afdeling
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \RelatieApiV3\StructType\AdresRecV3
     */
    public $adresPrive;
    /**
     * The landCode
     * Meta information extracted from the WSDL
     * - documentation: Iso-landcode van het land waar de afdeling zich bevindt
     * - base: xsd:string
     * - maxLength: 3
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $landCode;
    /**
     * The provincieCode
     * Meta information extracted from the WSDL
     * - documentation: Provinciecode van de provincie waar de afdeling zich bevindt
     * - base: xsd:string
     * - maxLength: 20
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $provincieCode;
    /**
     * The onvolledig
     * Meta information extracted from the WSDL
     * - documentation: De gegevens van de relatie zijn onvolledig en moeten later aangevuld worden
     * - base: xsd:integer
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 3
     * @var int
     */
    public $onvolledig;
    /**
     * The vrijeVelden
     * Meta information extracted from the WSDL
     * - documentation: De vrije velden van de relatie
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \RelatieApiV3\StructType\VrijeVeldenRecV3
     */
    public $vrijeVelden;
    /**
     * The taalCode
     * Meta information extracted from the WSDL
     * - documentation: De taalcode van het bedrijf
     * - base: xsd:string
     * - maxLength: 12
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $taalCode;
    /**
     * The valutaCode
     * Meta information extracted from the WSDL
     * - documentation: Valuta waarin de relatie betaalt. Indien leeg, wordt de valuta bepaald adhv de inrichting in Zeno obv landen
     * - base: xsd:string
     * - maxLength: 3
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $valutaCode;
    /**
     * Constructor method for AfdelingRecV3
     * @uses AfdelingRecV3::setRelatienummer()
     * @uses AfdelingRecV3::setAfdeling()
     * @uses AfdelingRecV3::setEmail()
     * @uses AfdelingRecV3::setEmail2()
     * @uses AfdelingRecV3::setEmail3()
     * @uses AfdelingRecV3::setEmail4()
     * @uses AfdelingRecV3::setTelefoonnummer()
     * @uses AfdelingRecV3::setFaxnummer()
     * @uses AfdelingRecV3::setBetaling()
     * @uses AfdelingRecV3::setKortinggroepCode()
     * @uses AfdelingRecV3::setAdresBezoek()
     * @uses AfdelingRecV3::setAdresCorrespondentie()
     * @uses AfdelingRecV3::setAdresPrive()
     * @uses AfdelingRecV3::setLandCode()
     * @uses AfdelingRecV3::setProvincieCode()
     * @uses AfdelingRecV3::setOnvolledig()
     * @uses AfdelingRecV3::setVrijeVelden()
     * @uses AfdelingRecV3::setTaalCode()
     * @uses AfdelingRecV3::setValutaCode()
     * @param int $relatienummer
     * @param string $afdeling
     * @param string $email
     * @param string $email2
     * @param string $email3
     * @param string $email4
     * @param string $telefoonnummer
     * @param string $faxnummer
     * @param \RelatieApiV3\StructType\BetaalRecV3 $betaling
     * @param string $kortinggroepCode
     * @param \RelatieApiV3\StructType\AdresRecV3 $adresBezoek
     * @param \RelatieApiV3\StructType\AdresRecV3 $adresCorrespondentie
     * @param \RelatieApiV3\StructType\AdresRecV3 $adresPrive
     * @param string $landCode
     * @param string $provincieCode
     * @param int $onvolledig
     * @param \RelatieApiV3\StructType\VrijeVeldenRecV3 $vrijeVelden
     * @param string $taalCode
     * @param string $valutaCode
     */
    public function __construct($relatienummer = null, $afdeling = null, $email = null, $email2 = null, $email3 = null, $email4 = null, $telefoonnummer = null, $faxnummer = null, \RelatieApiV3\StructType\BetaalRecV3 $betaling = null, $kortinggroepCode = null, \RelatieApiV3\StructType\AdresRecV3 $adresBezoek = null, \RelatieApiV3\StructType\AdresRecV3 $adresCorrespondentie = null, \RelatieApiV3\StructType\AdresRecV3 $adresPrive = null, $landCode = null, $provincieCode = null, $onvolledig = null, \RelatieApiV3\StructType\VrijeVeldenRecV3 $vrijeVelden = null, $taalCode = null, $valutaCode = null)
    {
        $this
            ->setRelatienummer($relatienummer)
            ->setAfdeling($afdeling)
            ->setEmail($email)
            ->setEmail2($email2)
            ->setEmail3($email3)
            ->setEmail4($email4)
            ->setTelefoonnummer($telefoonnummer)
            ->setFaxnummer($faxnummer)
            ->setBetaling($betaling)
            ->setKortinggroepCode($kortinggroepCode)
            ->setAdresBezoek($adresBezoek)
            ->setAdresCorrespondentie($adresCorrespondentie)
            ->setAdresPrive($adresPrive)
            ->setLandCode($landCode)
            ->setProvincieCode($provincieCode)
            ->setOnvolledig($onvolledig)
            ->setVrijeVelden($vrijeVelden)
            ->setTaalCode($taalCode)
            ->setValutaCode($valutaCode);
    }
    /**
     * Get relatienummer value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getRelatienummer()
    {
        return isset($this->relatienummer) ? $this->relatienummer : null;
    }
    /**
     * Set relatienummer value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $relatienummer
     * @return \RelatieApiV3\StructType\AfdelingRecV3
     */
    public function setRelatienummer($relatienummer = null)
    {
        // validation for constraint: int
        if (!is_null($relatienummer) && !(is_int($relatienummer) || ctype_digit($relatienummer))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($relatienummer, true), gettype($relatienummer)), __LINE__);
        }
        // validation for constraint: totalDigits(15)
        if (!is_null($relatienummer) && mb_strlen(preg_replace('/(\D)/', '', $relatienummer)) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 15 digits, "%d" given', var_export($relatienummer, true), mb_strlen(preg_replace('/(\D)/', '', $relatienummer))), __LINE__);
        }
        if (is_null($relatienummer) || (is_array($relatienummer) && empty($relatienummer))) {
            unset($this->relatienummer);
        } else {
            $this->relatienummer = $relatienummer;
        }
        return $this;
    }
    /**
     * Get afdeling value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAfdeling()
    {
        return isset($this->afdeling) ? $this->afdeling : null;
    }
    /**
     * Set afdeling value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $afdeling
     * @return \RelatieApiV3\StructType\AfdelingRecV3
     */
    public function setAfdeling($afdeling = null)
    {
        // validation for constraint: string
        if (!is_null($afdeling) && !is_string($afdeling)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($afdeling, true), gettype($afdeling)), __LINE__);
        }
        // validation for constraint: maxLength(120)
        if (!is_null($afdeling) && mb_strlen($afdeling) > 120) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 120', mb_strlen($afdeling)), __LINE__);
        }
        if (is_null($afdeling) || (is_array($afdeling) && empty($afdeling))) {
            unset($this->afdeling);
        } else {
            $this->afdeling = $afdeling;
        }
        return $this;
    }
    /**
     * Get email value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEmail()
    {
        return isset($this->email) ? $this->email : null;
    }
    /**
     * Set email value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $email
     * @return \RelatieApiV3\StructType\AfdelingRecV3
     */
    public function setEmail($email = null)
    {
        // validation for constraint: string
        if (!is_null($email) && !is_string($email)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($email, true), gettype($email)), __LINE__);
        }
        // validation for constraint: maxLength(80)
        if (!is_null($email) && mb_strlen($email) > 80) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 80', mb_strlen($email)), __LINE__);
        }
        if (is_null($email) || (is_array($email) && empty($email))) {
            unset($this->email);
        } else {
            $this->email = $email;
        }
        return $this;
    }
    /**
     * Get email2 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEmail2()
    {
        return isset($this->email2) ? $this->email2 : null;
    }
    /**
     * Set email2 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $email2
     * @return \RelatieApiV3\StructType\AfdelingRecV3
     */
    public function setEmail2($email2 = null)
    {
        // validation for constraint: string
        if (!is_null($email2) && !is_string($email2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($email2, true), gettype($email2)), __LINE__);
        }
        // validation for constraint: maxLength(80)
        if (!is_null($email2) && mb_strlen($email2) > 80) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 80', mb_strlen($email2)), __LINE__);
        }
        if (is_null($email2) || (is_array($email2) && empty($email2))) {
            unset($this->email2);
        } else {
            $this->email2 = $email2;
        }
        return $this;
    }
    /**
     * Get email3 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEmail3()
    {
        return isset($this->email3) ? $this->email3 : null;
    }
    /**
     * Set email3 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $email3
     * @return \RelatieApiV3\StructType\AfdelingRecV3
     */
    public function setEmail3($email3 = null)
    {
        // validation for constraint: string
        if (!is_null($email3) && !is_string($email3)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($email3, true), gettype($email3)), __LINE__);
        }
        // validation for constraint: maxLength(80)
        if (!is_null($email3) && mb_strlen($email3) > 80) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 80', mb_strlen($email3)), __LINE__);
        }
        if (is_null($email3) || (is_array($email3) && empty($email3))) {
            unset($this->email3);
        } else {
            $this->email3 = $email3;
        }
        return $this;
    }
    /**
     * Get email4 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEmail4()
    {
        return isset($this->email4) ? $this->email4 : null;
    }
    /**
     * Set email4 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $email4
     * @return \RelatieApiV3\StructType\AfdelingRecV3
     */
    public function setEmail4($email4 = null)
    {
        // validation for constraint: string
        if (!is_null($email4) && !is_string($email4)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($email4, true), gettype($email4)), __LINE__);
        }
        // validation for constraint: maxLength(80)
        if (!is_null($email4) && mb_strlen($email4) > 80) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 80', mb_strlen($email4)), __LINE__);
        }
        if (is_null($email4) || (is_array($email4) && empty($email4))) {
            unset($this->email4);
        } else {
            $this->email4 = $email4;
        }
        return $this;
    }
    /**
     * Get telefoonnummer value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTelefoonnummer()
    {
        return isset($this->telefoonnummer) ? $this->telefoonnummer : null;
    }
    /**
     * Set telefoonnummer value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $telefoonnummer
     * @return \RelatieApiV3\StructType\AfdelingRecV3
     */
    public function setTelefoonnummer($telefoonnummer = null)
    {
        // validation for constraint: string
        if (!is_null($telefoonnummer) && !is_string($telefoonnummer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($telefoonnummer, true), gettype($telefoonnummer)), __LINE__);
        }
        // validation for constraint: maxLength(80)
        if (!is_null($telefoonnummer) && mb_strlen($telefoonnummer) > 80) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 80', mb_strlen($telefoonnummer)), __LINE__);
        }
        if (is_null($telefoonnummer) || (is_array($telefoonnummer) && empty($telefoonnummer))) {
            unset($this->telefoonnummer);
        } else {
            $this->telefoonnummer = $telefoonnummer;
        }
        return $this;
    }
    /**
     * Get faxnummer value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFaxnummer()
    {
        return isset($this->faxnummer) ? $this->faxnummer : null;
    }
    /**
     * Set faxnummer value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $faxnummer
     * @return \RelatieApiV3\StructType\AfdelingRecV3
     */
    public function setFaxnummer($faxnummer = null)
    {
        // validation for constraint: string
        if (!is_null($faxnummer) && !is_string($faxnummer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($faxnummer, true), gettype($faxnummer)), __LINE__);
        }
        // validation for constraint: maxLength(80)
        if (!is_null($faxnummer) && mb_strlen($faxnummer) > 80) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 80', mb_strlen($faxnummer)), __LINE__);
        }
        if (is_null($faxnummer) || (is_array($faxnummer) && empty($faxnummer))) {
            unset($this->faxnummer);
        } else {
            $this->faxnummer = $faxnummer;
        }
        return $this;
    }
    /**
     * Get betaling value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \RelatieApiV3\StructType\BetaalRecV3|null
     */
    public function getBetaling()
    {
        return isset($this->betaling) ? $this->betaling : null;
    }
    /**
     * Set betaling value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \RelatieApiV3\StructType\BetaalRecV3 $betaling
     * @return \RelatieApiV3\StructType\AfdelingRecV3
     */
    public function setBetaling(\RelatieApiV3\StructType\BetaalRecV3 $betaling = null)
    {
        if (is_null($betaling) || (is_array($betaling) && empty($betaling))) {
            unset($this->betaling);
        } else {
            $this->betaling = $betaling;
        }
        return $this;
    }
    /**
     * Get kortinggroepCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getKortinggroepCode()
    {
        return isset($this->kortinggroepCode) ? $this->kortinggroepCode : null;
    }
    /**
     * Set kortinggroepCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $kortinggroepCode
     * @return \RelatieApiV3\StructType\AfdelingRecV3
     */
    public function setKortinggroepCode($kortinggroepCode = null)
    {
        // validation for constraint: string
        if (!is_null($kortinggroepCode) && !is_string($kortinggroepCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($kortinggroepCode, true), gettype($kortinggroepCode)), __LINE__);
        }
        // validation for constraint: maxLength(12)
        if (!is_null($kortinggroepCode) && mb_strlen($kortinggroepCode) > 12) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 12', mb_strlen($kortinggroepCode)), __LINE__);
        }
        if (is_null($kortinggroepCode) || (is_array($kortinggroepCode) && empty($kortinggroepCode))) {
            unset($this->kortinggroepCode);
        } else {
            $this->kortinggroepCode = $kortinggroepCode;
        }
        return $this;
    }
    /**
     * Get adresBezoek value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \RelatieApiV3\StructType\AdresRecV3|null
     */
    public function getAdresBezoek()
    {
        return isset($this->adresBezoek) ? $this->adresBezoek : null;
    }
    /**
     * Set adresBezoek value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \RelatieApiV3\StructType\AdresRecV3 $adresBezoek
     * @return \RelatieApiV3\StructType\AfdelingRecV3
     */
    public function setAdresBezoek(\RelatieApiV3\StructType\AdresRecV3 $adresBezoek = null)
    {
        if (is_null($adresBezoek) || (is_array($adresBezoek) && empty($adresBezoek))) {
            unset($this->adresBezoek);
        } else {
            $this->adresBezoek = $adresBezoek;
        }
        return $this;
    }
    /**
     * Get adresCorrespondentie value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \RelatieApiV3\StructType\AdresRecV3|null
     */
    public function getAdresCorrespondentie()
    {
        return isset($this->adresCorrespondentie) ? $this->adresCorrespondentie : null;
    }
    /**
     * Set adresCorrespondentie value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \RelatieApiV3\StructType\AdresRecV3 $adresCorrespondentie
     * @return \RelatieApiV3\StructType\AfdelingRecV3
     */
    public function setAdresCorrespondentie(\RelatieApiV3\StructType\AdresRecV3 $adresCorrespondentie = null)
    {
        if (is_null($adresCorrespondentie) || (is_array($adresCorrespondentie) && empty($adresCorrespondentie))) {
            unset($this->adresCorrespondentie);
        } else {
            $this->adresCorrespondentie = $adresCorrespondentie;
        }
        return $this;
    }
    /**
     * Get adresPrive value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \RelatieApiV3\StructType\AdresRecV3|null
     */
    public function getAdresPrive()
    {
        return isset($this->adresPrive) ? $this->adresPrive : null;
    }
    /**
     * Set adresPrive value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \RelatieApiV3\StructType\AdresRecV3 $adresPrive
     * @return \RelatieApiV3\StructType\AfdelingRecV3
     */
    public function setAdresPrive(\RelatieApiV3\StructType\AdresRecV3 $adresPrive = null)
    {
        if (is_null($adresPrive) || (is_array($adresPrive) && empty($adresPrive))) {
            unset($this->adresPrive);
        } else {
            $this->adresPrive = $adresPrive;
        }
        return $this;
    }
    /**
     * Get landCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLandCode()
    {
        return isset($this->landCode) ? $this->landCode : null;
    }
    /**
     * Set landCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $landCode
     * @return \RelatieApiV3\StructType\AfdelingRecV3
     */
    public function setLandCode($landCode = null)
    {
        // validation for constraint: string
        if (!is_null($landCode) && !is_string($landCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($landCode, true), gettype($landCode)), __LINE__);
        }
        // validation for constraint: maxLength(3)
        if (!is_null($landCode) && mb_strlen($landCode) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 3', mb_strlen($landCode)), __LINE__);
        }
        if (is_null($landCode) || (is_array($landCode) && empty($landCode))) {
            unset($this->landCode);
        } else {
            $this->landCode = $landCode;
        }
        return $this;
    }
    /**
     * Get provincieCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getProvincieCode()
    {
        return isset($this->provincieCode) ? $this->provincieCode : null;
    }
    /**
     * Set provincieCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $provincieCode
     * @return \RelatieApiV3\StructType\AfdelingRecV3
     */
    public function setProvincieCode($provincieCode = null)
    {
        // validation for constraint: string
        if (!is_null($provincieCode) && !is_string($provincieCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($provincieCode, true), gettype($provincieCode)), __LINE__);
        }
        // validation for constraint: maxLength(20)
        if (!is_null($provincieCode) && mb_strlen($provincieCode) > 20) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 20', mb_strlen($provincieCode)), __LINE__);
        }
        if (is_null($provincieCode) || (is_array($provincieCode) && empty($provincieCode))) {
            unset($this->provincieCode);
        } else {
            $this->provincieCode = $provincieCode;
        }
        return $this;
    }
    /**
     * Get onvolledig value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getOnvolledig()
    {
        return isset($this->onvolledig) ? $this->onvolledig : null;
    }
    /**
     * Set onvolledig value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $onvolledig
     * @return \RelatieApiV3\StructType\AfdelingRecV3
     */
    public function setOnvolledig($onvolledig = null)
    {
        // validation for constraint: int
        if (!is_null($onvolledig) && !(is_int($onvolledig) || ctype_digit($onvolledig))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($onvolledig, true), gettype($onvolledig)), __LINE__);
        }
        // validation for constraint: totalDigits(3)
        if (!is_null($onvolledig) && mb_strlen(preg_replace('/(\D)/', '', $onvolledig)) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 3 digits, "%d" given', var_export($onvolledig, true), mb_strlen(preg_replace('/(\D)/', '', $onvolledig))), __LINE__);
        }
        if (is_null($onvolledig) || (is_array($onvolledig) && empty($onvolledig))) {
            unset($this->onvolledig);
        } else {
            $this->onvolledig = $onvolledig;
        }
        return $this;
    }
    /**
     * Get vrijeVelden value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \RelatieApiV3\StructType\VrijeVeldenRecV3|null
     */
    public function getVrijeVelden()
    {
        return isset($this->vrijeVelden) ? $this->vrijeVelden : null;
    }
    /**
     * Set vrijeVelden value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \RelatieApiV3\StructType\VrijeVeldenRecV3 $vrijeVelden
     * @return \RelatieApiV3\StructType\AfdelingRecV3
     */
    public function setVrijeVelden(\RelatieApiV3\StructType\VrijeVeldenRecV3 $vrijeVelden = null)
    {
        if (is_null($vrijeVelden) || (is_array($vrijeVelden) && empty($vrijeVelden))) {
            unset($this->vrijeVelden);
        } else {
            $this->vrijeVelden = $vrijeVelden;
        }
        return $this;
    }
    /**
     * Get taalCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTaalCode()
    {
        return isset($this->taalCode) ? $this->taalCode : null;
    }
    /**
     * Set taalCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $taalCode
     * @return \RelatieApiV3\StructType\AfdelingRecV3
     */
    public function setTaalCode($taalCode = null)
    {
        // validation for constraint: string
        if (!is_null($taalCode) && !is_string($taalCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($taalCode, true), gettype($taalCode)), __LINE__);
        }
        // validation for constraint: maxLength(12)
        if (!is_null($taalCode) && mb_strlen($taalCode) > 12) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 12', mb_strlen($taalCode)), __LINE__);
        }
        if (is_null($taalCode) || (is_array($taalCode) && empty($taalCode))) {
            unset($this->taalCode);
        } else {
            $this->taalCode = $taalCode;
        }
        return $this;
    }
    /**
     * Get valutaCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getValutaCode()
    {
        return isset($this->valutaCode) ? $this->valutaCode : null;
    }
    /**
     * Set valutaCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $valutaCode
     * @return \RelatieApiV3\StructType\AfdelingRecV3
     */
    public function setValutaCode($valutaCode = null)
    {
        // validation for constraint: string
        if (!is_null($valutaCode) && !is_string($valutaCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($valutaCode, true), gettype($valutaCode)), __LINE__);
        }
        // validation for constraint: maxLength(3)
        if (!is_null($valutaCode) && mb_strlen($valutaCode) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 3', mb_strlen($valutaCode)), __LINE__);
        }
        if (is_null($valutaCode) || (is_array($valutaCode) && empty($valutaCode))) {
            unset($this->valutaCode);
        } else {
            $this->valutaCode = $valutaCode;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \RelatieApiV3\StructType\AfdelingRecV3
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
