<?php

namespace RelatieApiV3\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for addFunctieRequest StructType
 * Meta information extracted from the WSDL
 * - documentation: Toevoegen van een functie aan een bestaande relatie
 * @subpackage Structs
 * @date 20200204
 * @package RelatieApiV3
 */
class AddFunctieRequest extends AbstractStructBase
{
    /**
     * The relatieSleutel
     * Meta information extracted from the WSDL
     * - documentation: Het unieke Zeno relatienummer.
     * - base: xsd:integer
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * - totalDigits: 15
     * @var int
     */
    public $relatieSleutel;
    /**
     * The functieCode
     * Meta information extracted from the WSDL
     * - documentation: De code van de te koppelen functie
     * - base: xsd:string
     * - maxLength: 12
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $functieCode;
    /**
     * The requestTag
     * Meta information extracted from the WSDL
     * - documentation: Vrij veld voor aanroepende partij. De inhoud van dit veld wordt altijd identiek teruggestuurd.
     * - base: xsd:string
     * - maxLength: 4000
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $requestTag;
    /**
     * Constructor method for addFunctieRequest
     * @uses AddFunctieRequest::setRelatieSleutel()
     * @uses AddFunctieRequest::setFunctieCode()
     * @uses AddFunctieRequest::setRequestTag()
     * @param int $relatieSleutel
     * @param string $functieCode
     * @param string $requestTag
     */
    public function __construct($relatieSleutel = null, $functieCode = null, $requestTag = null)
    {
        $this
            ->setRelatieSleutel($relatieSleutel)
            ->setFunctieCode($functieCode)
            ->setRequestTag($requestTag);
    }
    /**
     * Get relatieSleutel value
     * @return int
     */
    public function getRelatieSleutel()
    {
        return $this->relatieSleutel;
    }
    /**
     * Set relatieSleutel value
     * @param int $relatieSleutel
     * @return \RelatieApiV3\StructType\AddFunctieRequest
     */
    public function setRelatieSleutel($relatieSleutel = null)
    {
        // validation for constraint: int
        if (!is_null($relatieSleutel) && !(is_int($relatieSleutel) || ctype_digit($relatieSleutel))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($relatieSleutel, true), gettype($relatieSleutel)), __LINE__);
        }
        // validation for constraint: totalDigits(15)
        if (!is_null($relatieSleutel) && mb_strlen(preg_replace('/(\D)/', '', $relatieSleutel)) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 15 digits, "%d" given', var_export($relatieSleutel, true), mb_strlen(preg_replace('/(\D)/', '', $relatieSleutel))), __LINE__);
        }
        $this->relatieSleutel = $relatieSleutel;
        return $this;
    }
    /**
     * Get functieCode value
     * @return string
     */
    public function getFunctieCode()
    {
        return $this->functieCode;
    }
    /**
     * Set functieCode value
     * @param string $functieCode
     * @return \RelatieApiV3\StructType\AddFunctieRequest
     */
    public function setFunctieCode($functieCode = null)
    {
        // validation for constraint: string
        if (!is_null($functieCode) && !is_string($functieCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($functieCode, true), gettype($functieCode)), __LINE__);
        }
        // validation for constraint: maxLength(12)
        if (!is_null($functieCode) && mb_strlen($functieCode) > 12) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 12', mb_strlen($functieCode)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($functieCode) && mb_strlen($functieCode) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($functieCode)), __LINE__);
        }
        $this->functieCode = $functieCode;
        return $this;
    }
    /**
     * Get requestTag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRequestTag()
    {
        return isset($this->requestTag) ? $this->requestTag : null;
    }
    /**
     * Set requestTag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $requestTag
     * @return \RelatieApiV3\StructType\AddFunctieRequest
     */
    public function setRequestTag($requestTag = null)
    {
        // validation for constraint: string
        if (!is_null($requestTag) && !is_string($requestTag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($requestTag, true), gettype($requestTag)), __LINE__);
        }
        // validation for constraint: maxLength(4000)
        if (!is_null($requestTag) && mb_strlen($requestTag) > 4000) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 4000', mb_strlen($requestTag)), __LINE__);
        }
        if (is_null($requestTag) || (is_array($requestTag) && empty($requestTag))) {
            unset($this->requestTag);
        } else {
            $this->requestTag = $requestTag;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \RelatieApiV3\StructType\AddFunctieRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
