<?php

namespace RelatieApiV3\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TaalcodetableV3 StructType
 * Meta information extracted from the WSDL
 * - documentation: Lijst met beschikbare taalcodes
 * @subpackage Structs
 * @date 20200204
 * @package RelatieApiV3
 */
class TaalcodetableV3 extends AbstractStructBase
{
    /**
     * The taalcode
     * Meta information extracted from the WSDL
     * - documentation: Taalcodes
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: false
     * @var \RelatieApiV3\StructType\TaalcodeRecV3[]
     */
    public $taalcode;
    /**
     * Constructor method for TaalcodetableV3
     * @uses TaalcodetableV3::setTaalcode()
     * @param \RelatieApiV3\StructType\TaalcodeRecV3[] $taalcode
     */
    public function __construct(array $taalcode = array())
    {
        $this
            ->setTaalcode($taalcode);
    }
    /**
     * Get taalcode value
     * @return \RelatieApiV3\StructType\TaalcodeRecV3[]|null
     */
    public function getTaalcode()
    {
        return $this->taalcode;
    }
    /**
     * This method is responsible for validating the values passed to the setTaalcode method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTaalcode method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTaalcodeForArrayConstraintsFromSetTaalcode(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $taalcodetableV3TaalcodeItem) {
            // validation for constraint: itemType
            if (!$taalcodetableV3TaalcodeItem instanceof \RelatieApiV3\StructType\TaalcodeRecV3) {
                $invalidValues[] = is_object($taalcodetableV3TaalcodeItem) ? get_class($taalcodetableV3TaalcodeItem) : sprintf('%s(%s)', gettype($taalcodetableV3TaalcodeItem), var_export($taalcodetableV3TaalcodeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The taalcode property can only contain items of type \RelatieApiV3\StructType\TaalcodeRecV3, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set taalcode value
     * @throws \InvalidArgumentException
     * @param \RelatieApiV3\StructType\TaalcodeRecV3[] $taalcode
     * @return \RelatieApiV3\StructType\TaalcodetableV3
     */
    public function setTaalcode(array $taalcode = array())
    {
        // validation for constraint: array
        if ('' !== ($taalcodeArrayErrorMessage = self::validateTaalcodeForArrayConstraintsFromSetTaalcode($taalcode))) {
            throw new \InvalidArgumentException($taalcodeArrayErrorMessage, __LINE__);
        }
        $this->taalcode = $taalcode;
        return $this;
    }
    /**
     * Add item to taalcode value
     * @throws \InvalidArgumentException
     * @param \RelatieApiV3\StructType\TaalcodeRecV3 $item
     * @return \RelatieApiV3\StructType\TaalcodetableV3
     */
    public function addToTaalcode(\RelatieApiV3\StructType\TaalcodeRecV3 $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \RelatieApiV3\StructType\TaalcodeRecV3) {
            throw new \InvalidArgumentException(sprintf('The taalcode property can only contain items of type \RelatieApiV3\StructType\TaalcodeRecV3, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->taalcode[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \RelatieApiV3\StructType\TaalcodetableV3
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
