<?php

namespace RelatieApiV3\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SearchNaamRecV3 StructType
 * Meta information extracted from the WSDL
 * - documentation: Relatiegegevens tbv de searchNaam operatie
 * @subpackage Structs
 * @date 20200204
 * @package RelatieApiV3
 */
class SearchNaamRecV3 extends AbstractStructBase
{
    /**
     * The relatienummer
     * Meta information extracted from the WSDL
     * - documentation: Het relatienummer
     * - base: xsd:integer
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * - totalDigits: 15
     * @var int
     */
    public $relatienummer;
    /**
     * The relatietype
     * Meta information extracted from the WSDL
     * - documentation: Het relatietype ( 'B'(edrijf), 'A'(fdeling), 'C'(ontactpersoon), 'P'(private persoon) )
     * - base: xsd:string
     * - maxLength: 1
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $relatietype;
    /**
     * The naamBedrijf
     * Meta information extracted from the WSDL
     * - documentation: De bedrijfsnaam, indien de gevonden relatie een bedrijf, contactpersoon of contactafdeling is
     * - base: xsd:string
     * - maxLength: 120
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $naamBedrijf;
    /**
     * The naamAfdeling
     * Meta information extracted from the WSDL
     * - documentation: De naam van de afdeling. Kan bij alle relatietypes voorkomen
     * - base: xsd:string
     * - maxLength: 120
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $naamAfdeling;
    /**
     * The naamPersoon
     * Meta information extracted from the WSDL
     * - documentation: De complete naam van de persoon. Kan gevuld zijn bij privÃÂ© persoon en contactpersoon
     * - base: xsd:string
     * - maxLength: 255
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $naamPersoon;
    /**
     * The achternaamPersoon
     * Meta information extracted from the WSDL
     * - documentation: De achternaam van de persoon. Kan gevuld zijn bij privÃÂ© persoon en contactpersoon
     * - base: xsd:string
     * - maxLength: 120
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $achternaamPersoon;
    /**
     * The plaatsnaamBezoekadres
     * Meta information extracted from the WSDL
     * - documentation: De plaatsnaam van het bezoekadres.
     * - base: xsd:string
     * - maxLength: 120
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $plaatsnaamBezoekadres;
    /**
     * Constructor method for SearchNaamRecV3
     * @uses SearchNaamRecV3::setRelatienummer()
     * @uses SearchNaamRecV3::setRelatietype()
     * @uses SearchNaamRecV3::setNaamBedrijf()
     * @uses SearchNaamRecV3::setNaamAfdeling()
     * @uses SearchNaamRecV3::setNaamPersoon()
     * @uses SearchNaamRecV3::setAchternaamPersoon()
     * @uses SearchNaamRecV3::setPlaatsnaamBezoekadres()
     * @param int $relatienummer
     * @param string $relatietype
     * @param string $naamBedrijf
     * @param string $naamAfdeling
     * @param string $naamPersoon
     * @param string $achternaamPersoon
     * @param string $plaatsnaamBezoekadres
     */
    public function __construct($relatienummer = null, $relatietype = null, $naamBedrijf = null, $naamAfdeling = null, $naamPersoon = null, $achternaamPersoon = null, $plaatsnaamBezoekadres = null)
    {
        $this
            ->setRelatienummer($relatienummer)
            ->setRelatietype($relatietype)
            ->setNaamBedrijf($naamBedrijf)
            ->setNaamAfdeling($naamAfdeling)
            ->setNaamPersoon($naamPersoon)
            ->setAchternaamPersoon($achternaamPersoon)
            ->setPlaatsnaamBezoekadres($plaatsnaamBezoekadres);
    }
    /**
     * Get relatienummer value
     * @return int
     */
    public function getRelatienummer()
    {
        return $this->relatienummer;
    }
    /**
     * Set relatienummer value
     * @param int $relatienummer
     * @return \RelatieApiV3\StructType\SearchNaamRecV3
     */
    public function setRelatienummer($relatienummer = null)
    {
        // validation for constraint: int
        if (!is_null($relatienummer) && !(is_int($relatienummer) || ctype_digit($relatienummer))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($relatienummer, true), gettype($relatienummer)), __LINE__);
        }
        // validation for constraint: totalDigits(15)
        if (!is_null($relatienummer) && mb_strlen(preg_replace('/(\D)/', '', $relatienummer)) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 15 digits, "%d" given', var_export($relatienummer, true), mb_strlen(preg_replace('/(\D)/', '', $relatienummer))), __LINE__);
        }
        $this->relatienummer = $relatienummer;
        return $this;
    }
    /**
     * Get relatietype value
     * @return string
     */
    public function getRelatietype()
    {
        return $this->relatietype;
    }
    /**
     * Set relatietype value
     * @param string $relatietype
     * @return \RelatieApiV3\StructType\SearchNaamRecV3
     */
    public function setRelatietype($relatietype = null)
    {
        // validation for constraint: string
        if (!is_null($relatietype) && !is_string($relatietype)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($relatietype, true), gettype($relatietype)), __LINE__);
        }
        // validation for constraint: maxLength(1)
        if (!is_null($relatietype) && mb_strlen($relatietype) > 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 1', mb_strlen($relatietype)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($relatietype) && mb_strlen($relatietype) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($relatietype)), __LINE__);
        }
        $this->relatietype = $relatietype;
        return $this;
    }
    /**
     * Get naamBedrijf value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNaamBedrijf()
    {
        return isset($this->naamBedrijf) ? $this->naamBedrijf : null;
    }
    /**
     * Set naamBedrijf value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $naamBedrijf
     * @return \RelatieApiV3\StructType\SearchNaamRecV3
     */
    public function setNaamBedrijf($naamBedrijf = null)
    {
        // validation for constraint: string
        if (!is_null($naamBedrijf) && !is_string($naamBedrijf)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($naamBedrijf, true), gettype($naamBedrijf)), __LINE__);
        }
        // validation for constraint: maxLength(120)
        if (!is_null($naamBedrijf) && mb_strlen($naamBedrijf) > 120) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 120', mb_strlen($naamBedrijf)), __LINE__);
        }
        if (is_null($naamBedrijf) || (is_array($naamBedrijf) && empty($naamBedrijf))) {
            unset($this->naamBedrijf);
        } else {
            $this->naamBedrijf = $naamBedrijf;
        }
        return $this;
    }
    /**
     * Get naamAfdeling value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNaamAfdeling()
    {
        return isset($this->naamAfdeling) ? $this->naamAfdeling : null;
    }
    /**
     * Set naamAfdeling value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $naamAfdeling
     * @return \RelatieApiV3\StructType\SearchNaamRecV3
     */
    public function setNaamAfdeling($naamAfdeling = null)
    {
        // validation for constraint: string
        if (!is_null($naamAfdeling) && !is_string($naamAfdeling)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($naamAfdeling, true), gettype($naamAfdeling)), __LINE__);
        }
        // validation for constraint: maxLength(120)
        if (!is_null($naamAfdeling) && mb_strlen($naamAfdeling) > 120) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 120', mb_strlen($naamAfdeling)), __LINE__);
        }
        if (is_null($naamAfdeling) || (is_array($naamAfdeling) && empty($naamAfdeling))) {
            unset($this->naamAfdeling);
        } else {
            $this->naamAfdeling = $naamAfdeling;
        }
        return $this;
    }
    /**
     * Get naamPersoon value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNaamPersoon()
    {
        return isset($this->naamPersoon) ? $this->naamPersoon : null;
    }
    /**
     * Set naamPersoon value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $naamPersoon
     * @return \RelatieApiV3\StructType\SearchNaamRecV3
     */
    public function setNaamPersoon($naamPersoon = null)
    {
        // validation for constraint: string
        if (!is_null($naamPersoon) && !is_string($naamPersoon)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($naamPersoon, true), gettype($naamPersoon)), __LINE__);
        }
        // validation for constraint: maxLength(255)
        if (!is_null($naamPersoon) && mb_strlen($naamPersoon) > 255) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 255', mb_strlen($naamPersoon)), __LINE__);
        }
        if (is_null($naamPersoon) || (is_array($naamPersoon) && empty($naamPersoon))) {
            unset($this->naamPersoon);
        } else {
            $this->naamPersoon = $naamPersoon;
        }
        return $this;
    }
    /**
     * Get achternaamPersoon value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAchternaamPersoon()
    {
        return isset($this->achternaamPersoon) ? $this->achternaamPersoon : null;
    }
    /**
     * Set achternaamPersoon value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $achternaamPersoon
     * @return \RelatieApiV3\StructType\SearchNaamRecV3
     */
    public function setAchternaamPersoon($achternaamPersoon = null)
    {
        // validation for constraint: string
        if (!is_null($achternaamPersoon) && !is_string($achternaamPersoon)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($achternaamPersoon, true), gettype($achternaamPersoon)), __LINE__);
        }
        // validation for constraint: maxLength(120)
        if (!is_null($achternaamPersoon) && mb_strlen($achternaamPersoon) > 120) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 120', mb_strlen($achternaamPersoon)), __LINE__);
        }
        if (is_null($achternaamPersoon) || (is_array($achternaamPersoon) && empty($achternaamPersoon))) {
            unset($this->achternaamPersoon);
        } else {
            $this->achternaamPersoon = $achternaamPersoon;
        }
        return $this;
    }
    /**
     * Get plaatsnaamBezoekadres value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPlaatsnaamBezoekadres()
    {
        return isset($this->plaatsnaamBezoekadres) ? $this->plaatsnaamBezoekadres : null;
    }
    /**
     * Set plaatsnaamBezoekadres value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $plaatsnaamBezoekadres
     * @return \RelatieApiV3\StructType\SearchNaamRecV3
     */
    public function setPlaatsnaamBezoekadres($plaatsnaamBezoekadres = null)
    {
        // validation for constraint: string
        if (!is_null($plaatsnaamBezoekadres) && !is_string($plaatsnaamBezoekadres)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($plaatsnaamBezoekadres, true), gettype($plaatsnaamBezoekadres)), __LINE__);
        }
        // validation for constraint: maxLength(120)
        if (!is_null($plaatsnaamBezoekadres) && mb_strlen($plaatsnaamBezoekadres) > 120) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 120', mb_strlen($plaatsnaamBezoekadres)), __LINE__);
        }
        if (is_null($plaatsnaamBezoekadres) || (is_array($plaatsnaamBezoekadres) && empty($plaatsnaamBezoekadres))) {
            unset($this->plaatsnaamBezoekadres);
        } else {
            $this->plaatsnaamBezoekadres = $plaatsnaamBezoekadres;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \RelatieApiV3\StructType\SearchNaamRecV3
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
