<?php

namespace RelatieApiV3\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for searchBedrijfInclContRequest StructType
 * Meta information extracted from the WSDL
 * - documentation: Zoeken naar relaties op basis van postcode + huisnummer of e-mail 1, e-mail 2, e-mail 3 of e-mail 4 Kan alleen gebruikt worden indien systeem-constante "Invoer van bedrijven op de relatiekaart inclusief contactpersoon" geactiveerd
 * is.
 * @subpackage Structs
 * @date 20200204
 * @package RelatieApiV3
 */
class SearchBedrijfInclContRequest extends AbstractStructBase
{
    /**
     * The requestTag
     * Meta information extracted from the WSDL
     * - documentation: Vrij veld voor aanroepende partij. De inhoud van dit veld wordt altijd identiek teruggestuurd.
     * - base: xsd:string
     * - maxLength: 4000
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $requestTag;
    /**
     * The postcode
     * Meta information extracted from the WSDL
     * - documentation: De postcode waarop de relatie een adres moet hebben
     * - base: xsd:string
     * - maxLength: 10
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $postcode;
    /**
     * The huisnummer
     * Meta information extracted from the WSDL
     * - documentation: Huisnummer waarop de relatie een adres moet hebben
     * - base: xsd:string
     * - maxLength: 10
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $huisnummer;
    /**
     * The email
     * Meta information extracted from the WSDL
     * - documentation: Het e-mail adres 1 van de relatie
     * - base: xsd:string
     * - maxLength: 80
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $email;
    /**
     * The email2
     * Meta information extracted from the WSDL
     * - documentation: Het e-mail adres 2 van de relatie
     * - base: xsd:string
     * - maxLength: 80
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $email2;
    /**
     * The email3
     * Meta information extracted from the WSDL
     * - documentation: Het e-mail adres 3 van de relatie
     * - base: xsd:string
     * - maxLength: 80
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $email3;
    /**
     * The email4
     * Meta information extracted from the WSDL
     * - documentation: Het e-mail adres 4 van de relatie
     * - base: xsd:string
     * - maxLength: 80
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $email4;
    /**
     * The includeFuncties
     * Meta information extracted from the WSDL
     * - documentation: De functies gekoppeld aan de relatie retourneren
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $includeFuncties;
    /**
     * Constructor method for searchBedrijfInclContRequest
     * @uses SearchBedrijfInclContRequest::setRequestTag()
     * @uses SearchBedrijfInclContRequest::setPostcode()
     * @uses SearchBedrijfInclContRequest::setHuisnummer()
     * @uses SearchBedrijfInclContRequest::setEmail()
     * @uses SearchBedrijfInclContRequest::setEmail2()
     * @uses SearchBedrijfInclContRequest::setEmail3()
     * @uses SearchBedrijfInclContRequest::setEmail4()
     * @uses SearchBedrijfInclContRequest::setIncludeFuncties()
     * @param string $requestTag
     * @param string $postcode
     * @param string $huisnummer
     * @param string $email
     * @param string $email2
     * @param string $email3
     * @param string $email4
     * @param bool $includeFuncties
     */
    public function __construct($requestTag = null, $postcode = null, $huisnummer = null, $email = null, $email2 = null, $email3 = null, $email4 = null, $includeFuncties = null)
    {
        $this
            ->setRequestTag($requestTag)
            ->setPostcode($postcode)
            ->setHuisnummer($huisnummer)
            ->setEmail($email)
            ->setEmail2($email2)
            ->setEmail3($email3)
            ->setEmail4($email4)
            ->setIncludeFuncties($includeFuncties);
    }
    /**
     * Get requestTag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRequestTag()
    {
        return isset($this->requestTag) ? $this->requestTag : null;
    }
    /**
     * Set requestTag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $requestTag
     * @return \RelatieApiV3\StructType\SearchBedrijfInclContRequest
     */
    public function setRequestTag($requestTag = null)
    {
        // validation for constraint: string
        if (!is_null($requestTag) && !is_string($requestTag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($requestTag, true), gettype($requestTag)), __LINE__);
        }
        // validation for constraint: maxLength(4000)
        if (!is_null($requestTag) && mb_strlen($requestTag) > 4000) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 4000', mb_strlen($requestTag)), __LINE__);
        }
        if (is_null($requestTag) || (is_array($requestTag) && empty($requestTag))) {
            unset($this->requestTag);
        } else {
            $this->requestTag = $requestTag;
        }
        return $this;
    }
    /**
     * Get postcode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPostcode()
    {
        return isset($this->postcode) ? $this->postcode : null;
    }
    /**
     * Set postcode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $postcode
     * @return \RelatieApiV3\StructType\SearchBedrijfInclContRequest
     */
    public function setPostcode($postcode = null)
    {
        // validation for constraint: string
        if (!is_null($postcode) && !is_string($postcode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($postcode, true), gettype($postcode)), __LINE__);
        }
        // validation for constraint: maxLength(10)
        if (!is_null($postcode) && mb_strlen($postcode) > 10) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 10', mb_strlen($postcode)), __LINE__);
        }
        if (is_null($postcode) || (is_array($postcode) && empty($postcode))) {
            unset($this->postcode);
        } else {
            $this->postcode = $postcode;
        }
        return $this;
    }
    /**
     * Get huisnummer value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getHuisnummer()
    {
        return isset($this->huisnummer) ? $this->huisnummer : null;
    }
    /**
     * Set huisnummer value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $huisnummer
     * @return \RelatieApiV3\StructType\SearchBedrijfInclContRequest
     */
    public function setHuisnummer($huisnummer = null)
    {
        // validation for constraint: string
        if (!is_null($huisnummer) && !is_string($huisnummer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($huisnummer, true), gettype($huisnummer)), __LINE__);
        }
        // validation for constraint: maxLength(10)
        if (!is_null($huisnummer) && mb_strlen($huisnummer) > 10) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 10', mb_strlen($huisnummer)), __LINE__);
        }
        if (is_null($huisnummer) || (is_array($huisnummer) && empty($huisnummer))) {
            unset($this->huisnummer);
        } else {
            $this->huisnummer = $huisnummer;
        }
        return $this;
    }
    /**
     * Get email value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEmail()
    {
        return isset($this->email) ? $this->email : null;
    }
    /**
     * Set email value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $email
     * @return \RelatieApiV3\StructType\SearchBedrijfInclContRequest
     */
    public function setEmail($email = null)
    {
        // validation for constraint: string
        if (!is_null($email) && !is_string($email)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($email, true), gettype($email)), __LINE__);
        }
        // validation for constraint: maxLength(80)
        if (!is_null($email) && mb_strlen($email) > 80) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 80', mb_strlen($email)), __LINE__);
        }
        if (is_null($email) || (is_array($email) && empty($email))) {
            unset($this->email);
        } else {
            $this->email = $email;
        }
        return $this;
    }
    /**
     * Get email2 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEmail2()
    {
        return isset($this->email2) ? $this->email2 : null;
    }
    /**
     * Set email2 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $email2
     * @return \RelatieApiV3\StructType\SearchBedrijfInclContRequest
     */
    public function setEmail2($email2 = null)
    {
        // validation for constraint: string
        if (!is_null($email2) && !is_string($email2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($email2, true), gettype($email2)), __LINE__);
        }
        // validation for constraint: maxLength(80)
        if (!is_null($email2) && mb_strlen($email2) > 80) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 80', mb_strlen($email2)), __LINE__);
        }
        if (is_null($email2) || (is_array($email2) && empty($email2))) {
            unset($this->email2);
        } else {
            $this->email2 = $email2;
        }
        return $this;
    }
    /**
     * Get email3 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEmail3()
    {
        return isset($this->email3) ? $this->email3 : null;
    }
    /**
     * Set email3 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $email3
     * @return \RelatieApiV3\StructType\SearchBedrijfInclContRequest
     */
    public function setEmail3($email3 = null)
    {
        // validation for constraint: string
        if (!is_null($email3) && !is_string($email3)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($email3, true), gettype($email3)), __LINE__);
        }
        // validation for constraint: maxLength(80)
        if (!is_null($email3) && mb_strlen($email3) > 80) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 80', mb_strlen($email3)), __LINE__);
        }
        if (is_null($email3) || (is_array($email3) && empty($email3))) {
            unset($this->email3);
        } else {
            $this->email3 = $email3;
        }
        return $this;
    }
    /**
     * Get email4 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEmail4()
    {
        return isset($this->email4) ? $this->email4 : null;
    }
    /**
     * Set email4 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $email4
     * @return \RelatieApiV3\StructType\SearchBedrijfInclContRequest
     */
    public function setEmail4($email4 = null)
    {
        // validation for constraint: string
        if (!is_null($email4) && !is_string($email4)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($email4, true), gettype($email4)), __LINE__);
        }
        // validation for constraint: maxLength(80)
        if (!is_null($email4) && mb_strlen($email4) > 80) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 80', mb_strlen($email4)), __LINE__);
        }
        if (is_null($email4) || (is_array($email4) && empty($email4))) {
            unset($this->email4);
        } else {
            $this->email4 = $email4;
        }
        return $this;
    }
    /**
     * Get includeFuncties value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIncludeFuncties()
    {
        return isset($this->includeFuncties) ? $this->includeFuncties : null;
    }
    /**
     * Set includeFuncties value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $includeFuncties
     * @return \RelatieApiV3\StructType\SearchBedrijfInclContRequest
     */
    public function setIncludeFuncties($includeFuncties = null)
    {
        // validation for constraint: boolean
        if (!is_null($includeFuncties) && !is_bool($includeFuncties)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($includeFuncties, true), gettype($includeFuncties)), __LINE__);
        }
        if (is_null($includeFuncties) || (is_array($includeFuncties) && empty($includeFuncties))) {
            unset($this->includeFuncties);
        } else {
            $this->includeFuncties = $includeFuncties;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \RelatieApiV3\StructType\SearchBedrijfInclContRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
