<?php

namespace RelatieApiV3\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RelatieFunctietableV3 StructType
 * Meta information extracted from the WSDL
 * - documentation: Lijst met aan de relatie gekoppelde functies
 * @subpackage Structs
 * @date 20200204
 * @package RelatieApiV3
 */
class RelatieFunctietableV3 extends AbstractStructBase
{
    /**
     * The relatieFunctie
     * Meta information extracted from the WSDL
     * - documentation: Functies
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: false
     * @var \RelatieApiV3\StructType\RelatieFunctieRecV3[]
     */
    public $relatieFunctie;
    /**
     * Constructor method for RelatieFunctietableV3
     * @uses RelatieFunctietableV3::setRelatieFunctie()
     * @param \RelatieApiV3\StructType\RelatieFunctieRecV3[] $relatieFunctie
     */
    public function __construct(array $relatieFunctie = array())
    {
        $this
            ->setRelatieFunctie($relatieFunctie);
    }
    /**
     * Get relatieFunctie value
     * @return \RelatieApiV3\StructType\RelatieFunctieRecV3[]|null
     */
    public function getRelatieFunctie()
    {
        return $this->relatieFunctie;
    }
    /**
     * This method is responsible for validating the values passed to the setRelatieFunctie method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRelatieFunctie method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRelatieFunctieForArrayConstraintsFromSetRelatieFunctie(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $relatieFunctietableV3RelatieFunctieItem) {
            // validation for constraint: itemType
            if (!$relatieFunctietableV3RelatieFunctieItem instanceof \RelatieApiV3\StructType\RelatieFunctieRecV3) {
                $invalidValues[] = is_object($relatieFunctietableV3RelatieFunctieItem) ? get_class($relatieFunctietableV3RelatieFunctieItem) : sprintf('%s(%s)', gettype($relatieFunctietableV3RelatieFunctieItem), var_export($relatieFunctietableV3RelatieFunctieItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The relatieFunctie property can only contain items of type \RelatieApiV3\StructType\RelatieFunctieRecV3, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set relatieFunctie value
     * @throws \InvalidArgumentException
     * @param \RelatieApiV3\StructType\RelatieFunctieRecV3[] $relatieFunctie
     * @return \RelatieApiV3\StructType\RelatieFunctietableV3
     */
    public function setRelatieFunctie(array $relatieFunctie = array())
    {
        // validation for constraint: array
        if ('' !== ($relatieFunctieArrayErrorMessage = self::validateRelatieFunctieForArrayConstraintsFromSetRelatieFunctie($relatieFunctie))) {
            throw new \InvalidArgumentException($relatieFunctieArrayErrorMessage, __LINE__);
        }
        $this->relatieFunctie = $relatieFunctie;
        return $this;
    }
    /**
     * Add item to relatieFunctie value
     * @throws \InvalidArgumentException
     * @param \RelatieApiV3\StructType\RelatieFunctieRecV3 $item
     * @return \RelatieApiV3\StructType\RelatieFunctietableV3
     */
    public function addToRelatieFunctie(\RelatieApiV3\StructType\RelatieFunctieRecV3 $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \RelatieApiV3\StructType\RelatieFunctieRecV3) {
            throw new \InvalidArgumentException(sprintf('The relatieFunctie property can only contain items of type \RelatieApiV3\StructType\RelatieFunctieRecV3, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->relatieFunctie[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \RelatieApiV3\StructType\RelatieFunctietableV3
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
