<?php

namespace RelatieApiV3\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RelatieFunctieRecV3 StructType
 * Meta information extracted from the WSDL
 * - documentation: Relatie functie
 * @subpackage Structs
 * @date 20200204
 * @package RelatieApiV3
 */
class RelatieFunctieRecV3 extends AbstractStructBase
{
    /**
     * The relatieFunctieSleutel
     * Meta information extracted from the WSDL
     * - documentation: Unieke sleutel van de koppeling van de functie aan de relatie
     * - base: xsd:integer
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * - totalDigits: 15
     * @var int
     */
    public $relatieFunctieSleutel;
    /**
     * The functie
     * Meta information extracted from the WSDL
     * - documentation: De gekoppelde functie
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \RelatieApiV3\StructType\FunctieRecV3
     */
    public $functie;
    /**
     * Constructor method for RelatieFunctieRecV3
     * @uses RelatieFunctieRecV3::setRelatieFunctieSleutel()
     * @uses RelatieFunctieRecV3::setFunctie()
     * @param int $relatieFunctieSleutel
     * @param \RelatieApiV3\StructType\FunctieRecV3 $functie
     */
    public function __construct($relatieFunctieSleutel = null, \RelatieApiV3\StructType\FunctieRecV3 $functie = null)
    {
        $this
            ->setRelatieFunctieSleutel($relatieFunctieSleutel)
            ->setFunctie($functie);
    }
    /**
     * Get relatieFunctieSleutel value
     * @return int
     */
    public function getRelatieFunctieSleutel()
    {
        return $this->relatieFunctieSleutel;
    }
    /**
     * Set relatieFunctieSleutel value
     * @param int $relatieFunctieSleutel
     * @return \RelatieApiV3\StructType\RelatieFunctieRecV3
     */
    public function setRelatieFunctieSleutel($relatieFunctieSleutel = null)
    {
        // validation for constraint: int
        if (!is_null($relatieFunctieSleutel) && !(is_int($relatieFunctieSleutel) || ctype_digit($relatieFunctieSleutel))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($relatieFunctieSleutel, true), gettype($relatieFunctieSleutel)), __LINE__);
        }
        // validation for constraint: totalDigits(15)
        if (!is_null($relatieFunctieSleutel) && mb_strlen(preg_replace('/(\D)/', '', $relatieFunctieSleutel)) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 15 digits, "%d" given', var_export($relatieFunctieSleutel, true), mb_strlen(preg_replace('/(\D)/', '', $relatieFunctieSleutel))), __LINE__);
        }
        $this->relatieFunctieSleutel = $relatieFunctieSleutel;
        return $this;
    }
    /**
     * Get functie value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \RelatieApiV3\StructType\FunctieRecV3|null
     */
    public function getFunctie()
    {
        return isset($this->functie) ? $this->functie : null;
    }
    /**
     * Set functie value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \RelatieApiV3\StructType\FunctieRecV3 $functie
     * @return \RelatieApiV3\StructType\RelatieFunctieRecV3
     */
    public function setFunctie(\RelatieApiV3\StructType\FunctieRecV3 $functie = null)
    {
        if (is_null($functie) || (is_array($functie) && empty($functie))) {
            unset($this->functie);
        } else {
            $this->functie = $functie;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \RelatieApiV3\StructType\RelatieFunctieRecV3
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
