<?php

namespace RelatieApiV3\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ProvinciecodeRecV3 StructType
 * Meta information extracted from the WSDL
 * - documentation: Provincie gegevens
 * @subpackage Structs
 * @date 20200204
 * @package RelatieApiV3
 */
class ProvinciecodeRecV3 extends AbstractStructBase
{
    /**
     * The provincieCode
     * Meta information extracted from the WSDL
     * - documentation: De code van de provincie
     * - base: xsd:string
     * - maxLength: 20
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $provincieCode;
    /**
     * The landCode
     * Meta information extracted from the WSDL
     * - documentation: naam van het land waar de provincie zich in bevindt
     * - base: xsd:string
     * - maxLength: 3
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $landCode;
    /**
     * The provincieNaam
     * Meta information extracted from the WSDL
     * - documentation: Naam van de provincie
     * - base: xsd:string
     * - maxLength: 120
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $provincieNaam;
    /**
     * The landNaam
     * Meta information extracted from the WSDL
     * - documentation: naam van het land waar de provincie zich in bevindt
     * - base: xsd:string
     * - maxLength: 120
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $landNaam;
    /**
     * Constructor method for ProvinciecodeRecV3
     * @uses ProvinciecodeRecV3::setProvincieCode()
     * @uses ProvinciecodeRecV3::setLandCode()
     * @uses ProvinciecodeRecV3::setProvincieNaam()
     * @uses ProvinciecodeRecV3::setLandNaam()
     * @param string $provincieCode
     * @param string $landCode
     * @param string $provincieNaam
     * @param string $landNaam
     */
    public function __construct($provincieCode = null, $landCode = null, $provincieNaam = null, $landNaam = null)
    {
        $this
            ->setProvincieCode($provincieCode)
            ->setLandCode($landCode)
            ->setProvincieNaam($provincieNaam)
            ->setLandNaam($landNaam);
    }
    /**
     * Get provincieCode value
     * @return string
     */
    public function getProvincieCode()
    {
        return $this->provincieCode;
    }
    /**
     * Set provincieCode value
     * @param string $provincieCode
     * @return \RelatieApiV3\StructType\ProvinciecodeRecV3
     */
    public function setProvincieCode($provincieCode = null)
    {
        // validation for constraint: string
        if (!is_null($provincieCode) && !is_string($provincieCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($provincieCode, true), gettype($provincieCode)), __LINE__);
        }
        // validation for constraint: maxLength(20)
        if (!is_null($provincieCode) && mb_strlen($provincieCode) > 20) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 20', mb_strlen($provincieCode)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($provincieCode) && mb_strlen($provincieCode) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($provincieCode)), __LINE__);
        }
        $this->provincieCode = $provincieCode;
        return $this;
    }
    /**
     * Get landCode value
     * @return string
     */
    public function getLandCode()
    {
        return $this->landCode;
    }
    /**
     * Set landCode value
     * @param string $landCode
     * @return \RelatieApiV3\StructType\ProvinciecodeRecV3
     */
    public function setLandCode($landCode = null)
    {
        // validation for constraint: string
        if (!is_null($landCode) && !is_string($landCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($landCode, true), gettype($landCode)), __LINE__);
        }
        // validation for constraint: maxLength(3)
        if (!is_null($landCode) && mb_strlen($landCode) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 3', mb_strlen($landCode)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($landCode) && mb_strlen($landCode) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($landCode)), __LINE__);
        }
        $this->landCode = $landCode;
        return $this;
    }
    /**
     * Get provincieNaam value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getProvincieNaam()
    {
        return isset($this->provincieNaam) ? $this->provincieNaam : null;
    }
    /**
     * Set provincieNaam value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $provincieNaam
     * @return \RelatieApiV3\StructType\ProvinciecodeRecV3
     */
    public function setProvincieNaam($provincieNaam = null)
    {
        // validation for constraint: string
        if (!is_null($provincieNaam) && !is_string($provincieNaam)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($provincieNaam, true), gettype($provincieNaam)), __LINE__);
        }
        // validation for constraint: maxLength(120)
        if (!is_null($provincieNaam) && mb_strlen($provincieNaam) > 120) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 120', mb_strlen($provincieNaam)), __LINE__);
        }
        if (is_null($provincieNaam) || (is_array($provincieNaam) && empty($provincieNaam))) {
            unset($this->provincieNaam);
        } else {
            $this->provincieNaam = $provincieNaam;
        }
        return $this;
    }
    /**
     * Get landNaam value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLandNaam()
    {
        return isset($this->landNaam) ? $this->landNaam : null;
    }
    /**
     * Set landNaam value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $landNaam
     * @return \RelatieApiV3\StructType\ProvinciecodeRecV3
     */
    public function setLandNaam($landNaam = null)
    {
        // validation for constraint: string
        if (!is_null($landNaam) && !is_string($landNaam)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($landNaam, true), gettype($landNaam)), __LINE__);
        }
        // validation for constraint: maxLength(120)
        if (!is_null($landNaam) && mb_strlen($landNaam) > 120) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 120', mb_strlen($landNaam)), __LINE__);
        }
        if (is_null($landNaam) || (is_array($landNaam) && empty($landNaam))) {
            unset($this->landNaam);
        } else {
            $this->landNaam = $landNaam;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \RelatieApiV3\StructType\ProvinciecodeRecV3
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
