<?php

namespace RelatieApiV3\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LandcodetableV3 StructType
 * Meta information extracted from the WSDL
 * - documentation: Lijst met beschikbare landcodes
 * @subpackage Structs
 * @date 20200204
 * @package RelatieApiV3
 */
class LandcodetableV3 extends AbstractStructBase
{
    /**
     * The landcode
     * Meta information extracted from the WSDL
     * - documentation: Landcodes
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: false
     * @var \RelatieApiV3\StructType\LandcodeRecV3[]
     */
    public $landcode;
    /**
     * Constructor method for LandcodetableV3
     * @uses LandcodetableV3::setLandcode()
     * @param \RelatieApiV3\StructType\LandcodeRecV3[] $landcode
     */
    public function __construct(array $landcode = array())
    {
        $this
            ->setLandcode($landcode);
    }
    /**
     * Get landcode value
     * @return \RelatieApiV3\StructType\LandcodeRecV3[]|null
     */
    public function getLandcode()
    {
        return $this->landcode;
    }
    /**
     * This method is responsible for validating the values passed to the setLandcode method
     * This method is willingly generated in order to preserve the one-line inline validation within the setLandcode method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateLandcodeForArrayConstraintsFromSetLandcode(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $landcodetableV3LandcodeItem) {
            // validation for constraint: itemType
            if (!$landcodetableV3LandcodeItem instanceof \RelatieApiV3\StructType\LandcodeRecV3) {
                $invalidValues[] = is_object($landcodetableV3LandcodeItem) ? get_class($landcodetableV3LandcodeItem) : sprintf('%s(%s)', gettype($landcodetableV3LandcodeItem), var_export($landcodetableV3LandcodeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The landcode property can only contain items of type \RelatieApiV3\StructType\LandcodeRecV3, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set landcode value
     * @throws \InvalidArgumentException
     * @param \RelatieApiV3\StructType\LandcodeRecV3[] $landcode
     * @return \RelatieApiV3\StructType\LandcodetableV3
     */
    public function setLandcode(array $landcode = array())
    {
        // validation for constraint: array
        if ('' !== ($landcodeArrayErrorMessage = self::validateLandcodeForArrayConstraintsFromSetLandcode($landcode))) {
            throw new \InvalidArgumentException($landcodeArrayErrorMessage, __LINE__);
        }
        $this->landcode = $landcode;
        return $this;
    }
    /**
     * Add item to landcode value
     * @throws \InvalidArgumentException
     * @param \RelatieApiV3\StructType\LandcodeRecV3 $item
     * @return \RelatieApiV3\StructType\LandcodetableV3
     */
    public function addToLandcode(\RelatieApiV3\StructType\LandcodeRecV3 $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \RelatieApiV3\StructType\LandcodeRecV3) {
            throw new \InvalidArgumentException(sprintf('The landcode property can only contain items of type \RelatieApiV3\StructType\LandcodeRecV3, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->landcode[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \RelatieApiV3\StructType\LandcodetableV3
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
