<?php

namespace RelatieApiV3\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for getRelatietypeRequest StructType
 * Meta information extracted from the WSDL
 * - documentation: Bepalen wat voor type relatie aangemaakt is onder een bepaald relatienummer
 * @subpackage Structs
 * @date 20200204
 * @package RelatieApiV3
 */
class GetRelatietypeRequest extends AbstractStructBase
{
    /**
     * The relatienummer
     * Meta information extracted from the WSDL
     * - documentation: Het relatienummer van de relatie waarvoor het type bepaald moet worden
     * - base: xsd:integer
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * - totalDigits: 15
     * @var int
     */
    public $relatienummer;
    /**
     * The requestTag
     * Meta information extracted from the WSDL
     * - documentation: Vrij veld voor aanroepende partij. De inhoud van dit veld wordt altijd identiek teruggestuurd.
     * - base: xsd:string
     * - maxLength: 4000
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $requestTag;
    /**
     * Constructor method for getRelatietypeRequest
     * @uses GetRelatietypeRequest::setRelatienummer()
     * @uses GetRelatietypeRequest::setRequestTag()
     * @param int $relatienummer
     * @param string $requestTag
     */
    public function __construct($relatienummer = null, $requestTag = null)
    {
        $this
            ->setRelatienummer($relatienummer)
            ->setRequestTag($requestTag);
    }
    /**
     * Get relatienummer value
     * @return int
     */
    public function getRelatienummer()
    {
        return $this->relatienummer;
    }
    /**
     * Set relatienummer value
     * @param int $relatienummer
     * @return \RelatieApiV3\StructType\GetRelatietypeRequest
     */
    public function setRelatienummer($relatienummer = null)
    {
        // validation for constraint: int
        if (!is_null($relatienummer) && !(is_int($relatienummer) || ctype_digit($relatienummer))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($relatienummer, true), gettype($relatienummer)), __LINE__);
        }
        // validation for constraint: totalDigits(15)
        if (!is_null($relatienummer) && mb_strlen(preg_replace('/(\D)/', '', $relatienummer)) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 15 digits, "%d" given', var_export($relatienummer, true), mb_strlen(preg_replace('/(\D)/', '', $relatienummer))), __LINE__);
        }
        $this->relatienummer = $relatienummer;
        return $this;
    }
    /**
     * Get requestTag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRequestTag()
    {
        return isset($this->requestTag) ? $this->requestTag : null;
    }
    /**
     * Set requestTag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $requestTag
     * @return \RelatieApiV3\StructType\GetRelatietypeRequest
     */
    public function setRequestTag($requestTag = null)
    {
        // validation for constraint: string
        if (!is_null($requestTag) && !is_string($requestTag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($requestTag, true), gettype($requestTag)), __LINE__);
        }
        // validation for constraint: maxLength(4000)
        if (!is_null($requestTag) && mb_strlen($requestTag) > 4000) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 4000', mb_strlen($requestTag)), __LINE__);
        }
        if (is_null($requestTag) || (is_array($requestTag) && empty($requestTag))) {
            unset($this->requestTag);
        } else {
            $this->requestTag = $requestTag;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \RelatieApiV3\StructType\GetRelatietypeRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
