<?php

namespace RelatieApiV3\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for getIbanVanBankrekeningResponse StructType
 * Meta information extracted from the WSDL
 * - documentation: error63: Er is geen conversiepartner in Zeno opgegeven om een bankrekeningnummer naar een iban-rekeningnummer om te zetten | error37: Het opgegeven bankrekeningnummer voldoet niet aan de 11-proef
 * @subpackage Structs
 * @date 20200204
 * @package RelatieApiV3
 */
class GetIbanVanBankrekeningResponse extends AbstractStructBase
{
    /**
     * The requestTag
     * Meta information extracted from the WSDL
     * - documentation: Vrij veld voor aanroepende partij. De inhoud van dit veld wordt altijd identiek teruggestuurd.
     * - base: xsd:string
     * - maxLength: 4000
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $requestTag;
    /**
     * The iban
     * Meta information extracted from the WSDL
     * - documentation: Het IBAN rekeningnummer
     * - base: xsd:string
     * - maxLength: 34
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $iban;
    /**
     * The bic
     * Meta information extracted from the WSDL
     * - documentation: De BIC behorende bij het IBAN rekeningnummer
     * - base: xsd:string
     * - maxLength: 11
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $bic;
    /**
     * The partner
     * Meta information extracted from the WSDL
     * - documentation: De partij die het bankrekeningnummer heeft omgezet
     * - base: xsd:string
     * - maxLength: 4000
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $partner;
    /**
     * Constructor method for getIbanVanBankrekeningResponse
     * @uses GetIbanVanBankrekeningResponse::setRequestTag()
     * @uses GetIbanVanBankrekeningResponse::setIban()
     * @uses GetIbanVanBankrekeningResponse::setBic()
     * @uses GetIbanVanBankrekeningResponse::setPartner()
     * @param string $requestTag
     * @param string $iban
     * @param string $bic
     * @param string $partner
     */
    public function __construct($requestTag = null, $iban = null, $bic = null, $partner = null)
    {
        $this
            ->setRequestTag($requestTag)
            ->setIban($iban)
            ->setBic($bic)
            ->setPartner($partner);
    }
    /**
     * Get requestTag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRequestTag()
    {
        return isset($this->requestTag) ? $this->requestTag : null;
    }
    /**
     * Set requestTag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $requestTag
     * @return \RelatieApiV3\StructType\GetIbanVanBankrekeningResponse
     */
    public function setRequestTag($requestTag = null)
    {
        // validation for constraint: string
        if (!is_null($requestTag) && !is_string($requestTag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($requestTag, true), gettype($requestTag)), __LINE__);
        }
        // validation for constraint: maxLength(4000)
        if (!is_null($requestTag) && mb_strlen($requestTag) > 4000) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 4000', mb_strlen($requestTag)), __LINE__);
        }
        if (is_null($requestTag) || (is_array($requestTag) && empty($requestTag))) {
            unset($this->requestTag);
        } else {
            $this->requestTag = $requestTag;
        }
        return $this;
    }
    /**
     * Get iban value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIban()
    {
        return isset($this->iban) ? $this->iban : null;
    }
    /**
     * Set iban value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $iban
     * @return \RelatieApiV3\StructType\GetIbanVanBankrekeningResponse
     */
    public function setIban($iban = null)
    {
        // validation for constraint: string
        if (!is_null($iban) && !is_string($iban)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iban, true), gettype($iban)), __LINE__);
        }
        // validation for constraint: maxLength(34)
        if (!is_null($iban) && mb_strlen($iban) > 34) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 34', mb_strlen($iban)), __LINE__);
        }
        if (is_null($iban) || (is_array($iban) && empty($iban))) {
            unset($this->iban);
        } else {
            $this->iban = $iban;
        }
        return $this;
    }
    /**
     * Get bic value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBic()
    {
        return isset($this->bic) ? $this->bic : null;
    }
    /**
     * Set bic value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bic
     * @return \RelatieApiV3\StructType\GetIbanVanBankrekeningResponse
     */
    public function setBic($bic = null)
    {
        // validation for constraint: string
        if (!is_null($bic) && !is_string($bic)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bic, true), gettype($bic)), __LINE__);
        }
        // validation for constraint: maxLength(11)
        if (!is_null($bic) && mb_strlen($bic) > 11) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 11', mb_strlen($bic)), __LINE__);
        }
        if (is_null($bic) || (is_array($bic) && empty($bic))) {
            unset($this->bic);
        } else {
            $this->bic = $bic;
        }
        return $this;
    }
    /**
     * Get partner value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPartner()
    {
        return isset($this->partner) ? $this->partner : null;
    }
    /**
     * Set partner value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $partner
     * @return \RelatieApiV3\StructType\GetIbanVanBankrekeningResponse
     */
    public function setPartner($partner = null)
    {
        // validation for constraint: string
        if (!is_null($partner) && !is_string($partner)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($partner, true), gettype($partner)), __LINE__);
        }
        // validation for constraint: maxLength(4000)
        if (!is_null($partner) && mb_strlen($partner) > 4000) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 4000', mb_strlen($partner)), __LINE__);
        }
        if (is_null($partner) || (is_array($partner) && empty($partner))) {
            unset($this->partner);
        } else {
            $this->partner = $partner;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \RelatieApiV3\StructType\GetIbanVanBankrekeningResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
