<?php

namespace RelatieApiV3\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FunctieRecV3 StructType
 * Meta information extracted from the WSDL
 * - documentation: Functie code
 * @subpackage Structs
 * @date 20200204
 * @package RelatieApiV3
 */
class FunctieRecV3 extends AbstractStructBase
{
    /**
     * The functieCode
     * Meta information extracted from the WSDL
     * - documentation: Code voor de functie
     * - base: xsd:string
     * - maxLength: 12
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $functieCode;
    /**
     * The functieOmschrijving
     * Meta information extracted from the WSDL
     * - documentation: Omschrijving van de functie
     * - base: xsd:string
     * - maxLength: 120
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $functieOmschrijving;
    /**
     * Constructor method for FunctieRecV3
     * @uses FunctieRecV3::setFunctieCode()
     * @uses FunctieRecV3::setFunctieOmschrijving()
     * @param string $functieCode
     * @param string $functieOmschrijving
     */
    public function __construct($functieCode = null, $functieOmschrijving = null)
    {
        $this
            ->setFunctieCode($functieCode)
            ->setFunctieOmschrijving($functieOmschrijving);
    }
    /**
     * Get functieCode value
     * @return string
     */
    public function getFunctieCode()
    {
        return $this->functieCode;
    }
    /**
     * Set functieCode value
     * @param string $functieCode
     * @return \RelatieApiV3\StructType\FunctieRecV3
     */
    public function setFunctieCode($functieCode = null)
    {
        // validation for constraint: string
        if (!is_null($functieCode) && !is_string($functieCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($functieCode, true), gettype($functieCode)), __LINE__);
        }
        // validation for constraint: maxLength(12)
        if (!is_null($functieCode) && mb_strlen($functieCode) > 12) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 12', mb_strlen($functieCode)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($functieCode) && mb_strlen($functieCode) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($functieCode)), __LINE__);
        }
        $this->functieCode = $functieCode;
        return $this;
    }
    /**
     * Get functieOmschrijving value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFunctieOmschrijving()
    {
        return isset($this->functieOmschrijving) ? $this->functieOmschrijving : null;
    }
    /**
     * Set functieOmschrijving value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $functieOmschrijving
     * @return \RelatieApiV3\StructType\FunctieRecV3
     */
    public function setFunctieOmschrijving($functieOmschrijving = null)
    {
        // validation for constraint: string
        if (!is_null($functieOmschrijving) && !is_string($functieOmschrijving)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($functieOmschrijving, true), gettype($functieOmschrijving)), __LINE__);
        }
        // validation for constraint: maxLength(120)
        if (!is_null($functieOmschrijving) && mb_strlen($functieOmschrijving) > 120) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 120', mb_strlen($functieOmschrijving)), __LINE__);
        }
        if (is_null($functieOmschrijving) || (is_array($functieOmschrijving) && empty($functieOmschrijving))) {
            unset($this->functieOmschrijving);
        } else {
            $this->functieOmschrijving = $functieOmschrijving;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \RelatieApiV3\StructType\FunctieRecV3
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
