<?php

namespace RelatieApiV3\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for deleteContPersoonNrContactRequest StructType
 * Meta information extracted from the WSDL
 * - documentation: Haalt de verwijzing van een contactpersoon naar een bedrijf leeg (en wordt dus een privÃ©persoon)
 * @subpackage Structs
 * @date 20200204
 * @package RelatieApiV3
 */
class DeleteContPersoonNrContactRequest extends AbstractStructBase
{
    /**
     * The relatienummerBestaandBedrijf
     * Meta information extracted from the WSDL
     * - documentation: Het relatienummer van het huidige bedrijf van de contactpersoon.
     * - base: xsd:integer
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * - totalDigits: 15
     * @var int
     */
    public $relatienummerBestaandBedrijf;
    /**
     * The relatienummerPersoon
     * Meta information extracted from the WSDL
     * - documentation: Het relatienummer van de contactpersoon.
     * - base: xsd:integer
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * - totalDigits: 15
     * @var int
     */
    public $relatienummerPersoon;
    /**
     * The requestTag
     * Meta information extracted from the WSDL
     * - documentation: Vrij veld voor aanroepende partij. De inhoud van dit veld wordt altijd identiek teruggestuurd.
     * - base: xsd:string
     * - maxLength: 4000
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $requestTag;
    /**
     * Constructor method for deleteContPersoonNrContactRequest
     * @uses DeleteContPersoonNrContactRequest::setRelatienummerBestaandBedrijf()
     * @uses DeleteContPersoonNrContactRequest::setRelatienummerPersoon()
     * @uses DeleteContPersoonNrContactRequest::setRequestTag()
     * @param int $relatienummerBestaandBedrijf
     * @param int $relatienummerPersoon
     * @param string $requestTag
     */
    public function __construct($relatienummerBestaandBedrijf = null, $relatienummerPersoon = null, $requestTag = null)
    {
        $this
            ->setRelatienummerBestaandBedrijf($relatienummerBestaandBedrijf)
            ->setRelatienummerPersoon($relatienummerPersoon)
            ->setRequestTag($requestTag);
    }
    /**
     * Get relatienummerBestaandBedrijf value
     * @return int
     */
    public function getRelatienummerBestaandBedrijf()
    {
        return $this->relatienummerBestaandBedrijf;
    }
    /**
     * Set relatienummerBestaandBedrijf value
     * @param int $relatienummerBestaandBedrijf
     * @return \RelatieApiV3\StructType\DeleteContPersoonNrContactRequest
     */
    public function setRelatienummerBestaandBedrijf($relatienummerBestaandBedrijf = null)
    {
        // validation for constraint: int
        if (!is_null($relatienummerBestaandBedrijf) && !(is_int($relatienummerBestaandBedrijf) || ctype_digit($relatienummerBestaandBedrijf))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($relatienummerBestaandBedrijf, true), gettype($relatienummerBestaandBedrijf)), __LINE__);
        }
        // validation for constraint: totalDigits(15)
        if (!is_null($relatienummerBestaandBedrijf) && mb_strlen(preg_replace('/(\D)/', '', $relatienummerBestaandBedrijf)) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 15 digits, "%d" given', var_export($relatienummerBestaandBedrijf, true), mb_strlen(preg_replace('/(\D)/', '', $relatienummerBestaandBedrijf))), __LINE__);
        }
        $this->relatienummerBestaandBedrijf = $relatienummerBestaandBedrijf;
        return $this;
    }
    /**
     * Get relatienummerPersoon value
     * @return int
     */
    public function getRelatienummerPersoon()
    {
        return $this->relatienummerPersoon;
    }
    /**
     * Set relatienummerPersoon value
     * @param int $relatienummerPersoon
     * @return \RelatieApiV3\StructType\DeleteContPersoonNrContactRequest
     */
    public function setRelatienummerPersoon($relatienummerPersoon = null)
    {
        // validation for constraint: int
        if (!is_null($relatienummerPersoon) && !(is_int($relatienummerPersoon) || ctype_digit($relatienummerPersoon))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($relatienummerPersoon, true), gettype($relatienummerPersoon)), __LINE__);
        }
        // validation for constraint: totalDigits(15)
        if (!is_null($relatienummerPersoon) && mb_strlen(preg_replace('/(\D)/', '', $relatienummerPersoon)) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 15 digits, "%d" given', var_export($relatienummerPersoon, true), mb_strlen(preg_replace('/(\D)/', '', $relatienummerPersoon))), __LINE__);
        }
        $this->relatienummerPersoon = $relatienummerPersoon;
        return $this;
    }
    /**
     * Get requestTag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRequestTag()
    {
        return isset($this->requestTag) ? $this->requestTag : null;
    }
    /**
     * Set requestTag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $requestTag
     * @return \RelatieApiV3\StructType\DeleteContPersoonNrContactRequest
     */
    public function setRequestTag($requestTag = null)
    {
        // validation for constraint: string
        if (!is_null($requestTag) && !is_string($requestTag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($requestTag, true), gettype($requestTag)), __LINE__);
        }
        // validation for constraint: maxLength(4000)
        if (!is_null($requestTag) && mb_strlen($requestTag) > 4000) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 4000', mb_strlen($requestTag)), __LINE__);
        }
        if (is_null($requestTag) || (is_array($requestTag) && empty($requestTag))) {
            unset($this->requestTag);
        } else {
            $this->requestTag = $requestTag;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \RelatieApiV3\StructType\DeleteContPersoonNrContactRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
