<?php

namespace RelatieApiV3\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BetaalRecV3 StructType
 * Meta information extracted from the WSDL
 * - documentation: Betaal info.
 * @subpackage Structs
 * @date 20200204
 * @package RelatieApiV3
 */
class BetaalRecV3 extends AbstractStructBase
{
    /**
     * The betaalwijze
     * Meta information extracted from the WSDL
     * - documentation: Betaalwijze (0=Factuur, 1=Automatische incasso, 3=Eenmalige iDeal, 4=Factuur per mail)
     * - base: xsd:integer
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * - totalDigits: 1
     * @var int
     */
    public $betaalwijze;
    /**
     * The bankrekeningnummer
     * Meta information extracted from the WSDL
     * - documentation: Bankrekeningnummer (indien betaalwijze = Automatische incasso en geen gebruik SEPA, dan verplicht)
     * - base: xsd:string
     * - maxLength: 15
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $bankrekeningnummer;
    /**
     * The ibannummer
     * Meta information extracted from the WSDL
     * - documentation: Iban nummer (indien betaalwijze = Automatische incasso en gebruik SEPA, dan verplicht)
     * - base: xsd:string
     * - maxLength: 34
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ibannummer;
    /**
     * The bicCode
     * Meta information extracted from the WSDL
     * - documentation: Bic code ((indien betaalwijze = Automatische incasso en gebruik SEPA, niet verplicht)
     * - base: xsd:string
     * - maxLength: 11
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $bicCode;
    /**
     * Constructor method for BetaalRecV3
     * @uses BetaalRecV3::setBetaalwijze()
     * @uses BetaalRecV3::setBankrekeningnummer()
     * @uses BetaalRecV3::setIbannummer()
     * @uses BetaalRecV3::setBicCode()
     * @param int $betaalwijze
     * @param string $bankrekeningnummer
     * @param string $ibannummer
     * @param string $bicCode
     */
    public function __construct($betaalwijze = null, $bankrekeningnummer = null, $ibannummer = null, $bicCode = null)
    {
        $this
            ->setBetaalwijze($betaalwijze)
            ->setBankrekeningnummer($bankrekeningnummer)
            ->setIbannummer($ibannummer)
            ->setBicCode($bicCode);
    }
    /**
     * Get betaalwijze value
     * @return int
     */
    public function getBetaalwijze()
    {
        return $this->betaalwijze;
    }
    /**
     * Set betaalwijze value
     * @param int $betaalwijze
     * @return \RelatieApiV3\StructType\BetaalRecV3
     */
    public function setBetaalwijze($betaalwijze = null)
    {
        // validation for constraint: int
        if (!is_null($betaalwijze) && !(is_int($betaalwijze) || ctype_digit($betaalwijze))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($betaalwijze, true), gettype($betaalwijze)), __LINE__);
        }
        // validation for constraint: totalDigits(1)
        if (!is_null($betaalwijze) && mb_strlen(preg_replace('/(\D)/', '', $betaalwijze)) > 1) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 1 digits, "%d" given', var_export($betaalwijze, true), mb_strlen(preg_replace('/(\D)/', '', $betaalwijze))), __LINE__);
        }
        $this->betaalwijze = $betaalwijze;
        return $this;
    }
    /**
     * Get bankrekeningnummer value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBankrekeningnummer()
    {
        return isset($this->bankrekeningnummer) ? $this->bankrekeningnummer : null;
    }
    /**
     * Set bankrekeningnummer value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bankrekeningnummer
     * @return \RelatieApiV3\StructType\BetaalRecV3
     */
    public function setBankrekeningnummer($bankrekeningnummer = null)
    {
        // validation for constraint: string
        if (!is_null($bankrekeningnummer) && !is_string($bankrekeningnummer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bankrekeningnummer, true), gettype($bankrekeningnummer)), __LINE__);
        }
        // validation for constraint: maxLength(15)
        if (!is_null($bankrekeningnummer) && mb_strlen($bankrekeningnummer) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 15', mb_strlen($bankrekeningnummer)), __LINE__);
        }
        if (is_null($bankrekeningnummer) || (is_array($bankrekeningnummer) && empty($bankrekeningnummer))) {
            unset($this->bankrekeningnummer);
        } else {
            $this->bankrekeningnummer = $bankrekeningnummer;
        }
        return $this;
    }
    /**
     * Get ibannummer value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIbannummer()
    {
        return isset($this->ibannummer) ? $this->ibannummer : null;
    }
    /**
     * Set ibannummer value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ibannummer
     * @return \RelatieApiV3\StructType\BetaalRecV3
     */
    public function setIbannummer($ibannummer = null)
    {
        // validation for constraint: string
        if (!is_null($ibannummer) && !is_string($ibannummer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ibannummer, true), gettype($ibannummer)), __LINE__);
        }
        // validation for constraint: maxLength(34)
        if (!is_null($ibannummer) && mb_strlen($ibannummer) > 34) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 34', mb_strlen($ibannummer)), __LINE__);
        }
        if (is_null($ibannummer) || (is_array($ibannummer) && empty($ibannummer))) {
            unset($this->ibannummer);
        } else {
            $this->ibannummer = $ibannummer;
        }
        return $this;
    }
    /**
     * Get bicCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBicCode()
    {
        return isset($this->bicCode) ? $this->bicCode : null;
    }
    /**
     * Set bicCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bicCode
     * @return \RelatieApiV3\StructType\BetaalRecV3
     */
    public function setBicCode($bicCode = null)
    {
        // validation for constraint: string
        if (!is_null($bicCode) && !is_string($bicCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bicCode, true), gettype($bicCode)), __LINE__);
        }
        // validation for constraint: maxLength(11)
        if (!is_null($bicCode) && mb_strlen($bicCode) > 11) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 11', mb_strlen($bicCode)), __LINE__);
        }
        if (is_null($bicCode) || (is_array($bicCode) && empty($bicCode))) {
            unset($this->bicCode);
        } else {
            $this->bicCode = $bicCode;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \RelatieApiV3\StructType\BetaalRecV3
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
