<?php

namespace RelatieApiV3\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for addBicRequest StructType
 * Meta information extracted from the WSDL
 * - documentation: Toevoegen van een Bic code aan een bestaande relatie in Zeno op basis van relatienummer en Bic-code
 * @subpackage Structs
 * @date 20200204
 * @package RelatieApiV3
 */
class AddBicRequest extends AbstractStructBase
{
    /**
     * The relatieNummer
     * Meta information extracted from the WSDL
     * - documentation: Het unieke Zeno relatienummer.
     * - base: xsd:integer
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * - totalDigits: 15
     * @var int
     */
    public $relatieNummer;
    /**
     * The bicCode
     * Meta information extracted from the WSDL
     * - documentation: De te koppelen Bic code (zie getBiccodes).
     * - base: xsd:string
     * - maxLength: 20
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $bicCode;
    /**
     * The requestTag
     * Meta information extracted from the WSDL
     * - documentation: Vrij veld voor aanroepende partij. De inhoud van dit veld wordt altijd identiek teruggestuurd.
     * - base: xsd:string
     * - maxLength: 4000
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $requestTag;
    /**
     * Constructor method for addBicRequest
     * @uses AddBicRequest::setRelatieNummer()
     * @uses AddBicRequest::setBicCode()
     * @uses AddBicRequest::setRequestTag()
     * @param int $relatieNummer
     * @param string $bicCode
     * @param string $requestTag
     */
    public function __construct($relatieNummer = null, $bicCode = null, $requestTag = null)
    {
        $this
            ->setRelatieNummer($relatieNummer)
            ->setBicCode($bicCode)
            ->setRequestTag($requestTag);
    }
    /**
     * Get relatieNummer value
     * @return int
     */
    public function getRelatieNummer()
    {
        return $this->relatieNummer;
    }
    /**
     * Set relatieNummer value
     * @param int $relatieNummer
     * @return \RelatieApiV3\StructType\AddBicRequest
     */
    public function setRelatieNummer($relatieNummer = null)
    {
        // validation for constraint: int
        if (!is_null($relatieNummer) && !(is_int($relatieNummer) || ctype_digit($relatieNummer))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($relatieNummer, true), gettype($relatieNummer)), __LINE__);
        }
        // validation for constraint: totalDigits(15)
        if (!is_null($relatieNummer) && mb_strlen(preg_replace('/(\D)/', '', $relatieNummer)) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 15 digits, "%d" given', var_export($relatieNummer, true), mb_strlen(preg_replace('/(\D)/', '', $relatieNummer))), __LINE__);
        }
        $this->relatieNummer = $relatieNummer;
        return $this;
    }
    /**
     * Get bicCode value
     * @return string
     */
    public function getBicCode()
    {
        return $this->bicCode;
    }
    /**
     * Set bicCode value
     * @param string $bicCode
     * @return \RelatieApiV3\StructType\AddBicRequest
     */
    public function setBicCode($bicCode = null)
    {
        // validation for constraint: string
        if (!is_null($bicCode) && !is_string($bicCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bicCode, true), gettype($bicCode)), __LINE__);
        }
        // validation for constraint: maxLength(20)
        if (!is_null($bicCode) && mb_strlen($bicCode) > 20) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 20', mb_strlen($bicCode)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($bicCode) && mb_strlen($bicCode) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($bicCode)), __LINE__);
        }
        $this->bicCode = $bicCode;
        return $this;
    }
    /**
     * Get requestTag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRequestTag()
    {
        return isset($this->requestTag) ? $this->requestTag : null;
    }
    /**
     * Set requestTag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $requestTag
     * @return \RelatieApiV3\StructType\AddBicRequest
     */
    public function setRequestTag($requestTag = null)
    {
        // validation for constraint: string
        if (!is_null($requestTag) && !is_string($requestTag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($requestTag, true), gettype($requestTag)), __LINE__);
        }
        // validation for constraint: maxLength(4000)
        if (!is_null($requestTag) && mb_strlen($requestTag) > 4000) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 4000', mb_strlen($requestTag)), __LINE__);
        }
        if (is_null($requestTag) || (is_array($requestTag) && empty($requestTag))) {
            unset($this->requestTag);
        } else {
            $this->requestTag = $requestTag;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \RelatieApiV3\StructType\AddBicRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
