<?php

namespace RelatieApiV3\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Get ServiceType
 * @subpackage Services
 * @date 20200204
 * @package RelatieApiV3
 */
class Get extends AbstractSoapClientBase
{
    /**
     * Sets the Authentication SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \RelatieApiV3\StructType\Authentication $authentication
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderAuthentication(\RelatieApiV3\StructType\Authentication $authentication, $nameSpace = 'http://zeno.socho.nl', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'authentication', $authentication, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named getFuncties
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: authentication
     * - SOAPHeaderNamespaces: http://zeno.socho.nl
     * - SOAPHeaderTypes: \RelatieApiV3\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Ophalen van beschikbare functies die aan een relatie te koppelen zijnerror42: Er zijn geen functies gevonden
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \RelatieApiV3\StructType\GetFunctiesRequest $request_parameters
     * @return \RelatieApiV3\StructType\GetFunctiesResponse|bool
     */
    public function getFuncties(\RelatieApiV3\StructType\GetFunctiesRequest $request_parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getFuncties($request_parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getBiccodes
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: authentication
     * - SOAPHeaderNamespaces: http://zeno.socho.nl
     * - SOAPHeaderTypes: \RelatieApiV3\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Ophalen van beschikbare Bic-codes die aan een relatie te koppelen zijnerror43: Er zijn geen Bic-codes gevonden
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \RelatieApiV3\StructType\GetBiccodesRequest $request_parameters
     * @return \RelatieApiV3\StructType\GetBiccodesResponse|bool
     */
    public function getBiccodes(\RelatieApiV3\StructType\GetBiccodesRequest $request_parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getBiccodes($request_parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getTitulatuurcodes
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: authentication
     * - SOAPHeaderNamespaces: http://zeno.socho.nl
     * - SOAPHeaderTypes: \RelatieApiV3\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Ophalen van beschikbare Bic-codes die aan een relatie te koppelen zijnerror44: Er zijn geen Titulatuur-codes gevonden
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \RelatieApiV3\StructType\GetTitulatuurcodesRequest $request_parameters
     * @return \RelatieApiV3\StructType\GetTitulatuurcodesResponse|bool
     */
    public function getTitulatuurcodes(\RelatieApiV3\StructType\GetTitulatuurcodesRequest $request_parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getTitulatuurcodes($request_parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getLandcodes
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: authentication
     * - SOAPHeaderNamespaces: http://zeno.socho.nl
     * - SOAPHeaderTypes: \RelatieApiV3\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Ophalen van beschikbare landcodes die bij een relatie als land opgenomen kunnen wordenerror45: Er zijn geen Landcodes gevonden
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \RelatieApiV3\StructType\GetLandcodesRequest $request_parameters
     * @return \RelatieApiV3\StructType\GetLandcodesResponse|bool
     */
    public function getLandcodes(\RelatieApiV3\StructType\GetLandcodesRequest $request_parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getLandcodes($request_parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getTaalcodes
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: authentication
     * - SOAPHeaderNamespaces: http://zeno.socho.nl
     * - SOAPHeaderTypes: \RelatieApiV3\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Ophalen van beschikbare taalcodes die bij een relatie als taal opgenomen kunnen wordenerror105: Er zijn geen Taalcodes gevonden
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \RelatieApiV3\StructType\GetTaalcodesRequest $request_parameters
     * @return \RelatieApiV3\StructType\GetTaalcodesResponse|bool
     */
    public function getTaalcodes(\RelatieApiV3\StructType\GetTaalcodesRequest $request_parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getTaalcodes($request_parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getProvinciecodes
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: authentication
     * - SOAPHeaderNamespaces: http://zeno.socho.nl
     * - SOAPHeaderTypes: \RelatieApiV3\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Ophalen van beschikbare provinciecodes die bij een relatie als provincie opgenomen kunnen wordenerror46: Er zijn geen Provinciecodes gevonden
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \RelatieApiV3\StructType\GetProvinciecodesRequest $request_parameters
     * @return \RelatieApiV3\StructType\GetProvinciecodesResponse|bool
     */
    public function getProvinciecodes(\RelatieApiV3\StructType\GetProvinciecodesRequest $request_parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getProvinciecodes($request_parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getRelatietype
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: authentication
     * - SOAPHeaderNamespaces: http://zeno.socho.nl
     * - SOAPHeaderTypes: \RelatieApiV3\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Bepalen wat voor type relatie aangemaakt is onder een bepaald relatienummererror15: Er is geen relatienummer opgegevenerror16: Op basis van het relatienummer is geen relatie gevonden
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \RelatieApiV3\StructType\GetRelatietypeRequest $request_parameters
     * @return \RelatieApiV3\StructType\GetRelatietypeResponse|bool
     */
    public function getRelatietype(\RelatieApiV3\StructType\GetRelatietypeRequest $request_parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getRelatietype($request_parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getPersoon
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: authentication
     * - SOAPHeaderNamespaces: http://zeno.socho.nl
     * - SOAPHeaderTypes: \RelatieApiV3\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Ophalen van de gegevens van een persoonerror15: Er is geen relatienummer opgegevenerror16: Op basis van het relatienummer is geen relatie gevonden
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \RelatieApiV3\StructType\GetPersoonRequest $request_parameters
     * @return \RelatieApiV3\StructType\GetPersoonResponse|bool
     */
    public function getPersoon(\RelatieApiV3\StructType\GetPersoonRequest $request_parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getPersoon($request_parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getPersonen
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: authentication
     * - SOAPHeaderNamespaces: http://zeno.socho.nl
     * - SOAPHeaderTypes: \RelatieApiV3\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Ophalen van een lijst met gegevens van een persoonerror15: Er is geen relatienummer opgegevenerror16: Op basis van het relatienummer is geen relatie gevonden
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \RelatieApiV3\StructType\GetPersonenRequest $request_parameters
     * @return \RelatieApiV3\StructType\GetPersonenResponse|bool
     */
    public function getPersonen(\RelatieApiV3\StructType\GetPersonenRequest $request_parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getPersonen($request_parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getBedrijf
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: authentication
     * - SOAPHeaderNamespaces: http://zeno.socho.nl
     * - SOAPHeaderTypes: \RelatieApiV3\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Ophalen van de gegevens van een bedrijferror15: Er is geen relatienummer opgegevenerror16: Op basis van het relatienummer is geen relatie gevondenerror68: De relatie met het opgegeven relatienummer is niet van het type 'Persoon'.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \RelatieApiV3\StructType\GetBedrijfRequest $request_parameters
     * @return \RelatieApiV3\StructType\GetBedrijfResponse|bool
     */
    public function getBedrijf(\RelatieApiV3\StructType\GetBedrijfRequest $request_parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getBedrijf($request_parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getContactpersoon
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: authentication
     * - SOAPHeaderNamespaces: http://zeno.socho.nl
     * - SOAPHeaderTypes: \RelatieApiV3\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Ophalen van de gegevens van een contactpersoonerror15: Er is geen relatienummer opgegevenerror16: Op basis van het relatienummer is geen relatie gevondenerror69: De relatie met het opgegeven relatienummer is niet van het type
     * 'Bedrijf'.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \RelatieApiV3\StructType\GetContactpersoonRequest $request_parameters
     * @return \RelatieApiV3\StructType\GetContactpersoonResponse|bool
     */
    public function getContactpersoon(\RelatieApiV3\StructType\GetContactpersoonRequest $request_parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getContactpersoon($request_parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getAfdeling
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: authentication
     * - SOAPHeaderNamespaces: http://zeno.socho.nl
     * - SOAPHeaderTypes: \RelatieApiV3\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Ophalen van de gegevens van een afdelingerror15: Er is geen relatienummer opgegevenerror16: Op basis van het relatienummer is geen relatie gevondenerror70: De relatie met het opgegeven relatienummer is niet van het type
     * 'Contactpersoon'.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \RelatieApiV3\StructType\GetAfdelingRequest $request_parameters
     * @return \RelatieApiV3\StructType\GetAfdelingResponse|bool
     */
    public function getAfdeling(\RelatieApiV3\StructType\GetAfdelingRequest $request_parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getAfdeling($request_parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getBedrijfInclCont
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: authentication
     * - SOAPHeaderNamespaces: http://zeno.socho.nl
     * - SOAPHeaderTypes: \RelatieApiV3\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Ophalen van de gegevens van een gecombineerde bedrijf en/of contactpersoon relatie (waarbij zowel bedrijf als persoonsgegevens op 1 relatiekaart staan). Kan alleen gebruikt worden indien systeem-constante "Invoer van bedrijven op de
     * relatiekaart inclusief contactpersoon" geactiveerd is.error15: Er is geen relatienummer opgegevenerror16: Op basis van het relatienummer is geen relatie gevondenerror106: Zeno is niet ingesteld om te werken met relatiekaarten met gecombineerde
     * bedrijf en persoons gegevenserror109: De relatie met het opgegeven relatienummer is niet van het type 'Bedrijf inclusief contactpersoon'
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \RelatieApiV3\StructType\GetBedrijfInclContRequest $request_parameters
     * @return \RelatieApiV3\StructType\GetBedrijfInclContResponse|bool
     */
    public function getBedrijfInclCont(\RelatieApiV3\StructType\GetBedrijfInclContRequest $request_parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getBedrijfInclCont($request_parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getRelatieKortinggroepen
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: authentication
     * - SOAPHeaderNamespaces: http://zeno.socho.nl
     * - SOAPHeaderTypes: \RelatieApiV3\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Ophalen van een lijst met beschikbare relatiekortinggroepenerror47: Er zijn geen relatiekortinggroepen gevonden
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \RelatieApiV3\StructType\GetRelatieKortinggroepenRequest $request_parameters
     * @return \RelatieApiV3\StructType\GetRelatieKortinggroepenResponse|bool
     */
    public function getRelatieKortinggroepen(\RelatieApiV3\StructType\GetRelatieKortinggroepenRequest $request_parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getRelatieKortinggroepen($request_parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getNetnummers
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: authentication
     * - SOAPHeaderNamespaces: http://zeno.socho.nl
     * - SOAPHeaderTypes: \RelatieApiV3\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Ophalen van een lijst met beschikbare netnummers
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \RelatieApiV3\StructType\GetNetnummersRequest $request_parameters
     * @return \RelatieApiV3\StructType\GetNetnummersResponse|bool
     */
    public function getNetnummers(\RelatieApiV3\StructType\GetNetnummersRequest $request_parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getNetnummers($request_parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getActiviteittypen
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: authentication
     * - SOAPHeaderNamespaces: http://zeno.socho.nl
     * - SOAPHeaderTypes: \RelatieApiV3\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Ophalen van een lijst met beschikbare activiteittypen
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \RelatieApiV3\StructType\GetActiviteittypenRequest $request_parameters
     * @return \RelatieApiV3\StructType\GetActiviteittypenResponse|bool
     */
    public function getActiviteittypen(\RelatieApiV3\StructType\GetActiviteittypenRequest $request_parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getActiviteittypen($request_parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getAdres
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: authentication
     * - SOAPHeaderNamespaces: http://zeno.socho.nl
     * - SOAPHeaderTypes: \RelatieApiV3\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Ophalen van het adres voor een relatie. Hierbij wordt gebruik gemaakt van de 'etiket' functionaliteit van Zeno. In geval de relatie een contactpersoon of afdeling van een bedrijf is, en er bij de contactpersoon of afdeling geen adres
     * opgegeven is, wordt het adres van het bedrijf afgehaald. <BR><BR> Ook zal bijvoorbeeld bij opvragen van het correspondentieadres het bezoekadres geretourneerd worden indien alleen een bezoekadres opgegeven is.<BR><BR> N.B. Aangezien het adres
     * mogelijk vanaf een andere relatie (het bedrijf) opgehaald kan worden dan het opgegeven relatienummer dient het geretourneerde adres in geen geval gebruikt te worden voor het bijwerken van de relatie behorende bij het opgegeven relatienummer.error16:
     * Op basis van het relatienummer is geen relatie gevondenerror60: Het opgegeven adrestype is onbekend
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \RelatieApiV3\StructType\GetAdresRequest $request_parameters
     * @return \RelatieApiV3\StructType\GetAdresResponse|bool
     */
    public function getAdres(\RelatieApiV3\StructType\GetAdresRequest $request_parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getAdres($request_parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getBicVanIban
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: authentication
     * - SOAPHeaderNamespaces: http://zeno.socho.nl
     * - SOAPHeaderTypes: \RelatieApiV3\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Geeft de BIC van de bank terug adhv een IBAN-rekeningnummererror39: Het opgegeven IBAN nummer voldoet niet aan de eisenerror62: Kan geen BIC vinden op basis van het opgegeven IBAN rekeningnummer.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \RelatieApiV3\StructType\GetBicVanIbanRequest $request_parameters
     * @return \RelatieApiV3\StructType\GetBicVanIbanResponse|bool
     */
    public function getBicVanIban(\RelatieApiV3\StructType\GetBicVanIbanRequest $request_parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getBicVanIban($request_parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getIbanVanBankrekening
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: authentication
     * - SOAPHeaderNamespaces: http://zeno.socho.nl
     * - SOAPHeaderTypes: \RelatieApiV3\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Geeft van een opgegeven bankrekening, de IBAN en BIC gegevens terug.<br/> Afhankelijk van wat er in Zeno is ingesteld, wordt dit via iban-converteren.nl of via openiban.nl bepaald.error37: Het opgegeven bankrekeningnummer voldoet
     * niet aan de 11-proeferror63: Er is geen conversiepartner in Zeno opgegeven om een bankrekeningnummer naar een iban-rekeningnummer om te zetten
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \RelatieApiV3\StructType\GetIbanVanBankrekeningRequest $request_parameters
     * @return \RelatieApiV3\StructType\GetIbanVanBankrekeningResponse|bool
     */
    public function getIbanVanBankrekening(\RelatieApiV3\StructType\GetIbanVanBankrekeningRequest $request_parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getIbanVanBankrekening($request_parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getSmartcodeByRelNo
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: authentication
     * - SOAPHeaderNamespaces: http://zeno.socho.nl
     * - SOAPHeaderTypes: \RelatieApiV3\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Geeft de smartcode van een relatie nummer terug.error104: Op basis van het relatie nummer is geen smartcode gevonden
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \RelatieApiV3\StructType\GetSmartcodeByRelNoRequest $request_parameters
     * @return \RelatieApiV3\StructType\GetSmartcodeByRelNoResponse|bool
     */
    public function getSmartcodeByRelNo(\RelatieApiV3\StructType\GetSmartcodeByRelNoRequest $request_parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getSmartcodeByRelNo($request_parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getKenmerken
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: authentication
     * - SOAPHeaderNamespaces: http://zeno.socho.nl
     * - SOAPHeaderTypes: \RelatieApiV3\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Geeft de beschikbare kenmerk-stamgegevens terugerror1110: Er is een onbekende kenmerkgroep meegegevenerror1111: De opgegeven kenmerkgroep is niet-actief
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \RelatieApiV3\StructType\GetKenmerkenRequest $request_parameters
     * @return \RelatieApiV3\StructType\GetKenmerkenResponse|bool
     */
    public function getKenmerken(\RelatieApiV3\StructType\GetKenmerkenRequest $request_parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getKenmerken($request_parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \RelatieApiV3\StructType\GetActiviteittypenResponse|\RelatieApiV3\StructType\GetAdresResponse|\RelatieApiV3\StructType\GetAfdelingResponse|\RelatieApiV3\StructType\GetBedrijfInclContResponse|\RelatieApiV3\StructType\GetBedrijfResponse|\RelatieApiV3\StructType\GetBiccodesResponse|\RelatieApiV3\StructType\GetBicVanIbanResponse|\RelatieApiV3\StructType\GetContactpersoonResponse|\RelatieApiV3\StructType\GetFunctiesResponse|\RelatieApiV3\StructType\GetIbanVanBankrekeningResponse|\RelatieApiV3\StructType\GetKenmerkenResponse|\RelatieApiV3\StructType\GetLandcodesResponse|\RelatieApiV3\StructType\GetNetnummersResponse|\RelatieApiV3\StructType\GetPersonenResponse|\RelatieApiV3\StructType\GetPersoonResponse|\RelatieApiV3\StructType\GetProvinciecodesResponse|\RelatieApiV3\StructType\GetRelatieKortinggroepenResponse|\RelatieApiV3\StructType\GetRelatietypeResponse|\RelatieApiV3\StructType\GetSmartcodeByRelNoResponse|\RelatieApiV3\StructType\GetTaalcodesResponse|\RelatieApiV3\StructType\GetTitulatuurcodesResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
