<?php

namespace RelatieApiV3\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Delete ServiceType
 * @subpackage Services
 * @date 20200204
 * @package RelatieApiV3
 */
class Delete extends AbstractSoapClientBase
{
    /**
     * Sets the Authentication SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \RelatieApiV3\StructType\Authentication $authentication
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderAuthentication(\RelatieApiV3\StructType\Authentication $authentication, $nameSpace = 'http://zeno.socho.nl', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'authentication', $authentication, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named deleteContPersoonNrContact
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: authentication
     * - SOAPHeaderNamespaces: http://zeno.socho.nl
     * - SOAPHeaderTypes: \RelatieApiV3\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Haalt de verwijzing van een contactpersoon naar een bedrijf leeg (en wordt dus een privÃ©persoon)error15: Er is geen relatienummer opgegevenerror16: Op basis van het relatienummer is geen relatie gevondenerror17: Op basis van het
     * relatienummer bedrijf is geen relatie gevondenerror19: Persoon is als contactpersoon aan een ander bedrijf gekoppeld dan relatienummer_bestand_bedrijferror20: De opgegeven persoon is reeds een privÃ© persoon
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \RelatieApiV3\StructType\DeleteContPersoonNrContactRequest $request_parameters
     * @return \RelatieApiV3\StructType\DeleteContPersoonNrContactResponse|bool
     */
    public function deleteContPersoonNrContact(\RelatieApiV3\StructType\DeleteContPersoonNrContactRequest $request_parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->deleteContPersoonNrContact($request_parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named deleteBic
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: authentication
     * - SOAPHeaderNamespaces: http://zeno.socho.nl
     * - SOAPHeaderTypes: \RelatieApiV3\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Verwijderen van een gekoppelde Bic code bij een relatieerror27: Er is geen unieke sleutel voor de koppeling van relatie aan biccode opgegevenerror28: De opgegeven koppeling van relatie aan biccode is niet gevonden
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \RelatieApiV3\StructType\DeleteBicRequest $request_parameters
     * @return \RelatieApiV3\StructType\DeleteBicResponse|bool
     */
    public function deleteBic(\RelatieApiV3\StructType\DeleteBicRequest $request_parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->deleteBic($request_parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named deleteFunctie
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: authentication
     * - SOAPHeaderNamespaces: http://zeno.socho.nl
     * - SOAPHeaderTypes: \RelatieApiV3\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Verwijderen van een gekoppelde functie bij een relatieerror33: Er is geen unieke sleutel voor de koppeling van relatie aan functie opgegevenerror34: De opgegeven koppeling van relatie aan functie is niet gevonden
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \RelatieApiV3\StructType\DeleteFunctieRequest $request_parameters
     * @return \RelatieApiV3\StructType\DeleteFunctieResponse|bool
     */
    public function deleteFunctie(\RelatieApiV3\StructType\DeleteFunctieRequest $request_parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->deleteFunctie($request_parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \RelatieApiV3\StructType\DeleteBicResponse|\RelatieApiV3\StructType\DeleteContPersoonNrContactResponse|\RelatieApiV3\StructType\DeleteFunctieResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
